/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<E, V> {
    private V value;
    private Map<E, Graph<E, V>> edgeMap;

    public Graph(V value) {
        this.value = value;
        this.edgeMap = new HashMap<E, Graph<E, V>>();
    }

    public Graph() {
        this(null);
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void setGraph(E edge, Graph<E, V> graph) {
        this.edgeMap.put(edge, graph);
    }

    public Graph<E, V> getGraph(E edge) {
        return this.edgeMap.get(edge);
    }

    public Graph<E, V> getGraph() {
        Graph<E, V> g = null;
        if (this.edgeMap.size() == 1) {
            Map.Entry<E, Graph<E, V>> entry = this.edgeMap.entrySet().iterator().next();
            g = entry.getValue();
        }
        return g;
    }

    public boolean isAmbiguous() {
        return this.edgeMap.size() > 1;
    }

    public Set<E> getEdges() {
        return this.edgeMap.keySet();
    }

    public boolean isTerminal() {
        return this.edgeMap.isEmpty();
    }

    public String toString() {
        return this.value != null ? this.value.toString() : super.toString();
    }

    public boolean isLinkedTo(Graph<E, V> graph) {
        return this.edgeMap.values().contains(graph);
    }

    public boolean isLinkedTo(Graph<E, V> graph, E edge) {
        return this.edgeMap.get(edge) == graph;
    }
}

