/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.help.Help;
import oracle.help.common.View;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSet;
import oracle.help.library.helpset.HelpSetParseException;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.HelpManagerException;
import oracle.install.commons.util.exception.CommonErrorCode;
import oracle.install.commons.util.exception.ErrorCode;

public class HelpManager
implements ApplicationListener {
    private static Logger logger = Logger.getLogger(HelpManager.class.getName());
    private Map<Component, String> componentTopicMap;
    private Book book;
    private Help help;
    private String helpPath;
    private Map<String, String> helpTopicMap = new TreeMap<String, String>();
    private String defaultHelpTopic;
    private boolean shownOnce;

    protected HelpManager() {
        this.componentTopicMap = new HashMap<Component, String>();
    }

    public Help loadHelp(String helpPath) throws HelpManagerException {
        Help help = null;
        URL helpURL = this.getClass().getResource(helpPath);
        if (helpURL != null) {
            help = this.loadHelp(helpURL);
        } else {
            logger.log(Level.WARNING, "Unknown help resource {0}", helpPath);
        }
        return help;
    }

    public String getLocalizedURL(URL helpSetLocation) {
        String location;
        String file = null;
        Application application = Application.getInstance();
        Locale locale = application.getLocale();
        String path = helpSetLocation.getPath();
        if (path != null && "file".equalsIgnoreCase(helpSetLocation.getProtocol())) {
            int slashIndex = path.lastIndexOf(47);
            if (slashIndex != -1 && slashIndex < path.length()) {
                file = path.substring(slashIndex + 1);
                if ((slashIndex = path.lastIndexOf(47, slashIndex - 2)) != -1 && slashIndex < path.length()) {
                    String directory = path.substring(0, slashIndex);
                    String language = locale.getLanguage();
                    File f = new File(file = String.format("%s/%s/%s", directory, locale, file));
                    if (!f.exists() && !(f = new File(file = String.format("%s/%s/%s", directory, language, file))).exists()) {
                        file = helpSetLocation.getPath();
                    }
                }
            }
        } else if ("jar".equalsIgnoreCase(helpSetLocation.getProtocol()) && (location = helpSetLocation.getFile()) != null && location.lastIndexOf("!") != -1) {
            int index = location.lastIndexOf("!");
            String jarLocation = location.substring(0, index + 1);
            String directory = location.substring(index + 1, location.length());
            String fileName = path.substring(path.lastIndexOf("/") + 1);
            directory = directory.substring(0, directory.lastIndexOf("/") - 1);
            directory = directory.substring(0, directory.lastIndexOf("/"));
            String language = locale.getLanguage();
            String calculatedLoc = String.format("%s/%s/%s", directory, locale, fileName);
            file = jarLocation + calculatedLoc;
            URL localizedURL = this.getClass().getResource(calculatedLoc);
            if (localizedURL == null) {
                calculatedLoc = String.format("%s/%s/%s", directory, language, fileName);
                file = jarLocation + calculatedLoc;
                localizedURL = this.getClass().getResource(calculatedLoc);
                if (localizedURL == null) {
                    file = calculatedLoc = helpSetLocation.getPath();
                }
            }
        }
        return file;
    }

    public Help loadHelp(URL helpSetLocation) throws HelpManagerException {
        if (helpSetLocation != null) {
            View[] views;
            if (this.help != null) {
                this.help.dispose();
            }
            boolean loaded = false;
            Application application = Application.getInstance();
            Locale locale = application.getLocale();
            Help.setHelpLocale((Locale)locale);
            String name = this.getLocalizedURL(helpSetLocation);
            URL localizedURL = null;
            try {
                localizedURL = new URL(helpSetLocation.getProtocol(), helpSetLocation.getHost(), name);
                if (localizedURL == null) {
                    throw new HelpManagerException((ErrorCode)CommonErrorCode.CORRUPT_APPLICATION_HELP, new Object[0]);
                }
                logger.info("Loading localized help from " + localizedURL);
                try {
                    this.book = new HelpSet(localizedURL);
                    loaded = true;
                }
                catch (HelpSetParseException e) {
                    logger.log(Level.WARNING, "Failed to load localized help.", e);
                }
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "Failed while contructing the localized help URL.", e);
            }
            if (!loaded) {
                logger.info("Loading help from " + helpSetLocation);
                try {
                    this.book = new HelpSet(helpSetLocation);
                    logger.info("Loaded help from " + helpSetLocation);
                }
                catch (HelpSetParseException e) {
                    throw new HelpManagerException((Throwable)e, (ErrorCode)CommonErrorCode.CORRUPT_APPLICATION_HELP, new Object[0]);
                }
            }
            if ((views = this.book.getAllViews()) != null) {
                for (View view : views) {
                    String title = view.getTitle();
                    if (title == null) continue;
                    title = application.getString(title, title, new Object[0]);
                    view.setTitle(title);
                }
            }
            this.help = new Help();
            this.help.addBook(this.book);
            application.removeApplicationListener(this);
            application.addApplicationListener(this);
        }
        return this.help;
    }

    public String getDefaultHelpTopic() {
        return this.defaultHelpTopic;
    }

    public void setDefaultHelpTopic(String defaultHelpTopic) {
        this.defaultHelpTopic = defaultHelpTopic;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public void setHelpTopic(String componentName, String topic) {
        this.helpTopicMap.put(componentName, topic);
    }

    public String getHelpTopic(String componentName) {
        String helpTopic = this.helpTopicMap.get(componentName);
        if (helpTopic == null) {
            helpTopic = this.defaultHelpTopic;
        }
        return helpTopic;
    }

    public Help getHelp() {
        return this.help;
    }

    public void registerComponentForHelp(Component component, String helpId) {
        String topic;
        if (component != null && (topic = this.getHelpTopic(helpId)) != null) {
            this.componentTopicMap.put(component, topic);
        }
    }

    public void showHelpForComponent(Component component) throws HelpManagerException {
        if (component != null) {
            String topic = this.componentTopicMap.get(component);
            this.showHelpTopic(component, topic);
        }
    }

    public void showHelpTopic(String topic) throws HelpManagerException {
        this.showHelpTopic(null, topic);
    }

    public void update(ApplicationEvent e) {
        if (e.getType() == ApplicationEvent.Type.LOCALE_CHANGED) {
            Application application = Application.getInstance();
            Help.setHelpLocale((Locale)application.getLocale());
        }
    }

    private void showHelpTopic(Component component, String topic) throws HelpManagerException {
        if (this.help == null) {
            throw new HelpManagerException((ErrorCode)CommonErrorCode.HELP_NOT_AVAILABLE, new Object[0]);
        }
        if (topic == null) {
            throw new HelpManagerException((ErrorCode)CommonErrorCode.HELP_TOPIC_NOT_FOUND, new Object[0]);
        }
        try {
            if (!this.shownOnce) {
                KeyboardFocusManager focusManager;
                Component lastFocusOwner;
                if (component == null && (lastFocusOwner = (focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getPermanentFocusOwner()) != null) {
                    component = SwingUtilities.getRoot(lastFocusOwner);
                }
                if (component != null) {
                    Window parentWindow = SwingUtilities.windowForComponent(component);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension parentWindowSize = parentWindow == null ? component.getSize() : parentWindow.getSize();
                    Dimension helpWindowSize = new Dimension();
                    helpWindowSize.width = Math.round(0.7f * (float)parentWindowSize.width);
                    helpWindowSize.height = Math.round(0.7f * (float)parentWindowSize.height);
                    Point helpWindowLocation = new Point(screenSize.width / 2, screenSize.height / 2);
                    helpWindowLocation.translate(-helpWindowSize.width / 2, -helpWindowSize.height / 2);
                    this.help.showTopic(this.book, topic, false, helpWindowLocation, helpWindowSize);
                } else {
                    this.help.showTopic(this.book, topic);
                }
                this.shownOnce = true;
            } else {
                this.help.showTopic(this.book, topic);
            }
        }
        catch (TopicDisplayException ex) {
            throw new HelpManagerException((Throwable)ex, (ErrorCode)CommonErrorCode.HELP_TOPIC_NOT_FOUND, new Object[0]);
        }
    }
}

