/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogStream
extends OutputStream {
    private static Logger DEFAULT_LOGGER = Logger.getLogger(LogStream.class.getName());
    private Logger logger;
    private Level level;
    private ByteArrayOutputStream buffer;

    public LogStream() {
        this(DEFAULT_LOGGER, Level.INFO);
    }

    public LogStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.buffer = new ByteArrayOutputStream();
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        this.log();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
        if (b == 10) {
            this.log();
        }
    }

    private void log() {
        String[] lines;
        String text = new String(this.buffer.toByteArray());
        for (String line : lines = text.split("\n")) {
            this.logger.log(this.level, line);
        }
        this.buffer.reset();
    }
}

