/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.util.IconLibrary;
import oracle.install.commons.util.ResourceKey;
import oracle.install.commons.util.StatusCode;
import oracle.install.commons.util.exception.CommonErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    private String resourceBundleName;
    private ResourceBundle resourceBundle;
    private Map<String, Object> runtimeProperties;

    protected Resource() {
        this(null, null);
    }

    protected Resource(String resourceBundleName, ResourceBundle resourceBundle) {
        this.resourceBundleName = resourceBundleName;
        this.resourceBundle = resourceBundle;
        this.runtimeProperties = new HashMap<String, Object>();
    }

    protected String getResourceBundleName() {
        return this.resourceBundleName;
    }

    protected void reload(Locale locale) {
        if (this.resourceBundleName == null) {
            logger.severe("Cannot reload the bundle. The resourceBundleName is null.");
        } else {
            this.resourceBundle = ResourceBundle.getBundle(this.resourceBundleName, locale);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getProperty(String key, Object ... args) {
        Object property = null;
        Object value = null;
        if (this.runtimeProperties.containsKey(key)) {
            value = this.runtimeProperties.get(key);
        } else {
            if (this.resourceBundle == null) {
                ErrorInfo errorInfo = ErrorInfo.getInstance(CommonErrorCode.RESOURCE_BUNDLE_NOT_FOUND, this.resourceBundleName);
                throw new MissingResourceException(errorInfo.getMessage(), this.resourceBundleName, key);
            }
            value = this.resourceBundle.getObject(key);
        }
        property = value instanceof String ? (String)value : (value == null ? null : value.toString());
        if (property != null && args != null && args.length > 0) {
            property = MessageFormat.format((String)property, args);
        }
        return property;
    }

    public String getString(String key, String defaultValue, Object ... args) {
        String value = defaultValue;
        try {
            value = this.getProperty(key, args);
        }
        catch (MissingResourceException e) {
            if (defaultValue != null) {
                value = MessageFormat.format(defaultValue, args);
            }
            logger.fine(e.getMessage());
        }
        return value;
    }

    public ImageIcon getIcon(String key, Object ... args) {
        return this.getIcon(key, null, args);
    }

    public ImageIcon getIcon(String key, ImageIcon defaultIcon, Object ... args) {
        ImageIcon icon = defaultIcon;
        try {
            String value = this.getProperty(key, args);
            if (value != null) {
                IconLibrary iconLibrary = IconLibrary.getInstance();
                icon = iconLibrary.getIcon(value);
            }
        }
        catch (MissingResourceException e) {
            logger.fine(e.getMessage());
        }
        return icon;
    }

    public ImageIcon getIcon(Enum<?> e, Object ... args) {
        return this.getIcon(e, null, args);
    }

    public ImageIcon getIcon(Enum<?> e, ImageIcon defaultIcon, Object ... args) {
        return this.getIcon(ResourceKey.value(e), defaultIcon, args);
    }

    public boolean getBoolean(Enum<?> key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(Enum<?> key, boolean defaultValue) {
        return this.getBoolean(ResourceKey.value(key), defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            String v = this.getProperty(key, new Object[0]);
            value = v == null ? defaultValue : Boolean.valueOf(v);
        }
        catch (MissingResourceException e) {
            logger.fine(e.getMessage());
        }
        return value;
    }

    public <A> A getValue(Class<A> type, Enum<?> key) {
        return this.getValue(type, key, null);
    }

    public <A> A getValue(Class<A> type, Enum<?> key, A defaultValue) {
        return this.getValue(type, ResourceKey.value(key), defaultValue);
    }

    public <A> A getValue(Class<A> type, String key) {
        return this.getValue(type, key, null);
    }

    public <A> A getValue(Class<A> type, String key, A defaultValue) {
        A value = defaultValue;
        try {
            A translatedValue;
            String v = this.getProperty(key, new Object[0]);
            value = v != null ? ((translatedValue = TypeTranslator.translate(v, type)) == null ? defaultValue : translatedValue) : defaultValue;
        }
        catch (MissingResourceException e) {
            logger.fine(e.getMessage());
        }
        return value;
    }

    public String getStatusString(StatusCode statusCode, Object ... args) {
        String message = null;
        if (statusCode != null) {
            message = this.getString(ResourceKey.status(statusCode), statusCode.name(), args);
        }
        return message;
    }

    public String getString(Enum<?> e, Object ... args) {
        return this.getEnumString(e, e.name(), args);
    }

    public String getEnumString(Enum<?> e, String defaultValue, Object ... args) {
        String message = null;
        if (e != null) {
            message = this.getString(ResourceKey.value(e), defaultValue, args);
        }
        return message;
    }

    public void setProperty(String key, Object value) {
        this.runtimeProperties.put(key, value);
    }

    public void removeProperty(String key) {
        this.runtimeProperties.remove(key);
    }

    public void clear() {
        this.runtimeProperties.clear();
    }
}

