/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Serializable,
Comparable<Version> {
    static final long serialVersionUID = 65536L;
    public static final MessageFormat DEFAULT_PATTERN = new MessageFormat("{0}.{1}.{2}.{3}.{4}");
    public static final Version UNKNOWN = new Version(0, 0, 0, 0, 0);
    private int major;
    private int minor;
    private int release;
    private int patch;
    private int operatingSystem;
    private Integer[] version;
    private String formattedString;

    public Version() {
        this(1, 0, 0, 0, 0);
    }

    public Version(int major, int minor, int release, int patch, int operatingSystem) {
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.patch = patch;
        this.operatingSystem = operatingSystem;
        this.version = new Integer[]{this.major, this.minor, this.release, this.patch, this.operatingSystem};
        this.formattedString = DEFAULT_PATTERN.format(this.version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getOperatingSystem() {
        return this.operatingSystem;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getRelease() {
        return this.release;
    }

    @Override
    public int compareTo(Version v) {
        int result = 1;
        if (this.version != null) {
            result = this.compare(v, 0);
        }
        return result;
    }

    public String toString() {
        return this.formattedString;
    }

    public boolean equals(Object v) {
        boolean flag = false;
        if (v instanceof Version) {
            Version version = (Version)v;
            flag = this.compareTo(version) == 0;
        }
        return flag;
    }

    private int compare(Version v, int digit) {
        if (this.version[digit] > v.version[digit]) {
            return 1;
        }
        if (this.version[digit] == v.version[digit]) {
            if (++digit == this.version.length) {
                return 0;
            }
            return this.compare(v, digit);
        }
        return -1;
    }

    public static String format(Version version, String pattern) {
        return MessageFormat.format(pattern, version.version);
    }

    public static Version parseVersion(String text) throws IllegalArgumentException {
        Version version = null;
        try {
            Object[] tokens = DEFAULT_PATTERN.parse(text);
            if (tokens == null || tokens.length != 5) {
                throw new IllegalArgumentException(text);
            }
            Integer[] v = new Integer[5];
            for (int i = 0; i < 5; ++i) {
                try {
                    v[i] = Integer.parseInt(tokens[i].toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(text);
                }
            }
            version = new Version(v[0], v[1], v[2], v[3], v[4]);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(text);
        }
        return version;
    }
}

