/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.HelpManager;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.BaseException;
import oracle.install.commons.util.exception.CommonErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.resource.ErrorCodeResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorMessageHelper {
    private static final Logger logger = Logger.getLogger(ErrorMessageHelper.class.getName());
    private static Resource resource;
    private static HyperlinkListener hyperLinkListener;
    private static final String HELP_LINK_PROTOCOL = "help://";
    private static final String FMT_HELP_LINK = "<a href=\"{0}{1}.{2}\">{2}</a>";

    public static HyperlinkListener newErrorCodeHyperLinkListener() {
        return new ErrorCodeHyperLinkListener();
    }

    public static HyperlinkListener getSharedErrorCodeHyperLinkListener() {
        if (hyperLinkListener == null) {
            hyperLinkListener = new ErrorCodeHyperLinkListener();
        }
        return hyperLinkListener;
    }

    public static String formatMessage(Throwable throwable, String message) {
        if (throwable != null) {
            Application application;
            boolean bookmark;
            if (message == null) {
                if (resource == null) {
                    resource = Application.getInstance().getResource(ErrorCodeResourceBundle.class.getName());
                }
                message = resource.getString(CommonErrorCode.UNKNOWN_ERROR, new Object[0]);
            }
            if (bookmark = (application = Application.getInstance()).getBoolean("ErrorMessage.format.bookmarkErrorCodes", false)) {
                HashMap<String, String> hyperLinkMap = new HashMap<String, String>();
                ErrorMessageHelper.buildErrorIdHyperlinkMap(throwable, hyperLinkMap);
                for (Map.Entry<String, String> e : hyperLinkMap.entrySet()) {
                    message = message.replaceAll(e.getKey(), e.getValue());
                }
            }
        }
        return message;
    }

    public static String formatMessage(BaseException exception, String message) {
        if (exception instanceof Throwable) {
            message = ErrorMessageHelper.formatMessage((Throwable)((Object)exception), message);
        }
        return message;
    }

    private static void buildErrorIdHyperlinkMap(Throwable t, Map<String, String> hyperLinkMap) {
        if (t != null) {
            BaseException e;
            if (t instanceof BaseException && (e = (BaseException)((Object)t)).getHelpId() != null && e.getErrorId() != null) {
                String link = MessageFormat.format(FMT_HELP_LINK, HELP_LINK_PROTOCOL, e.getHelpId(), e.getErrorId());
                hyperLinkMap.put(e.getErrorId(), link);
            }
            Throwable cause = t.getCause();
            ErrorMessageHelper.buildErrorIdHyperlinkMap(cause, hyperLinkMap);
        }
    }

    public static String formatMessage(ErrorMessage errorMessage, String message) {
        ErrorInfo errorInfo;
        if (errorMessage != null && (errorInfo = errorMessage.getErrorInfo()) != null) {
            String fqcn = errorInfo.getErrorFQN();
            String helpId = errorInfo.getHelpId();
            if (fqcn != null && helpId != null) {
                String link = MessageFormat.format(FMT_HELP_LINK, HELP_LINK_PROTOCOL, helpId, fqcn);
                message = message.replaceFirst(fqcn, link);
            }
        }
        return message;
    }

    static class ErrorCodeHyperLinkListener
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent e) {
            String href;
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (href = e.getDescription()) != null && href.startsWith(ErrorMessageHelper.HELP_LINK_PROTOCOL)) {
                String topic = href.substring(ErrorMessageHelper.HELP_LINK_PROTOCOL.length());
                Application application = Application.getInstance();
                try {
                    HelpManager helpManager = application.getHelpManager();
                    helpManager.showHelpTopic(topic);
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Failed to show help topic. Reason: ", t.getMessage());
                    ExceptionManager.report(t);
                }
            }
        }
    }
}

