/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionReporter;
import oracle.install.commons.util.exception.Severity;

public class TextualExceptionReporter
implements ExceptionReporter {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Option reportException(Object observer, Throwable throwable, Severity severity, ErrorCode errorCode, String hint, String message, Object ... args) {
        hint = hint == null ? "null" : hint;
        message = message == null ? "null" : message;
        System.out.printf("%s: %s\n", hint, message);
        this.logger.log(Level.INFO, hint + ": " + message);
        if (severity == Severity.WARNING) {
            boolean stop = true;
            do {
                String input;
                if ("n".equalsIgnoreCase(input = Console.getInput("The application may be unstable.\nDo you want to continue ? ([Y]es or [N]o).(To view stacktrace enter [S])"))) {
                    Application.getInstance().shutdown(Application.CommonExitStatus.FAILURE);
                    continue;
                }
                if (!"s".equalsIgnoreCase(input)) continue;
                throwable.printStackTrace(System.out);
                Throwable cause = throwable.getCause();
                Console.println("Caused by the following Exception");
                cause.printStackTrace(System.out);
                stop = false;
            } while (!stop);
        } else if (severity == Severity.FATAL) {
            this.logger.log(Level.SEVERE, "Irrecoverable application error.");
            Application.getInstance().shutdown(Application.CommonExitStatus.FAILURE);
        }
        return null;
    }
}

