/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.install.commons.base.logging.LevelEx;
import oracle.install.commons.util.logging.LogRenderer;

public class RendererHandler
extends Handler
implements Filter {
    private static Logger logger = Logger.getLogger(RendererHandler.class.getName());
    private List<LogRenderer> rendererList = new ArrayList<LogRenderer>();
    private static RendererHandler registeredInstance;

    public RendererHandler() {
        registeredInstance = this;
    }

    public void addLogRenderer(LogRenderer logRenderer) {
        this.rendererList.add(logRenderer);
    }

    public void removeLogRenderer(LogRenderer logRenderer) {
        this.rendererList.remove(logRenderer);
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    public boolean isLoggable(LogRecord logRecord) {
        return logRecord.getLevel() == LevelEx.STATUS;
    }

    public void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            for (LogRenderer renderer : this.rendererList) {
                renderer.render(logRecord);
            }
        }
    }

    public static RendererHandler getInstance() {
        return registeredInstance;
    }

    static {
        logger.info("LogPublisher Successfully Loaded.");
    }
}

