/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressMonitor;
import oracle.install.commons.util.progress.ProgressUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProgressMonitor
implements ProgressMonitor {
    private static final Logger logger = Logger.getLogger(DefaultProgressMonitor.class.getName());
    private List<Job> jobList;
    private int activeJobIndex;
    private Job activeJob;
    private CompositeJob compositeJob;
    private ProgressUI progressUI;

    public DefaultProgressMonitor() {
        this(null, null);
    }

    public DefaultProgressMonitor(CompositeJob compositeJob, ProgressUI progressUI) {
        this.compositeJob = compositeJob;
        this.progressUI = progressUI;
        this.jobList = compositeJob != null ? compositeJob.getJobs() : new ArrayList<Job>();
        this.activeJobIndex = 0;
    }

    @Override
    public CompositeJob getCompositeJob() {
        return this.compositeJob;
    }

    @Override
    public void setCompositeJob(CompositeJob compositeJob) {
        this.compositeJob = compositeJob;
        this.jobList = this.compositeJob.getJobs();
    }

    @Override
    public ProgressUI getProgressUI() {
        return this.progressUI;
    }

    @Override
    public void setProgressUI(ProgressUI progressUI) {
        this.progressUI = progressUI;
    }

    @Override
    public Job nextJob() {
        Job task = null;
        if (this.activeJobIndex < this.jobList.size()) {
            this.activeJob = task = this.jobList.get(this.activeJobIndex);
            ++this.activeJobIndex;
        }
        return task;
    }

    @Override
    public Job getActiveJob() {
        return this.activeJob;
    }

    @Override
    public boolean hasMoreJobs() {
        return this.activeJobIndex < this.jobList.size();
    }

    @Override
    public void reset() {
        this.activeJobIndex = 0;
    }

    @Override
    public Job getJob(Object jobId) {
        Job expectedJob = null;
        if (jobId != null) {
            for (Job job : this.jobList) {
                Object id = job.getId();
                if (id == null || !jobId.equals(id)) continue;
                expectedJob = job;
                break;
            }
        }
        return expectedJob;
    }

    public List<Job> getJobList() {
        return Collections.unmodifiableList(this.jobList);
    }

    public void setProgress(float progress) {
        if (this.compositeJob == null && this.activeJob != null) {
            this.compositeJob = this.activeJob.getParent();
        }
        if (this.compositeJob != null) {
            this.compositeJob.setProgress(progress);
        }
    }

    public void log(Level level, String message, Object ... args) {
        if (this.progressUI != null) {
            this.progressUI.log(level, message, args);
        }
        logger.log(level, message, args);
    }
}

