/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.ProgressUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTextualProgressUI
implements ProgressUI<Void> {
    private ProgressModel progressModel = new ProgressModel();
    private static final Logger logger = Logger.getLogger(DefaultTextualProgressUI.class.getName());

    @Override
    public void setCompositeJobs(CompositeJob ... jobs) {
        if (this.progressModel != null) {
            this.progressModel.setCompositeJobs(jobs);
        }
    }

    @Override
    public Void getOwner() {
        return null;
    }

    @Override
    public ProgressModel getProgressModel() {
        return this.progressModel;
    }

    @Override
    public void setLogLocation(String logLocation) {
        logger.log(Level.INFO, "New Log Location " + logLocation);
    }

    @Override
    public void log(Level level, String message, Object ... args) {
        logger.log(level, message, args);
    }

    @Override
    public void reset() {
    }

    @Override
    public void setProgressModel(ProgressModel taskModel) {
        this.progressModel = taskModel;
        this.progressModel.addChangeListener(new ChangeListener(){
            int currentCount = 0;

            public void stateChanged(ChangeEvent e) {
                System.out.println(DefaultTextualProgressUI.this.progressModel.getValue());
                int count = DefaultTextualProgressUI.this.progressModel.getValue();
                if (this.currentCount < count) {
                    System.out.print(".");
                    this.currentCount = count;
                }
            }
        });
    }
}

