/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

class DetailsDialog
extends JDialog {
    private static DetailsDialog instance = null;
    public static final Dimension DEFAULT_SIZE = new Dimension(320, 240);
    private static JTextArea txaLog = new JTextArea();
    private static JTextArea txtLogLocation = new JTextArea();
    private Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());

    public static DetailsDialog getInstance(Component component) {
        if (instance == null) {
            Window window = SwingUtilities.windowForComponent(component);
            instance = window instanceof Frame ? new DetailsDialog((Frame)window) : (window instanceof Dialog ? new DetailsDialog((Dialog)window) : new DetailsDialog((Frame)null));
            instance.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    instance = null;
                }
            });
        }
        return instance;
    }

    public DetailsDialog(Frame parent) {
        super(parent);
        this.init(parent);
    }

    public DetailsDialog(Dialog parent) {
        super(parent);
        this.init(parent);
    }

    private void init(Window parent) {
        this.setLocationRelativeTo(parent);
        this.setSize(DEFAULT_SIZE);
        this.setAlwaysOnTop(true);
        txtLogLocation.setOpaque(false);
        txtLogLocation.setEditable(false);
        JPanel pnlMain = new JPanel();
        JButton btnClose = new JButton();
        pnlMain = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent(new JScrollPane(txaLog), pnlMain, 0, 0, 1, 1, 1, 10, 1.0, 1.0, new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent(txtLogLocation, pnlMain, 0, 1, 1, 1, 2, 10, 1.0, 0.0, new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent(btnClose, pnlMain, 0, 2, 1, 1, 0, 13, 1.0, 0.0, new Insets(0, 0, 0, 0));
        super.getContentPane().add(pnlMain);
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                instance.setVisible(false);
            }
        });
        btnClose.setName("ProgressPane.DetailsDialog.btnClose");
        SwingUtils.setText(btnClose, this.resource.getString("ProgressPane.DetailsDialog.btnClose.text", "Close", new Object[0]));
        super.setTitle(this.resource.getString("ProgressPane.DetailsDialog.title", "Details", new Object[0]));
    }

    public void log(Level level, String message) {
        if (message != null) {
            txaLog.append(message);
            txaLog.append("\n");
            Document document = txaLog.getDocument();
            txaLog.setCaretPosition(document.getLength());
        }
    }

    public void setLogLocation(String logLocation) {
        if (logLocation != null) {
            String text = this.resource.getString("ProgressPane.lblLogLocation.text", "Log File: {0}", logLocation);
            txtLogLocation.setText(text);
        }
    }
}

