/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Callable;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.JobIndex;
import oracle.install.commons.util.progress.Pausable;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Job {
    public static final String PROPERTY_PARENT = "Job.parent";
    public static final String PROPERTY_WEIGHTAGE = "Job.weightage";
    public static final String PROPERTY_ACTUAL_WEIGHTAGE = "Job.actualWeigtage";
    public static final String PROPERTY_DESCRIPTION = "Job.description";
    public static final String PROPERTY_ID = "Job.id";
    public static final String PROPERTY_STATUS = "Job.status";
    public static final String PROPERTY_PROGRESS = "Job.progress";
    public static final String PROPERTY_REQUIRED = "Job.required";
    public static final String PROPERTY_FAILURE_SEVERITY = "Job.failureSeverity";
    private CompositeJob parentJob;
    private Object id;
    private String description;
    private Status status;
    private float progress;
    private float weightage;
    private boolean required;
    private Callable<?> work;
    private float actualWeightage;
    private Pausable pausable;
    private boolean retryEnabled;
    private Retriable<?> retriable;
    private JobIndex jobIndex;
    private boolean hidden;
    private StatusMessages<StatusMessage> statusMessages;
    private Severity failureSeverity;
    protected PropertyChangeSupport propertyChangeSupport;

    public Job() {
        this(null, null, 1.0f);
    }

    public Job(Object id, String description) {
        this(id, description, 1.0f);
    }

    public Job(Object id, float weightage) {
        this(id, null, weightage);
    }

    public Job(Object id, String description, float weightage) {
        this.id = id;
        this.description = description;
        this.weightage = this.safeValue(weightage);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.parentJob = null;
        this.actualWeightage = weightage;
        this.status = Status.PENDING;
        this.progress = 0.0f;
        this.required = true;
        this.failureSeverity = null;
        this.setStatusMessages(null);
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        if (this.id != id) {
            Object oldValue = this.id;
            this.id = id;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_ID, oldValue, id);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (this.description != description) {
            String oldValue = this.description;
            this.description = description;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
        }
    }

    public float getWeightage() {
        return this.weightage;
    }

    public void setWeightage(float weightage) {
        if (this.weightage != weightage) {
            float oldValue = this.weightage;
            this.weightage = this.safeValue(weightage);
            this.actualWeightage = weightage;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_WEIGHTAGE, Float.valueOf(oldValue), Float.valueOf(weightage));
        }
    }

    public float getActualWeightage() {
        return this.actualWeightage;
    }

    public void setActualWeightage(float actualWeigtage) {
        if (this.actualWeightage != actualWeigtage) {
            float oldValue = this.actualWeightage;
            this.actualWeightage = this.safeValue(actualWeigtage);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_ACTUAL_WEIGHTAGE, Float.valueOf(oldValue), Float.valueOf(actualWeigtage));
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        if (this.required != required) {
            boolean oldValue = this.required;
            this.required = required;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_REQUIRED, oldValue, required);
        }
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    public boolean isHidden() {
        return this.hidden || this.description == null;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public CompositeJob getParent() {
        return this.parentJob;
    }

    public void setParent(CompositeJob parent) {
        CompositeJob currentTaskGroup = this.parentJob;
        if (currentTaskGroup != parent) {
            this.parentJob = parent;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PARENT, currentTaskGroup, parent);
        }
    }

    public JobIndex getJobIndex() {
        return this.jobIndex;
    }

    public void setJobIndex(JobIndex jobIndex) {
        this.jobIndex = jobIndex;
    }

    public Pausable getPausable() {
        return this.pausable;
    }

    public void setPausable(Pausable pausable) {
        this.pausable = pausable;
    }

    public Callable<?> getWork() {
        return this.work;
    }

    public void setWork(Callable<?> work) {
        this.work = work;
    }

    public Retriable<?> getRetriable() {
        return this.retriable;
    }

    public void setRetriable(Retriable<?> retriable) {
        this.retriable = retriable;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (this.status != status) {
            Status oldValue = this.status;
            this.status = status;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_STATUS, (Object)oldValue, (Object)status);
            switch (status) {
                case FAILED: 
                case CANCELLED: 
                case SUCCEEDED: {
                    this.setProgress(1.0f);
                }
            }
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        if (this.progress != progress) {
            float oldValue = this.progress;
            this.progress = this.safeValue(progress);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROGRESS, Float.valueOf(oldValue), Float.valueOf(progress));
        }
    }

    public StatusMessages<StatusMessage> getStatusMessages() {
        return this.statusMessages;
    }

    public void setStatusMessages(StatusMessages<StatusMessage> statusMessages) {
        if (statusMessages == null) {
            statusMessages = new StatusMessages();
        }
        if (this.statusMessages != null) {
            this.statusMessages.clear();
            this.statusMessages = null;
        }
        this.statusMessages = statusMessages;
    }

    public void addStatusMessage(StatusMessage statusMessage) {
        if (statusMessage != null) {
            this.statusMessages.add(statusMessage);
        }
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.statusMessages.clear();
        if (statusMessage != null) {
            this.statusMessages.add(statusMessage);
        }
    }

    public StatusMessages<ErrorMessage> getErrorMessages() {
        StatusMessages<ErrorMessage> errorMessages = null;
        if (!this.statusMessages.isEmpty()) {
            errorMessages = new StatusMessages<ErrorMessage>();
            for (StatusMessage m : this.statusMessages) {
                if (!(m instanceof ErrorMessage)) continue;
                errorMessages.add((ErrorMessage)m);
            }
            if (errorMessages.isEmpty()) {
                errorMessages = null;
            }
        }
        return errorMessages;
    }

    public boolean isCompleted() {
        boolean completed = false;
        switch (this.status) {
            case FAILED: 
            case CANCELLED: 
            case SUCCEEDED: 
            case SUCCEEDED_PARTIALLY: 
            case IGNORED: {
                completed = true;
            }
        }
        return completed;
    }

    public Severity getFailureSeverity() {
        return this.failureSeverity;
    }

    public void setFailureSeverity(Severity failureSeverity) {
        if (this.failureSeverity != failureSeverity) {
            Severity oldValue = this.failureSeverity;
            this.failureSeverity = failureSeverity;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_FAILURE_SEVERITY, (Object)oldValue, (Object)failureSeverity);
        }
    }

    public void reset() {
        this.statusMessages.clear();
        this.progress = 0.0f;
        this.setStatus(Status.PENDING);
    }

    public void release() {
        this.id = null;
        this.jobIndex = null;
        this.parentJob = null;
        this.work = null;
        this.retriable = null;
        this.pausable = null;
        this.statusMessages.clear();
        this.statusMessages = null;
    }

    public String toString() {
        return this.description;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private float safeValue(float percentage) {
        float value = Math.min(percentage, 1.0f);
        value = Math.max(value, 0.0f);
        return value;
    }
}

