/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.install.commons.swing.AbstractIcon;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobIndex;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

class JobCellRenderer
extends DefaultTableCellRenderer {
    private Resource resource;
    static Map<Integer, SpacerIcon> spacerMap = new HashMap<Integer, SpacerIcon>();

    public JobCellRenderer() {
        Application application = Application.getInstance();
        this.resource = application.getResource(StringResourceBundle.class.getName());
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Job job = (Job)value;
        if (job != null) {
            JobIndex jobIndex;
            int depth;
            SpacerIcon spacer;
            String description = job.getDescription();
            if (description == null) {
                description = this.resource.getString("JobCellRenderer.unknownJob.description", "Unknown", new Object[0]);
            }
            if (!job.isRequired()) {
                description = this.resource.getString("JobCellRenderer.optionalJob.description", "{0} (Optional)", description);
            }
            if ((spacer = JobCellRenderer.getSpacer(depth = (jobIndex = job.getJobIndex()).getDepth(), table)) != null) {
                spacer.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            }
            this.setIcon(spacer);
            this.setText(description);
        }
        return component;
    }

    static SpacerIcon getSpacer(int depth, JTable table) {
        if (depth == 0) {
            return null;
        }
        SpacerIcon spacerIcon = spacerMap.get(depth);
        if (spacerIcon == null) {
            spacerIcon = new SpacerIcon(depth, table.getRowHeight());
            spacerMap.put(depth, spacerIcon);
        }
        return spacerIcon;
    }

    static class SpacerIcon
    extends AbstractIcon {
        private Color foreground;
        private int bulletX = this.getIconWidth() - 5;
        private int bulletY;

        public SpacerIcon(int depth, int height) {
            super(depth * 16, height, true);
            this.bulletY = Math.round((float)height / 2.0f);
        }

        public Color getForeground() {
            return this.foreground;
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }

        public void paintIcon(Component c, Graphics2D g2, int x, int y, int width, int height) {
            g2.setColor(this.foreground);
            g2.fillOval(this.bulletX, this.bulletY, 4, 4);
        }
    }
}

