/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobHelper {
    public static void executeJobs(Job ... jobs) throws Exception {
        if (jobs != null) {
            for (Job job : jobs) {
                JobHelper._execute(job);
            }
        }
    }

    private static void _execute(Job job) throws Exception {
        if (job instanceof CompositeJob) {
            CompositeJob compositeJob = (CompositeJob)job;
            List<Job> jobs = compositeJob.getJobs();
            for (Job j : jobs) {
                JobHelper._execute(j);
            }
        } else {
            job.getWork().call();
        }
    }

    public static void reexecuteJobs(List<Job> jobs) throws Exception {
        JobHelper.reexecuteJobs(jobs.toArray(new Job[0]));
    }

    public static void reexecuteJobs(Job ... jobs) throws Exception {
        for (Job job : jobs) {
            if (!JobHelper.reexecute(job)) break;
        }
    }

    private static boolean reexecute(Job job) throws Exception {
        Retriable<?> retriable = job.getRetriable();
        Callable<?> work = job.getWork();
        Status status = job.getStatus();
        if (status == Status.PENDING && work != null) {
            work.call();
        } else if (retriable != null && status != Status.IGNORED && status != Status.SUCCEEDED && status != Status.SUCCEEDED_PARTIALLY) {
            retriable.retry();
        } else if (job instanceof CompositeJob) {
            CompositeJob compositeJob = (CompositeJob)job;
            List<Job> jobs = compositeJob.getJobs();
            JobHelper.reexecuteJobs(jobs);
        }
        Status s = job.getStatus();
        boolean success = s == Status.SUCCEEDED || s == Status.SUCCEEDED_PARTIALLY || s == Status.IGNORED || !job.isRequired();
        return success;
    }

    public static String getJobTreeAsString(CompositeJob compositeJob) {
        StringBuffer buffer = new StringBuffer();
        JobHelper.printJobTree(compositeJob, buffer, 0);
        return buffer.toString();
    }

    private static void printJobTree(Job job, StringBuffer buffer, int level) {
        CompositeJob compositeJob;
        List<Job> jobList;
        String indent = "";
        if (level > 0) {
            char[] ch = new char[level];
            Arrays.fill(ch, ' ');
            indent = new String(ch);
        }
        buffer.append(indent);
        buffer.append("- ");
        buffer.append(job.getDescription());
        buffer.append("[");
        buffer.append((Object)job.getStatus());
        buffer.append("]");
        buffer.append('\n');
        if (job instanceof CompositeJob && (jobList = (compositeJob = (CompositeJob)job).getJobs()) != null) {
            ++level;
            for (Job j : jobList) {
                JobHelper.printJobTree(j, buffer, level);
            }
        }
    }

    public static Job getPreviousLeafJob(CompositeJob[] compositeJobs, Job job) {
        Job previousLeafJob = null;
        CompositeJob parent = job.getParent();
        if (parent != null) {
            Job immediateElder = null;
            List<Job> siblings = parent.getJobs();
            int index = siblings.indexOf(job);
            if (index > 0) {
                immediateElder = siblings.get(index - 1);
            } else {
                CompositeJob grandParent = parent.getParent();
                if (grandParent != null) {
                    List<Job> parentSiblings = grandParent.getJobs();
                    index = parentSiblings.indexOf(parent);
                    if (index > 0) {
                        immediateElder = parentSiblings.get(--index);
                    }
                } else {
                    for (CompositeJob parentSibling : compositeJobs) {
                        if (parentSibling == parent) break;
                        immediateElder = parentSibling;
                    }
                }
            }
            if (immediateElder != null) {
                if (immediateElder instanceof CompositeJob) {
                    CompositeJob elder = (CompositeJob)immediateElder;
                    while (elder instanceof CompositeJob) {
                        List<Job> children = elder.getJobs();
                        if (children.isEmpty()) continue;
                        Job child = children.get(children.size() - 1);
                        if (child instanceof CompositeJob) {
                            elder = (CompositeJob)child;
                            continue;
                        }
                        previousLeafJob = child;
                        break;
                    }
                } else {
                    previousLeafJob = immediateElder;
                }
            }
        }
        return previousLeafJob;
    }

    public static int getJobCountByStatus(CompositeJob compositeJob, Status status) {
        List<Job> jobs;
        int count = 0;
        if (compositeJob != null && status != null && (jobs = compositeJob.getJobs()) != null) {
            for (Job job : jobs) {
                if (job.getStatus() != status) continue;
                ++count;
            }
        }
        return count;
    }
}

