/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import javax.accessibility.AccessibleContext;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class JobProgressBar
extends JProgressBar {
    private static final long serialVersionUID = 1L;
    private ProgressModel progressModel;

    public JobProgressBar() {
        this.setMinimum(0);
        this.setMaximum(100);
        this.setStringPainted(true);
    }

    public ProgressModel getProgressModel() {
        return this.progressModel;
    }

    public void setProgressModel(ProgressModel progressModel) {
        this.progressModel = progressModel;
        super.setModel(progressModel);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJobProgressBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJobProgressBar
    extends JProgressBar.AccessibleJProgressBar {
        private static final long serialVersionUID = 1L;
        private Resource stringTable;

        public AccessibleJobProgressBar() {
            super(JobProgressBar.this);
            Application application = Application.getInstance();
            this.stringTable = application.getResource(StringResourceBundle.class.getName());
            JobProgressBar.this.addChangeListener(new ChangeListener(){
                private long oldValue;

                public void stateChanged(ChangeEvent e) {
                    double percentComplete = JobProgressBar.this.getPercentComplete();
                    long newValue = Math.round(percentComplete * 100.0);
                    if (newValue - this.oldValue >= 10L || newValue == 100L) {
                        this.oldValue = newValue;
                        String accessibleDescription = AccessibleJobProgressBar.this.stringTable.getString("AccessibleJobProgressBar.onChanged.accessibleDescription", "{0} percent completed", newValue);
                        AccessibleJobProgressBar.this.setAccessibleDescription(accessibleDescription);
                        if (this.oldValue >= 100L) {
                            this.oldValue = 0L;
                        }
                    }
                }
            });
        }
    }
}

