/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.treetable.DefaultTreeTableModel;
import oracle.install.commons.swing.treetable.JTreeTableEx;
import oracle.install.commons.swing.treetable.NodeAccessor;
import oracle.install.commons.swing.treetable.TreeTableColumn;
import oracle.install.commons.swing.treetable.TreeTableModel;
import oracle.install.commons.swing.treetable.TreeTableModelAdapter;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobFilter;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.StatusCellRenderer;
import oracle.install.commons.util.progress.resource.ObjectResourceBundle;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class JobTreeTable
extends JTreeTableEx {
    private static final Logger logger = Logger.getLogger(JobTreeTable.class.getName());
    private CompositeJob job;
    private boolean compositeJobStatusVisible;
    private ProgressModel progressModel;
    private JobFilter appliedFilter;
    private StatusCellRenderer statusCellRenderer;

    public JobTreeTable() {
        this(null, new ProgressModel());
    }

    public JobTreeTable(CompositeJob job) {
        this(job, new ProgressModel());
    }

    public JobTreeTable(ProgressModel progressModel) {
        this(null, progressModel);
    }

    public JobTreeTable(CompositeJob job, ProgressModel progressModel) {
        this(job, progressModel, new TreeTableColumn[]{new TreeTableColumn("", Status.class), new TreeTableColumn("", TreeTableModel.class), new TreeTableColumn("", Status.class)}, new JobTreeNodeAccessor());
    }

    public JobTreeTable(CompositeJob job, ProgressModel progressModel, TreeTableColumn[] treeTableColumn, NodeAccessor nodeAccessor) {
        super(new DefaultTreeTableModel(JobTreeTable.buildTree(job, null), treeTableColumn, nodeAccessor));
        this.getTreeTableModel().setOrdered(false);
        this.statusCellRenderer = new StatusCellRenderer();
        this.setDefaultRenderer(Status.class, this.statusCellRenderer);
        JTree tree = this.getTree();
        tree.setRootVisible(true);
        tree.setCellRenderer(new JobTreeCellRenderer());
        this.setSelectionMode(0);
        this.addPropertyChangeListener("job", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CompositeJob job = (CompositeJob)evt.getNewValue();
                if (job != null) {
                    JobTreeTable.this.progressModel.setCompositeJobs(job);
                    JobTreeTable.this.filter(null);
                }
            }
        });
        this.addPropertyChangeListener("progressModel", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ProgressModel progressModel = (ProgressModel)evt.getNewValue();
                if (progressModel != null) {
                    JobTreeTable.this.bridgeProgressModel(progressModel);
                }
            }
        });
        this.setProgressModel(progressModel);
        this.setJob(job);
        SwingUtils.setRowWiseFocusTraveralEnabled(this, true);
        this.getColumnModel().getColumn(0).setMaxWidth(18);
        this.getColumnModel().getColumn(2).setMaxWidth(80);
        this.getTableHeader().setReorderingAllowed(false);
        this.compositeJobStatusVisible = true;
    }

    public boolean isCompositeJobStatusVisible() {
        return this.compositeJobStatusVisible;
    }

    public void setCompositeJobStatusVisible(boolean compositeJobStatusVisible) {
        this.compositeJobStatusVisible = compositeJobStatusVisible;
        this.statusCellRenderer.setDistinguishCompositeJobStatus(compositeJobStatusVisible);
    }

    private void bridgeProgressModel(ProgressModel progressModel) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TreeTableModelAdapter) {
            final TreeTableModelAdapter adapter = (TreeTableModelAdapter)tableModel;
            progressModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    adapter.fireTableDataChanged();
                }
            });
        }
    }

    public void setJob(CompositeJob job) {
        if (this.job != job) {
            CompositeJob oldValue = this.job;
            this.job = job;
            this.firePropertyChange("job", oldValue, job);
        }
    }

    public CompositeJob getJob() {
        return this.job;
    }

    public void setProgressModel(ProgressModel progressModel) {
        if (this.progressModel != progressModel) {
            ProgressModel oldValue = this.progressModel;
            this.progressModel = progressModel;
            this.firePropertyChange("progressModel", oldValue, progressModel);
        }
    }

    public ProgressModel getProgressModel() {
        return this.progressModel;
    }

    public void clear() {
        try {
            DefaultMutableTreeNode rootNode = this.getRoot();
            this.clearTree(rootNode);
            this.refresh();
            this.appliedFilter = null;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while clearing the JobTreeTable.", e);
        }
    }

    public void filter(JobFilter jobFilter) {
        if (this.job != null) {
            try {
                DefaultMutableTreeNode rootNode = this.getRoot();
                this.clearTree(rootNode);
                this.reload();
                this.buildTree(this.job, rootNode, jobFilter);
                this.refresh();
                this.setNodeExpanded(rootNode, true);
                this.expandAll();
                this.appliedFilter = jobFilter;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while filtering the JobTreeTable.", e);
            }
        }
    }

    public JobFilter getAppliedFilter() {
        return this.appliedFilter;
    }

    private void clearTree(DefaultMutableTreeNode jobTree) throws Exception {
        if (jobTree.isLeaf()) {
            this.removeNode(jobTree);
        } else {
            ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
            Enumeration<TreeNode> e = jobTree.children();
            while (e.hasMoreElements()) {
                children.add((DefaultMutableTreeNode)e.nextElement());
            }
            for (DefaultMutableTreeNode node : children) {
                this.clearTree(node);
            }
            this.removeNode(jobTree);
        }
    }

    private DefaultMutableTreeNode buildTree(Job job, DefaultMutableTreeNode rootNode, JobFilter jobFilter) throws Exception {
        DefaultMutableTreeNode treeNode = rootNode == null ? new DefaultMutableTreeNode() : rootNode;
        treeNode.setUserObject(job);
        if (job instanceof CompositeJob) {
            CompositeJob compositeJob = (CompositeJob)job;
            List<Job> jobs = compositeJob.getJobs();
            for (Job j : jobs) {
                DefaultMutableTreeNode subNode;
                if (jobFilter != null && !jobFilter.accept(j) || (subNode = this.buildTree(j, null, jobFilter)) == null) continue;
                this.addNode(treeNode, subNode);
            }
            if (treeNode.isLeaf()) {
                treeNode = null;
            }
        }
        return treeNode;
    }

    private static DefaultMutableTreeNode buildTree(Job job, DefaultMutableTreeNode rootNode) {
        DefaultMutableTreeNode treeNode = rootNode == null ? new DefaultMutableTreeNode() : rootNode;
        treeNode.setUserObject(job);
        if (job instanceof CompositeJob) {
            CompositeJob compositeJob = (CompositeJob)job;
            List<Job> jobs = compositeJob.getJobs();
            for (Job j : jobs) {
                treeNode.add(JobTreeTable.buildTree(j, null));
            }
        }
        return treeNode;
    }

    private static class JobTreeNodeAccessor
    implements NodeAccessor {
        private JobTreeNodeAccessor() {
        }

        public Object getValueAt(Object node, int column) {
            DefaultMutableTreeNode n;
            Job job;
            Object value = null;
            if (node instanceof DefaultMutableTreeNode && (job = (Job)(n = (DefaultMutableTreeNode)node).getUserObject()) != null) {
                switch (column) {
                    case 1: {
                        value = job;
                        break;
                    }
                    default: {
                        if (n.isRoot() && n.getParent() == null) break;
                        value = job.getStatus();
                    }
                }
            }
            return value;
        }
    }

    private static class JobTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Resource iconTable;
        private Resource stringTable;

        public JobTreeCellRenderer() {
            Application application = Application.getInstance();
            this.iconTable = application.getResource(ObjectResourceBundle.class.getName());
            this.stringTable = application.getResource(StringResourceBundle.class.getName());
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean rootLeaf = false;
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof Job) {
                    value = ((Job)userObject).getDescription();
                }
                rootLeaf = node.isRoot() && leaf;
            }
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!rootLeaf) {
                ImageIcon icon = null;
                icon = leaf ? this.iconTable.getIcon("JobTreeTable.jobIcon", new Object[0]) : this.iconTable.getIcon("JobTreeTable.compositeJobIcon", new Object[0]);
                this.setIcon(icon);
            } else {
                this.setIcon(null);
                this.setText(this.stringTable.getString("JobTreeTable.rootLeafCell.text", "No results", new Object[0]));
            }
            return component;
        }
    }
}

