/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreSource;
import oracle.install.driver.oui.ConfigCmdMappings;
import oracle.sysman.oii.oiix.OiixPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelper {
    private static ConfigCmdMappings configCmdsMap;
    private static boolean bInit;
    private static Logger logger;

    public static void init() {
        if (!bInit) {
            URL configXmlUrl = ConfigHelper.class.getResource("/oracle/install/driver/oui/resource/ConfigCommandMappings.xml");
            logger.log(Level.INFO, "Loading data from: {0}", configXmlUrl.toString());
            XmlBeanStoreSource source = new XmlBeanStoreSource("config-data", configXmlUrl, new XmlBeanStoreFormat());
            configCmdsMap = BeanStoreUtils.restoreFromXML(source, ConfigCmdMappings.class);
            bInit = true;
        }
    }

    public static void populateConfigMap(Map<String, Object> configMap) {
        ConfigHelper.init();
        String sPlatName = "";
        if (OiixPlatform.isPlatInGroup((int)-3, (int)PlatformInfo.getInstance().getCurrentPlatform())) {
            sPlatName = "windows";
        } else if (OiixPlatform.isPlatInGroup((int)-1, (int)PlatformInfo.getInstance().getCurrentPlatform())) {
            sPlatName = "unix";
        }
        for (int i = 0; i < ConfigHelper.configCmdsMap.configtoolcmds.size(); ++i) {
            configMap.put(ConfigHelper.configCmdsMap.configtoolcmds.get(i).getId(), ConfigHelper.configCmdsMap.configtoolcmds.get(i).getPlatformCmdMap().get(sPlatName) == null ? "" : ConfigHelper.configCmdsMap.configtoolcmds.get(i).getPlatformCmdMap().get(sPlatName));
            logger.log(Level.INFO, "Adding key {0} to the map, with value \"{1}\"", new String[]{ConfigHelper.configCmdsMap.configtoolcmds.get(i).getId(), configMap.get(ConfigHelper.configCmdsMap.configtoolcmds.get(i).getId()).toString()});
        }
    }

    public static void main(String[] args) {
        HashMap<String, Object> a = new HashMap<String, Object>();
        a.put("ORACLE_HOME", "/scratch");
        ConfigHelper.populateConfigMap(a);
        System.out.println(a);
    }

    static {
        bInit = false;
        logger = Logger.getLogger(ConfigHelper.class.getName());
    }
}

