/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.DefaultProgressMonitor;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressMonitor;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.config.ConfigClient;
import oracle.install.driver.oui.config.ConfigManagerErrorCode;
import oracle.sysman.emCfg.client.CfwProgressMonitor;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.types.MicroStepStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigProgressMonitor
extends CfwProgressMonitor
implements ProgressMonitor {
    private static Logger logger = Logger.getLogger(ConfigProgressMonitor.class.getName());
    private ProgressMonitor progressMonitorDelegate;

    public ConfigProgressMonitor() {
        this(null, null);
    }

    public ConfigProgressMonitor(ConfigJob configJob, ProgressUI<?> progressUI) {
        super(ConfigClient.getConfigClient().getCfwSession());
        this.progressMonitorDelegate = new DefaultProgressMonitor(configJob, progressUI);
    }

    protected IMicroStepState getMicroStepState(IMicroStepStateReference microStepStateReference) {
        IMicroStepState microStepState = null;
        ConfigClient configClient = ConfigClient.getConfigClient();
        CfwSession session = configClient.getCfwSession();
        if (session != null) {
            microStepState = session.getMicroStepState(microStepStateReference);
        }
        return microStepState;
    }

    public void plugInStart(IMicroStepStateReference microStepStateReference) throws CfwException {
        IMicroStepState microState = this.getMicroStepState(microStepStateReference);
        logger.log(Level.INFO, "Started Plugin named: " + microState.getPlugInID());
        Job job = this.progressMonitorDelegate.getJob(microState.getPlugInID());
        if (job != null) {
            logger.log(Level.INFO, "Found associated job");
            job.setStatusMessage(null);
            job.setStatus(Status.INPROGRESS);
            Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
            String message = resource.getString("ConfigProgressMonitor.plugin.execution.inprogress", "Starting ''{0}''", job.getDescription());
            logger.log(Level.INFO, message);
            ProgressUI progressUI = this.progressMonitorDelegate.getProgressUI();
            if (progressUI != null) {
                progressUI.log(Level.INFO, message, new Object[0]);
            }
        } else {
            logger.log(Level.INFO, "Associated job not found.");
        }
    }

    public void plugInEnd(IMicroStepStateReference microStepStateReference) throws CfwException {
        IMicroStepState microState = this.getMicroStepState(microStepStateReference);
        IPlugInInvocationState plugin = microState.getPlugInInvocationState();
        String plugInId = plugin.getPlugInID();
        logger.log(Level.INFO, "Completed Plugin named: {0}", plugInId);
        Job job = this.progressMonitorDelegate.getJob(plugInId);
        if (job != null) {
            MicroStepStatus microStatus;
            ProgressUI progressUI = this.progressMonitorDelegate.getProgressUI();
            Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
            String statusDetails = microState.getStatusDetails();
            if (statusDetails != null) {
                String message = resource.getString("ConfigProgressMonitor.plugin.execution.result", "Execution result details of ''{0}'': {1}", job.getDescription(), statusDetails);
                logger.log(Level.INFO, message);
                if (progressUI != null) {
                    progressUI.log(Level.INFO, message, new Object[0]);
                }
            }
            if ((microStatus = microState.getMicroStepStatus()) != null) {
                Status taskStatus = Status.SUCCEEDED;
                String message = null;
                ConfigManagerErrorCode errorCode = ConfigManagerErrorCode.valueOf(microStatus);
                if (errorCode != null) {
                    DefaultErrorMessage errorMessage = new DefaultErrorMessage((ErrorCode)errorCode, job.getDescription());
                    job.addStatusMessage(errorMessage);
                    ErrorInfo errorInfo = errorMessage.getErrorInfo();
                    message = errorInfo.getDescription();
                    File logFile = LogManager.getInstance().getDefaultLogFile();
                    if (logFile != null) {
                        PlainContent details = new PlainContent(logFile.getAbsolutePath());
                        details.setTitle(resource.getString("ConfigProgressMonitor.logTitle", "Log File Location", new Object[0]));
                        errorInfo.setExtraDetails(details);
                    }
                    taskStatus = errorCode.status();
                }
                job.setProgress(1.0f);
                job.setStatus(taskStatus);
                logger.log(Level.INFO, message);
                if (progressUI != null) {
                    progressUI.log(Level.INFO, message, new Object[0]);
                }
            }
        } else {
            logger.log(Level.WARNING, "No job associated for micro step: {0}", plugInId);
        }
    }

    @Override
    public Job getActiveJob() {
        return this.progressMonitorDelegate.getActiveJob();
    }

    @Override
    public CompositeJob getCompositeJob() {
        return this.progressMonitorDelegate.getCompositeJob();
    }

    @Override
    public void setCompositeJob(CompositeJob phase) {
        this.progressMonitorDelegate.setCompositeJob(phase);
    }

    @Override
    public ProgressUI<?> getProgressUI() {
        return this.progressMonitorDelegate.getProgressUI();
    }

    @Override
    public Job getJob(Object taskId) {
        return this.progressMonitorDelegate.getJob(taskId);
    }

    @Override
    public boolean hasMoreJobs() {
        return this.progressMonitorDelegate.hasMoreJobs();
    }

    @Override
    public Job nextJob() {
        return this.progressMonitorDelegate.nextJob();
    }

    @Override
    public void reset() {
        this.progressMonitorDelegate.reset();
    }

    @Override
    public void setProgressUI(ProgressUI progressUI) {
        this.progressMonitorDelegate.setProgressUI(progressUI);
    }
}

