/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.util.message.Content;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverHelper {
    private static final Logger logger = Logger.getLogger(DriverHelper.class.getName());
    private static Vector<Callable<Void>> shutdownCleanupTasks = new Vector();

    public static ArrayList<String> transformSecure(ArrayList<String> props, String ouiVarMappingFilePath) throws IOException {
        ArrayList<String> transformed = new ArrayList<String>();
        InputStream inpStrVarProp = DriverHelper.class.getResourceAsStream(ouiVarMappingFilePath);
        if (inpStrVarProp != null) {
            ArrayList propsClone = (ArrayList)props.clone();
            Properties propVarObj = new Properties();
            propVarObj.load(inpStrVarProp);
            for (String string : propVarObj.keySet()) {
                String propName = (String)propVarObj.get(string);
                if (!props.contains(propName)) continue;
                transformed.add(string);
                propsClone.remove(propName);
            }
            transformed.addAll(propsClone);
        }
        return transformed;
    }

    public static HashMap<String, Object> transform(HashMap<String, Object> source, String ouiVarMappingFilePath) throws IOException {
        HashMap<String, Object> target = null;
        InputStream inpStrVarProp = DriverHelper.class.getResourceAsStream(ouiVarMappingFilePath);
        if (inpStrVarProp != null) {
            HashMap sourceClone = (HashMap)source.clone();
            target = new HashMap<String, Object>();
            Properties propVarObj = new Properties();
            propVarObj.load(inpStrVarProp);
            Iterator<Object> itOuiVars = propVarObj.keySet().iterator();
            while (itOuiVars.hasNext()) {
                String currentOUIKey = itOuiVars.next().toString();
                String currentBridgeKey = propVarObj.getProperty(currentOUIKey);
                target.put(currentOUIKey, source.get(currentBridgeKey));
                sourceClone.remove(currentBridgeKey);
            }
            target.putAll(sourceClone);
        }
        return target;
    }

    public static void logSessionDetails(Map<String, Object> details, Set<String> securePropertySet) {
        try {
            Content content = BeanStoreUtils.createBeanGridContent(true, details, securePropertySet, new Object[0]);
            content.setTitle("Session Details");
            logger.log(Level.INFO, content.getContent());
        }
        catch (BeanStoreException e) {
            logger.log(Level.INFO, "Error while logging session details", e);
        }
    }

    public static void addCleanupTask(Callable<Void> callable) {
        shutdownCleanupTasks.add(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void doCleanup() {
        try {
            for (Callable<Void> cleanupTask : shutdownCleanupTasks) {
                cleanupTask.call();
            }
        }
        catch (Exception e) {
            logger.info("occured " + e.getClass() + " while executing individual cleanup tasks");
            e.printStackTrace();
        }
        finally {
            OiicExitOps.getExitOps().doExitOperations();
        }
    }

    static synchronized void registerForDelete(String fileOrDir) {
        OiicExitOps.getExitOps().addDelDir(fileOrDir);
    }

    static synchronized void markForDelete(File logFile) throws OiilNativeException, IOException {
        if (PlatformInfo.getInstance().isWindows()) {
            OiipwWin32NativeCalls.registerFileToDelete((String)logFile.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReadmeFileContent(File oracleHome) {
        File readmeLoc = new File(oracleHome.getPath(), "install/readme.txt");
        StringBuffer sEndMsgs = new StringBuffer();
        BufferedReader br = null;
        if (readmeLoc == null || !readmeLoc.exists()) {
            logger.log(Level.WARNING, "readme.txt file doesn't exits");
        } else {
            try {
                br = new BufferedReader(new FileReader(readmeLoc));
                String sMsg = null;
                while ((sMsg = br.readLine()) != null) {
                    sEndMsgs.append(sMsg + "\n");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while reading file " + readmeLoc.getPath(), e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return sEndMsgs.toString();
    }

    public static void setCVUEnabled(boolean enabled) {
        System.setProperty("oracle.install.cvu", Boolean.toString(enabled));
    }

    public static boolean isCVUEnabled() {
        boolean enabled = Boolean.valueOf(System.getProperty("oracle.install.cvu", "true"));
        if (!enabled) {
            logger.log(Level.WARNING, "CVU is not enabled. No CVU based operation will be performed.");
        }
        return enabled;
    }

    public static boolean isCVUOperationEnabled(String controlKey) {
        boolean enabled = false;
        if (controlKey != null && DriverHelper.isCVUEnabled() && !(enabled = Boolean.valueOf(System.getProperty(controlKey, "true")).booleanValue())) {
            logger.log(Level.WARNING, "CVU operation {0} is not enabled.", controlKey);
        }
        return enabled;
    }
}

