/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.util.Application;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;

public class InventoryInfo {
    private static final Logger logger = Logger.getLogger(InventoryInfo.class.getName());
    private static InventoryInfo instance = null;
    private OiiiInstallInventory m_inventory = null;

    private InventoryInfo() {
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        if (invAreaControl != null) {
            this.m_inventory = invAreaControl.getInstallInventory();
        }
    }

    public static InventoryInfo getInstance() {
        if (instance == null) {
            instance = new InventoryInfo();
        }
        return instance;
    }

    public boolean isInventoryExist() {
        return !OiiiInstallAreaControl.isCleanMachine();
    }

    public String getDefaultInventoryLoc() {
        String invLoc = null;
        if (!this.isInventoryExist()) {
            try {
                invLoc = new OiipgPropertyLoader().getLocationFileLoc();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "An exception occured while trying to locate existing inventory on the local machine\n" + e);
                e.printStackTrace();
            }
        } else {
            invLoc = new OiipgBootstrap().getDefaultLocationFileLoc();
            logger.log(Level.FINEST, "default inventory location calculated");
        }
        logger.log(Level.INFO, "inventory location is" + invLoc);
        return invLoc;
    }

    public String getNameForLocation(String oraHome) {
        String name = "";
        if (this.m_inventory == null) {
            return name;
        }
        if (this.m_inventory.getHomeWithLocation(oraHome) != null) {
            name = this.m_inventory.getHomeWithLocation(oraHome).getName();
        }
        return name;
    }

    public String computeOracleHomeName(String oracleHome) {
        if (this.isHomeWithLocationExist(oracleHome)) {
            String val = this.getNameForLocation(oracleHome);
            logger.info("setting ORACLE_HOME_NAME=" + val);
            return val;
        }
        String presetHomeName = this.getPresetHomeName();
        if (presetHomeName != null && !this.isHomeWithNameExist(presetHomeName)) {
            logger.info("setting ORACLE_HOME_NAME=" + presetHomeName + ". Passed from command line");
            return presetHomeName;
        }
        String val = OiiiOracleHomeInfo.getDefHomeName(null, (int)0);
        val = val + this.getNewHomeNameIndex(val);
        logger.info("setting ORACLE_HOME_NAME=" + val + ". A default value was " + "calculated as per oraparam.ini");
        return val;
    }

    private String getPresetHomeName() {
        Properties props;
        Application app = Application.getInstance();
        String key = "ORACLE_HOME_NAME";
        if (app instanceof Installer && (props = ((Installer)app).getFlowDataDefaults()) != null && props.containsKey(key)) {
            return props.getProperty(key);
        }
        return null;
    }

    public int getNewHomeNameIndex(String sNewName) {
        int idx = 1;
        boolean bNameExists = true;
        while (bNameExists) {
            String sName = sNewName + idx;
            bNameExists = this.isHomeWithNameExist(sName);
            if (!bNameExists) continue;
            ++idx;
        }
        return idx;
    }

    public boolean isHomeWithNameExist(String oracleHomename) {
        if (this.m_inventory == null) {
            return false;
        }
        return this.m_inventory.getHomeWithName(oracleHomename) != null;
    }

    public boolean isHomeWithLocationExist(String homeLoc) {
        if (this.m_inventory == null) {
            return false;
        }
        return this.m_inventory.getHomeWithLocation(homeLoc) != null;
    }
}

