/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicCmdLineProperty;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OUICommandHelper {
    private static OUIDelegate delegate = null;

    OUICommandHelper() {
    }

    public static Map<String, String> getSetupArguments(String ... args) {
        HashMap<String, String> setupArgs = new HashMap<String, String>();
        if (args != null) {
            for (String arg : args) {
                int eqIndex;
                if (arg.startsWith("-") || (eqIndex = arg.indexOf(61)) == -1) continue;
                String key = arg.substring(0, eqIndex);
                String value = arg.substring(eqIndex + 1);
                setupArgs.put(key, value);
            }
        }
        return setupArgs;
    }

    public static String[] validateArguments(String ... args) {
        return OUICommandHelper.getDelegate().validate(args);
    }

    public static void showUsage() {
        OUICommandHelper.getDelegate().displayHelp();
    }

    private static OUIDelegate getDelegate() {
        if (delegate == null) {
            delegate = new OUIDelegate();
        }
        return delegate;
    }

    static class OUIDelegate
    extends OiicBaseApp {
        private static final String APP_NAME = "oui";
        private static final String SYSTEM_PROPERTY_PREFIX = "oracle.installer.";
        private static final List<String> AUXILIARY_OPTIONS = Arrays.asList("executePrereqs", "ignorePrereq", "ignoreInternalDriverError");
        private static final List<String> UNDOCUMENTED_OPTIONS = Arrays.asList("sourceLoc", "nowait", "patchsetBugListFile", "globalvarxml");
        private static final List<String> DEPRECATED_OPTIONS = Arrays.asList("addLangs", "addNode", "ignorePatchConflicts", "record", "destinationFile", "removeallfiles", "removeAllPatches", "updateNodeList", "nobackground", "nowarningonremovefiles", "noclusterEnabled", "oneclick", "deinstall");
        private static final int CONTEXT_VALIDATE_ARGUMENTS = 1;
        private static final int CONTEXT_SHOW_USAGE = 2;
        private int context;

        public OUIDelegate() {
            super(APP_NAME);
        }

        protected String getSystemPropertyPrefix() {
            return SYSTEM_PROPERTY_PREFIX;
        }

        protected List setupAppProperties() throws OiicInvalidCmdLineException {
            List source = super.setupAppProperties();
            ArrayList<OiicCmdLineProperty> allowedOptions = new ArrayList<OiicCmdLineProperty>();
            for (OiicCmdLineProperty oiicCmdLineProperty : source) {
                String name = oiicCmdLineProperty.getNameFromType();
                if (DEPRECATED_OPTIONS.contains(name) || this.context != 1 && UNDOCUMENTED_OPTIONS.contains(name)) continue;
                allowedOptions.add(oiicCmdLineProperty);
            }
            if (this.context == 2) {
                for (String string : AUXILIARY_OPTIONS) {
                    OiicCmdLineProperty property = new OiicCmdLineProperty(string, 1);
                    property.setHelpId(String.format("cmdlnOption.%s.usageHelp@oracle.install.driver.oui.resource.StringResourceBundle", string));
                    allowedOptions.add(property);
                }
            }
            return allowedOptions;
        }

        public String displayHelp() {
            this.context = 2;
            this.setDefaults();
            return super.displayHelp();
        }

        public String[] validate(String ... args) {
            try {
                this.context = 1;
                ArrayList<String> newArgs = new ArrayList<String>();
                newArgs.addAll(Arrays.asList(args));
                Iterator i = newArgs.iterator();
                while (i.hasNext()) {
                    String arg = (String)i.next();
                    if (!arg.startsWith("-") || !AUXILIARY_OPTIONS.contains(arg.substring(1))) continue;
                    i.remove();
                }
                args = newArgs.toArray(new String[0]);
                super.processCommandLine(args);
            }
            catch (OiicInvalidCmdLineException e) {
                throw new IllegalArgumentException(e.getErrorMessage());
            }
            return args;
        }
    }
}

