/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.VerificationException;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverEvent;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.net.NetworkUtility;
import oracle.install.commons.net.NetworkUtilityException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.ConfigAssistantJob;
import oracle.install.driver.oui.ConfigHelper;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.driver.oui.ConfigProgressMonitor;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.InstallProgressMonitor;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUICommandHelper;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.PrepareConfigJob;
import oracle.install.driver.oui.SRVMInstallExceptionHandler;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SessionInitProgressMonitor;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.ShiphomeMetadata;
import oracle.install.driver.oui.config.ConfigClient;
import oracle.install.driver.oui.ui.DefaultAlertHandler;
import oracle.install.driver.oui.ui.DefaultInstallCancelHandler;
import oracle.install.driver.oui.ui.DefaultRetryHandler;
import oracle.install.driver.oui.util.SetupSummary;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiic.OiicSystemPropertyConstants;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifm.OiifmAlertHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixWinOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OUISetupDriver<T>
extends SetupDriver<T> {
    public static final String PROPERTY_PROXY_MAPPINGS = "oracle.install.driver.oui.proxyMappings";
    private static Logger logger = Logger.getLogger(OUISetupDriver.class.getName());
    private OiifmAlertHandler alertHandler;
    private OiicInstallCancelHandler installCancelHandler;
    private OiifbIRetry retryHandler;
    private ApplicationListener pauseListener;
    private static final String STARTUP_LOCATION = System.getProperty("oracle.installer.startup_location");
    private Resource stringResource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);

    public OUISetupDriver() {
        this.pauseListener = new ApplicationListener(){

            public void update(ApplicationEvent e) {
                if (e.getType() == ApplicationEvent.Type.PAUSE) {
                    OUISetupDriver.this.pause();
                } else if (e.getType() == ApplicationEvent.Type.RESUME) {
                    OUISetupDriver.this.resume();
                }
            }
        };
    }

    protected void prepareConfig(PrepareConfigJob configJob) throws SetupDriverException, IOException {
        logger.log(Level.INFO, "Preparing configuration");
        boolean isConfigToolFailed = false;
        String runConfigCommand = "";
        ConfigClient configClient = ConfigClient.getConfigClient();
        SetupJob setupJob = configJob.getSetupJob();
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        String oracleHome = sessionDetails.getOHLoc();
        String topAggrId = null;
        String[] topLevelComponent = (String[])sessionDetails.getVariableMap().get("TOPLEVEL_COMPONENT");
        if (topLevelComponent != null) {
            topAggrId = topLevelComponent[0];
        }
        try {
            configClient.init(oracleHome, false, topAggrId);
            Map<String, String> defaultConfigParams = configJob.getDefaultConfigParameters();
            Map<String, Map<String, String>> params = configJob.getTransientParametersMap();
            configClient.updateTransientParameters(params, defaultConfigParams);
            String logDir = oracleHome + File.separator + "cfgtoollogs";
            configClient.setLogDirectory(logDir);
            runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
            OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
            this.updateSetupSummary(configJob);
            configClient.saveSession();
            configClient.endSession();
        }
        catch (CfwException e) {
            throw new SetupDriverException(e);
        }
        logger.log(Level.INFO, "Completed preparation for configuration");
    }

    protected URL getProxyMappingsURL() {
        URL mappingsURL = null;
        String url = System.getProperty(PROPERTY_PROXY_MAPPINGS);
        if (url != null) {
            try {
                mappingsURL = new URL(url);
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "Failed while using proxy mapping URL set in System.properties. Reason: {0}", e.getMessage());
            }
        }
        if (mappingsURL == null) {
            mappingsURL = this.getClass().getResource("/oracle/install/driver/oui/proxy-mappings.properties");
            logger.log(Level.INFO, "Using default oui proxy mapping URL");
        }
        return mappingsURL;
    }

    protected StatusMessages<ErrorMessage> verifyEnvironment() throws Exception {
        logger.log(Level.INFO, "Verifying target environment...");
        StatusMessages<ErrorMessage> errorMessages = new StatusMessages<ErrorMessage>();
        try {
            NetworkUtility utility = NetworkUtility.getInstance();
            logger.log(Level.INFO, "Checking whether the IP address of the localhost could be determined...");
            utility.getLocalHostName();
            ClusterVerification cvu = ClusterVerification.getInstance();
            if (!cvu.isPreReqSupported()) {
                errorMessages.add(new DefaultErrorMessage((ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
            }
        }
        catch (NetworkUtilityException e) {
            logger.log(Level.SEVERE, "Unable to determine a valid IP for the localhost.", e);
            errorMessages.add(new DefaultErrorMessage(e));
        }
        catch (PreReqNotSupportedException e) {
            logger.log(Level.SEVERE, "CVU do not support target environment.", e);
            errorMessages.add(new DefaultErrorMessage((Throwable)e, (ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
        }
        catch (VerificationException e) {
            logger.log(Level.SEVERE, "Error while verifying whether the target environment is supported by CVU or not.", e);
            errorMessages.add(new DefaultErrorMessage((Throwable)e, (ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unexpected runtime-error while verifying whether the target environment is supported by CVU or not.", t);
            errorMessages.add(new DefaultErrorMessage(t, (ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
        }
        logger.log(Level.INFO, "Completed verification of target environment.");
        return errorMessages;
    }

    @Override
    public void load() throws SetupDriverException {
        ExceptionManager.getInstance().addExceptionHandler(InstallException.class, new SRVMInstallExceptionHandler());
        URL mappingsURL = this.getProxyMappingsURL();
        ProxyFactory proxyFactory = ProxyFactory.getInstance();
        try {
            proxyFactory.registerProxies(mappingsURL);
        }
        catch (IOException e) {
            new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        String scratch_path = System.getProperty("oracle.installer.scratchPath");
        if (scratch_path == null) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.SCRATCHPATH_NOT_DEFINED, new Object[0]);
        }
        if (!new File(scratch_path).exists()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INSTALL_COMMON_INVALID_SCRATCHPATH, scratch_path);
        }
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        int returnCodeInvCheck = -1;
        try {
            returnCodeInvCheck = apiInstaller.initInstallEnvironment(this.properties, true, 1);
        }
        catch (OiicIllegalStateException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (OiicInstallAPIException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (Throwable t) {
            throw new SetupDriverException(t, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        if (returnCodeInvCheck == 1001 && !OiiiInstallAreaControl.isCleanMachine()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INVENTORY_INIT_FAILED, new Object[0]);
        }
        String logLocation = System.getProperty("oracle.installer.prereqLogLoc");
        if (logLocation == null || logLocation.length() == 0) {
            String defaultLogLocation = apiInstaller.getDefaultLogLoc();
            if (defaultLogLocation == null) {
                File file = new File("logs");
                file.mkdir();
                if (file.exists() && file.isDirectory()) {
                    defaultLogLocation = file.getAbsolutePath();
                    System.setProperty("oracle.installer.prereqLogLoc", defaultLogLocation);
                }
            } else {
                System.setProperty("oracle.installer.prereqLogLoc", defaultLogLocation);
            }
        }
        OUILogHandler.setDirectLoggingEnabled(true);
        ConfigHelper.init();
        Application application = Application.getInstance();
        if (DriverHelper.isCVUEnabled()) {
            String path = System.getProperty("oracle.installer.scratchPath");
            String startupLocation = System.getProperty("oracle.installer.startup_location");
            String workDir = System.getProperty("java.io.tmpdir");
            String frameworkHome = startupLocation + "/../stage/cvu";
            String refDataFile = frameworkHome + "/cvu_prereq.xml";
            try {
                ClusterVerification cvu = ClusterVerification.getInstance((String)workDir, (String)frameworkHome);
                cvu.setPreReqXmlFile(refDataFile);
            }
            catch (InvalidPathException e) {
                logger.log(Level.SEVERE, "Failed while specify cvu_prereq.xml as " + refDataFile, e);
                ExceptionManager.handle(e);
            }
            catch (VerificationException e) {
                ExceptionManager.handle(e);
            }
            if (!application.getArguments().contains("-ignorePrereq")) {
                StatusMessages<ErrorMessage> errorMessages = null;
                try {
                    errorMessages = this.verifyEnvironment();
                }
                catch (Throwable e) {
                    ExceptionManager.handle(e);
                }
                if (errorMessages != null && !errorMessages.isEmpty()) {
                    logger.log(Level.WARNING, "Verification of target environment returned with errors.");
                    Advice advice = ExceptionManager.advise(errorMessages);
                    if (advice == Advice.ABORT || advice == Advice.WITHDRAW) {
                        logger.log(Level.WARNING, "Advised to shutdown the installer due to target environment verification errors.");
                        application.shutdown(OUIExitStatus.PREREQ_FAILURE);
                    } else {
                        logger.log(Level.WARNING, "Advised to ignore target environment verification errors.");
                        application.setAttribute("isCVUPrereqExecutionNotSupportedForOS", Boolean.TRUE);
                    }
                }
            }
        } else {
            application.setAttribute("isCVUPrereqExecutionNotSupportedForOS", Boolean.TRUE);
        }
    }

    protected void loadHandlers(Component owner) {
        this.alertHandler = new DefaultAlertHandler(owner);
        this.installCancelHandler = new DefaultInstallCancelHandler(owner);
        this.retryHandler = new DefaultRetryHandler(owner);
    }

    protected void setup(SetupJob setupJob) throws SetupDriverException {
        OiicIOUIAPISession session;
        logger.log(Level.INFO, "Starting to setup " + setupJob.getId().toString());
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        if (sessionDetails != null && (session = this.initSession(setupJob)) != null) {
            try {
                OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
                apiInstaller.doOperation();
                OiifmIRootShInfo[] rootScripts = session.getRootShInfo();
                logger.log(Level.INFO, "Number of root scripts to be executed = " + (rootScripts != null ? rootScripts.length : 0));
                setupJob.setRootScripts(rootScripts);
                this.updateSetupSummary(setupJob);
            }
            catch (OiicIllegalStateException e) {
                throw new SetupDriverException(e);
            }
            catch (OiicInstallAPIException e) {
                throw new SetupDriverException(e);
            }
            catch (Exception e) {
                throw new SetupDriverException(e);
            }
            finally {
                this.closeSession(sessionDetails, session);
            }
        }
        logger.log(Level.INFO, "Completed setting up " + setupJob.getId().toString());
    }

    private void log(Level level, String message, Object ... args) {
        if (this.progressUI != null) {
            this.progressUI.log(level, message, args);
        } else {
            logger.log(level, message, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertCentralInventoryNotLocked() {
        if (OiiiInstallAreaControl.isCleanMachine()) {
            return;
        }
        boolean locked = false;
        String appId = "installActions";
        String appVer = "11.2";
        int retryStatus = 16;
        do {
            OiicStandardInventorySession session = new OiicStandardInventorySession(appId, appVer);
            try {
                String status = this.stringResource.getString("OUISetupDriver.centralInventoryLockCheck.text", "Verifying whether Central Inventory is locked by any other OUI session...", new Object[0]);
                this.log(Level.INFO, status, new Object[0]);
                locked = false;
                session.initSession(1);
                status = this.stringResource.getString("OUISetupDriver.centralInventoryLockCheck.success.text", "Central Inventory is not locked.", new Object[0]);
                this.log(Level.INFO, status, new Object[0]);
            }
            catch (OiitTargetLockNotAvailableException e) {
                locked = true;
                String errorMessage = e.getLocalizedMessage();
                logger.log(Level.SEVERE, errorMessage);
                SetupMode setupMode = this.getSetupMode();
                if (setupMode != SetupMode.INTERACTIVE) continue;
                retryStatus = this.retryHandler.doModal(errorMessage, 18, 0);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unexpected error while checking Central Inventory", t);
            }
            finally {
                session.endSession();
            }
        } while (locked && retryStatus == 2);
        if (locked) {
            Application.getInstance().shutdown(OUIExitStatus.STOP_INSTALL);
        }
    }

    @Override
    public void setup() throws SetupDriverException {
        String msg;
        Status status = Status.FAILED;
        CompositeJob setupJob = this.prepareJob();
        setupJob.calibrate();
        this.properties = new Properties();
        if (this.progressUI != null) {
            ProgressModel progressModel;
            Object owner = this.progressUI.getOwner();
            if (owner instanceof Component) {
                this.loadHandlers((Component)owner);
            }
            if ((progressModel = this.progressUI.getProgressModel()) != null) {
                progressModel.setCompositeJobs(setupJob);
            }
        }
        this.assertCentralInventoryNotLocked();
        List<Job> jobs = setupJob.getJobs();
        logger.log(Level.INFO, "-----------Job Distribution------------");
        for (Job job : jobs) {
            logger.log(Level.INFO, "{0} : {1}", new Object[]{job.getDescription(), Float.valueOf(job.getActualWeightage())});
        }
        logger.log(Level.INFO, "---------------------------------------");
        ExecutorService service = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("OUISetupDriver.JobExecutorThread");
                return t;
            }
        });
        try {
            for (Job job : jobs) {
                Callable<?> work = job.getWork();
                if (work == null) continue;
                Future<?> future = service.submit(work);
                job.setStatus(Status.INPROGRESS);
                future.get();
                Status s = job.getStatus();
                if (s == Status.SUCCEEDED || s == Status.SUCCEEDED_PARTIALLY || !job.isRequired()) continue;
                break;
            }
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof SetupDriverException) {
                throw (SetupDriverException)t;
            }
            throw new SetupDriverException(t);
        }
        catch (InterruptedException e) {
            throw new SetupDriverException(e);
        }
        finally {
            try {
                logger.info("Shutting down OUISetupDriver.JobExecutorThread");
                service.shutdown();
            }
            catch (Exception e) {
                logger.severe("Unable to shutdown OUISetupDriver.JobExecutorThread. Error: " + e.getMessage());
            }
        }
        if ((msg = SetupSummary.getInstance().getText()) != null && msg.length() > 0 && this.getSetupMode() == SetupMode.SILENT) {
            Console.println(msg + "\n");
        }
        Application application = Application.getInstance();
        StatusControl statusControl = application.getStatusControl();
        statusControl.showMessage("Cleaning up, please wait...");
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        apiInstaller.disposeInstance();
        statusControl.close();
        status = setupJob.getStatus();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(JobHelper.getJobTreeAsString(setupJob));
        }
        super.fireSetupDriverEvent(new SetupDriverEvent(this, status));
    }

    @Override
    public void pause() throws IllegalStateException {
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        apiInstaller.suspendOperation();
    }

    @Override
    public void resume() throws IllegalStateException {
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        apiInstaller.resumeOperation();
    }

    @Override
    public void unload() throws SetupDriverException {
        try {
            DriverHelper.doCleanup();
        }
        catch (Exception e) {
            throw new SetupDriverException(e);
        }
    }

    protected OiicIOUIAPISession initSession(SetupJob setupJob) throws SetupDriverException {
        logger.log(Level.INFO, "Initializing setup " + setupJob.getId().toString());
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        HashMap hashMap = sessionDetails.getVariableMap();
        Set<String> securePropertySet = sessionDetails.getSecurePropertySet();
        if (securePropertySet == null && BeanStoreUtils.isBean(this.setupBean)) {
            try {
                securePropertySet = BeanStoreUtils.getSecurePropertySet(this.setupBean);
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Failed to get secure property set from the SetupBean.", e);
            }
        }
        DriverHelper.logSessionDetails(hashMap, securePropertySet);
        String oracle_home = hashMap.get("ORACLE_HOME").toString();
        File readmeLoc = new File(oracle_home, "install/readme.txt");
        hashMap.put("readme.exist", readmeLoc.exists());
        String oracle_home_name = InventoryInfo.getInstance().computeOracleHomeName(oracle_home);
        hashMap.put("ORACLE_HOME_NAME", oracle_home_name);
        String bitvalue = "";
        if (this.getProperty("ARCHITECTURE") != null) {
            bitvalue = this.getProperty("ARCHITECTURE");
        }
        hashMap.put("oracle_install_architecture", bitvalue);
        if (PlatformInfo.getInstance().isWindows()) {
            try {
                String windowSysDir = OiixWinOps.getWindowsSystemDirectory();
                hashMap.put("s_windowsSystemDirectory", windowSysDir);
                hashMap.put("oracle_install_windowsCommandLine", windowSysDir + "\\cmd /c call ");
            }
            catch (Exception e) {
                throw new SetupDriverException(e);
            }
        }
        if (!PlatformInfo.getInstance().isWindows()) {
            String unixMakePath;
            if (OiixPlatform.getCurrentPlatform() == 46 || OiixPlatform.getCurrentPlatform() == 110 || OiixPlatform.getCurrentPlatform() == 227 || OiixPlatform.getCurrentPlatform() == 211) {
                try {
                    unixMakePath = "/usr/bin/make";
                    hashMap.put("oracle_install_UnixMakePath", unixMakePath);
                }
                catch (Exception e) {
                    throw new SetupDriverException(e);
                }
            }
            try {
                unixMakePath = "/usr/ccs/bin/make";
                hashMap.put("oracle_install_UnixMakePath", unixMakePath);
            }
            catch (Exception e) {
                throw new SetupDriverException(e);
            }
        }
        OiicIOUIAPISession session = null;
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        try {
            ArrayList<SessionDetails> sessions = new ArrayList<SessionDetails>();
            sessions.add(sessionDetails);
            apiInstaller.registerInstallAPISession(sessions);
        }
        catch (Exception e) {
            throw new SetupDriverException(e);
        }
        try {
            SessionInitProgressMonitor sessionInitMonitor;
            OUILogHandler.setDirectLoggingEnabled(false);
            session = apiInstaller.initOUIAPISession();
            if (this.alertHandler != null) {
                session.addAlertHandler(this.alertHandler);
            }
            if (this.installCancelHandler != null) {
                session.addInstallCancelHandler(this.installCancelHandler);
            }
            if (this.retryHandler != null) {
                session.addRetryHandler(this.retryHandler);
            }
            if ((sessionInitMonitor = setupJob.getSessionInitMonitor()) != null) {
                sessionInitMonitor.setProgressUI(this.progressUI);
                session.setInterviewProgressListener((OiixProgressListener)sessionInitMonitor);
            }
            apiInstaller.prepareForInstallOperations();
            InstallProgressMonitor installProgressMonitor = setupJob.getInstallProgressMonitor();
            if (installProgressMonitor != null) {
                installProgressMonitor.setProgressUI(this.progressUI);
                session.setInstallProgresListener((OiifrProgressActionListener)installProgressMonitor);
            }
            Application application = Application.getInstance();
            application.addApplicationListener(this.pauseListener);
        }
        catch (OiicInstallAPIException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.INSTALL_COMMON_SESSION_INIT_FAILED, new Object[0]);
        }
        catch (OiicIllegalStateException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.INSTALL_COMMON_SESSION_INIT_FAILED, new Object[0]);
        }
        return session;
    }

    @Override
    public String getProperty(String key) {
        ShiphomeMetadata metadata = null;
        if (this.properties.isEmpty()) {
            this.properties = new Properties();
            File metadataFile = new File(STARTUP_LOCATION, File.separator + ".." + File.separator + "stage" + File.separator + "shiphomeproperties.xml");
            try {
                metadata = ShiphomeMetadata.newInstance(metadataFile);
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, "Error on retrieving the metadata of shiphomeproperties xml", e1);
            }
            if (metadata != null && metadata.getProperties() != null) {
                this.properties.putAll(metadata.getProperties());
            }
        }
        if (this.properties.get(key) != null) {
            return this.properties.get(key).toString();
        }
        return null;
    }

    protected void closeSession(SessionDetails sessionDetails, OiicIOUIAPISession session) throws SetupDriverException {
        boolean bool = session.getISession().getContext().getSession().isSuccessfullInstallation();
        logger.info("isSuccessfullInstallation: " + bool);
        Summary.getInstance().setSuccessfullInstall(bool);
        boolean rbool = session.getISession().getContext().getSession().isSuccessfullRemoteInstallation();
        logger.info("isSuccessfullRemoteInstallation: " + rbool);
        Summary.getInstance().setSuccessfullRemoteInstall(rbool);
        int exitCode = OiicExitCode.getExitCode();
        OUIExitStatus exitStatus = OUIExitStatus.valueOf(exitCode);
        if (exitStatus == null) {
            exitStatus = bool ? OUIExitStatus.SUCCESS : (rbool ? OUIExitStatus.LOCAL_SUCCESS_REMOTE_FAILURE : OUIExitStatus.FAILURE);
        }
        Application.addExitStatus(exitStatus);
        Application application = Application.getInstance();
        application.removeApplicationListener(this.pauseListener);
        session.setInstallProgresListener(null);
        session.dispose();
    }

    @Override
    public void processCommandLine(String ... args) {
        String[] argsWithSharedInvFlag = new String[args.length + 1];
        System.arraycopy(args, 0, argsWithSharedInvFlag, 0, args.length);
        argsWithSharedInvFlag[args.length] = "-ignoreSharedInventory";
        args = argsWithSharedInvFlag;
        OiicAPIInstaller oiicInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        try {
            Field[] fields;
            args = OUICommandHelper.validateArguments(args);
            oiicInstaller.processCommandLine(args);
            Hashtable table = oiicInstaller.getCommandLineArgsTable();
            if (table != null && !table.isEmpty()) {
                this.commandLineArgs = new Properties();
                this.commandLineArgs.putAll((Map<?, ?>)table);
                this.commandLineArgs.putAll(OUICommandHelper.getSetupArguments(args));
            }
            Class<OiicSystemPropertyConstants> clazz = OiicSystemPropertyConstants.class;
            for (Field field : fields = clazz.getFields()) {
                if (!field.getType().equals(String.class)) continue;
                try {
                    String value;
                    String key = (String)field.get(null);
                    if (key == null || (value = System.getProperty(key)) == null) continue;
                    super.setProperty(key, value);
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        catch (OiicInvalidCmdLineException e) {
            throw new IllegalArgumentException(e.getErrorMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void config(ConfigJob configJob, boolean retry) throws SetupDriverException, IOException {
        ConfigClient configClient;
        block29: {
            ArrayList<IMicroStepStateReference> selectedTools;
            IAggregate aggregate;
            logger.log(Level.INFO, "Performing Configuration");
            ActionType actionType = ActionType.CONFIGURATION;
            boolean silentMode = this.getSetupMode() == SetupMode.SILENT;
            boolean isConfigToolFailed = false;
            String runConfigCommand = "";
            configClient = ConfigClient.getConfigClient();
            ConfigProgressMonitor configProgressMonitor = configJob.getConfigProgressMonitor();
            if (configProgressMonitor != null) {
                configProgressMonitor.setProgressUI(this.progressUI);
            }
            SetupJob setupJob = configJob.getSetupJob();
            SessionDetails sessionDetails = setupJob.getSessionDetails();
            String oracleHome = sessionDetails.getOHLoc();
            String topAggrId = null;
            String[] topLevelComponent = (String[])sessionDetails.getVariableMap().get("TOPLEVEL_COMPONENT");
            if (topLevelComponent != null) {
                topAggrId = topLevelComponent[0];
            }
            try {
                configClient.init(oracleHome, false, topAggrId);
                aggregate = configClient.getTopLevelAggregate();
                if (aggregate == null) {
                    configJob.setStatus(Status.SUCCEEDED);
                    return;
                }
                selectedTools = null;
                IMicroStepStateReference[] tools = configClient.getToolsList(false, false, false, true, actionType);
                if (!retry) {
                    configJob.removeAll();
                    if (tools == null || tools.length == 0) {
                        configJob.setStatus(Status.SUCCEEDED);
                        return;
                    }
                    for (IMicroStepStateReference entry : tools) {
                        String pluginId = configClient.getToolName(entry);
                        String displayName = configClient.getLocalizedDisplayName(entry);
                        if (displayName == null || displayName.trim().length() == 0) {
                            displayName = pluginId;
                        }
                        boolean required = configClient.isRequiredTool(entry);
                        ConfigAssistantJob task = new ConfigAssistantJob(pluginId, displayName, entry, required);
                        logger.log(Level.INFO, "Created config job for " + pluginId);
                        configJob.add(task);
                    }
                }
                selectedTools = new ArrayList<IMicroStepStateReference>();
                List<Job> retriableJobs = configJob.getRetriableJobs();
                block18: for (Job job : retriableJobs) {
                    for (IMicroStepStateReference tool : tools) {
                        String pluginId = configClient.getToolName(tool);
                        if (!job.getId().equals(pluginId)) continue;
                        selectedTools.add(tool);
                        continue block18;
                    }
                }
            }
            catch (CfwException e) {
                throw new SetupDriverException(e);
            }
            Map<String, String> defaultConfigParams = configJob.getDefaultConfigParameters();
            Map<String, Map<String, String>> params = configJob.getTransientParametersMap();
            configClient.updateTransientParameters(params, defaultConfigParams);
            try {
                configClient.registerEventListener(configProgressMonitor);
            }
            catch (CfwException e) {
                throw new SetupDriverException(e);
            }
            String logDir = oracleHome + File.separator + "cfgtoollogs";
            configClient.setLogDirectory(logDir);
            runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
            OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
            if (selectedTools != null) {
                configClient.executeSelectedToolsInAggregate(true, silentMode, false, true, actionType, aggregate, selectedTools.toArray(new IMicroStepStateReference[0]));
            } else {
                configClient.executeToolsInAggregate(true, silentMode, false, true, actionType, aggregate);
            }
            if (isConfigToolFailed = configJob.getStatus() != Status.SUCCEEDED) {
                runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
                OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
            }
            Summary.getInstance().setSuccessfulConfig(!isConfigToolFailed);
            if (isConfigToolFailed) break block29;
            Application.addExitStatus(OUIExitStatus.SUCCESS_MINUS_RECTOOL);
            break block29;
            finally {
                try {
                    configClient.unregisterEventListener(configProgressMonitor);
                }
                catch (CfwException e) {}
            }
        }
        this.updateSetupSummary(configJob);
        configClient.saveSession();
        configClient.endSession();
        logger.log(Level.INFO, "Completed Configuration");
    }

    protected void config(ConfigJob configJob) throws SetupDriverException, IOException {
        this.config(configJob, false);
    }

    public boolean isConfigDisabled() {
        return Application.getInstance().getArguments().contains("-noconfig");
    }

    @Override
    public void showUsage() {
        OUICommandHelper.showUsage();
    }

    protected void updateSetupSummary(SetupJob setupJob) {
        if (!setupJob.isConfigurationRequired()) {
            SessionDetails sessionDetails = setupJob.getSessionDetails();
            File oracleHome = new File(sessionDetails.getOHLoc());
            SetupSummary summary = SetupSummary.getInstance();
            if (oracleHome != null && oracleHome.exists() && this.getSetupMode() == SetupMode.INTERACTIVE && sessionDetails.getVariableMap().get("readme.exist") == Boolean.FALSE) {
                summary.append(DriverHelper.getReadmeFileContent(oracleHome));
            }
        }
    }

    protected void updateSetupSummary(ConfigJob configJob) {
        SetupJob setupJob = configJob.getSetupJob();
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        File oracleHome = new File(sessionDetails.getOHLoc());
        SetupSummary summary = SetupSummary.getInstance();
        if (oracleHome != null && oracleHome.exists() && this.getSetupMode() == SetupMode.INTERACTIVE) {
            summary.append(DriverHelper.getReadmeFileContent(oracleHome));
        }
    }

    protected void updateSetupSummary(PrepareConfigJob prepareConfigJob) {
        SetupJob setupJob = prepareConfigJob.getSetupJob();
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        File oracleHome = new File(sessionDetails.getOHLoc());
        SetupSummary summary = SetupSummary.getInstance();
        if (this.getSetupMode() == SetupMode.SILENT) {
            Application application = Application.getInstance();
            summary.append(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "configTools.message.header"), "", new Object[0]));
            summary.append(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "configTools.text"), "", new File(new File(oracleHome, "cfgtoollogs").getPath(), OiiolTextLogger.s_sConfigToolCommands).getPath()));
        }
        if (oracleHome != null && oracleHome.exists() && this.getSetupMode() == SetupMode.INTERACTIVE) {
            summary.append(DriverHelper.getReadmeFileContent(oracleHome));
        }
    }
}

