/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.SetupJob;
import oracle.sysman.oii.oiif.oiifj.OiifjRootShDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootScriptJob
extends Job
implements Callable<Void>,
Retriable<RootScriptJob> {
    private static final Logger logger = Logger.getLogger(RootScriptJob.class.getName());
    private SetupJob setupJob;
    private Filter filter;

    public RootScriptJob(SetupJob setupJob) {
        this(setupJob, null);
    }

    public RootScriptJob(SetupJob setupJob, Filter filter) {
        this(setupJob, null, filter);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        Application application = Application.getInstance();
        this.setDescription(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "rootScriptJob.text"), "Execute Root Scripts for {0}", setupJob.getDescription()));
    }

    public RootScriptJob(SetupJob setupJob, String description, Filter filter) {
        super("rootscript", null, 0.05f);
        this.setDescription(description);
        this.setupJob = setupJob;
        this.filter = filter;
    }

    public SetupJob getSetupJob() {
        return this.setupJob;
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        this.setStatus(Status.INPROGRESS);
        OiifmIRootShInfo[] rootScripts = this.setupJob.getRootScripts();
        logger.log(Level.INFO, "Number of root scripts to be executed = " + (rootScripts != null ? rootScripts.length : 0));
        boolean succeeded = true;
        if (rootScripts != null) {
            ArrayList<OiifmIRootShInfo> filteredRootScripts = new ArrayList<OiifmIRootShInfo>();
            ArrayList<OiifmIRootShInfo> choosenRootScripts = new ArrayList<OiifmIRootShInfo>();
            for (OiifmIRootShInfo rootScriptInfo : rootScripts) {
                if (this.filter == null || this.filter.accept(rootScriptInfo.getRootShLocation())) {
                    choosenRootScripts.add(rootScriptInfo);
                    continue;
                }
                filteredRootScripts.add(rootScriptInfo);
            }
            if (!choosenRootScripts.isEmpty() && !filteredRootScripts.isEmpty()) {
                this.setupJob.setRootScripts(filteredRootScripts.toArray(new OiifmIRootShInfo[0]));
            }
            Object driver = SetupDriver.getInstance();
            switch (((SetupDriver)driver).getSetupMode()) {
                case SILENT: {
                    this.showTextually(choosenRootScripts);
                    break;
                }
                case INTERACTIVE: {
                    succeeded = this.showGraphically(choosenRootScripts);
                }
            }
        }
        if (succeeded) {
            this.setStatus(Status.SUCCEEDED);
        } else {
            this.setStatus(Status.FAILED);
        }
        return null;
    }

    protected boolean showGraphically(List<OiifmIRootShInfo> rootScripts) {
        Object setupDriver = SetupDriver.getInstance();
        ProgressUI progressUI = ((SetupDriver)setupDriver).getProgressUI();
        if (progressUI != null) {
            Object owner = progressUI.getOwner();
            if (owner instanceof Component) {
                Window window = SwingUtilities.windowForComponent((Component)owner);
                if (window instanceof Frame) {
                    boolean bool;
                    OiifjRootShDlg inv = new OiifjRootShDlg((Frame)window, rootScripts);
                    inv.doModal();
                    ErrorMessage errorMessage = this.verify();
                    if (errorMessage != null && (bool = this.showRootScriptWarning((Component)owner, errorMessage))) {
                        return false;
                    }
                    logger.log(Level.INFO, "User accepted to run root scripts");
                }
            } else {
                this.showTextually(rootScripts);
            }
        }
        return true;
    }

    protected void showTextually(List<OiifmIRootShInfo> rootScripts) {
        Application application = Application.getInstance();
        Console.println(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "rootScriptJob.message.header"), "", new Object[0]));
        for (OiifmIRootShInfo rootScript : rootScripts) {
            Console.println(rootScript.getRootShLocation());
        }
        Console.println(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "rootScriptJob.message.footer"), "", new Object[0]));
    }

    public ErrorMessage verify() {
        return null;
    }

    public boolean showRootScriptWarning(Component owner, ErrorMessage errorMessage) {
        return false;
    }

    @Override
    public List<RootScriptJob> getRetriableJobs() {
        ArrayList<RootScriptJob> retriableJobs = new ArrayList<RootScriptJob>();
        Status status = this.getStatus();
        if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
            retriableJobs.add(this);
        }
        return retriableJobs;
    }

    @Override
    public void retry() throws Exception {
        this.call();
    }

    public static interface Filter {
        public boolean accept(String var1);
    }

    public static class InventoryFilter
    implements Filter {
        private String path;

        public InventoryFilter(String path) {
            this.path = path;
        }

        public boolean accept(String script) {
            return script != null && this.path != null && script.trim().startsWith(this.path.trim());
        }
    }
}

