/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.driver.oui.DriverConstants;

class SafeLogLocationInputPane
extends JPanel {
    private JPanel logLocationPanel = null;
    private JLabel lblLogLocation = null;
    private MultilineLabel lblLogLocationDesc = null;
    private JTextField textLogLocation = null;
    private JButton buttonBrowse = null;
    private Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
    private static final Dimension DEFAULT_MULTILINE_LABEL_SIZE = new Dimension(500, 100);

    public SafeLogLocationInputPane() {
        this.logLocationPanel = new JPanel();
        this.lblLogLocationDesc = new MultilineLabel();
        this.lblLogLocationDesc.setPreferredSize(DEFAULT_MULTILINE_LABEL_SIZE);
        this.lblLogLocation = new JLabel();
        this.lblLogLocation.setText(this.resource.getString("INSTALL_MOVE_LOGFILE_DLG_NEW_LOGLOCATION_LABEL", "New log location:", new Object[0]));
        this.textLogLocation = new JTextField();
        this.lblLogLocation.setLabelFor(this.textLogLocation);
        this.buttonBrowse = new JButton();
        String browseBtnText = this.resource.getString("INSTALL_MOVE_LOGFILE_DLG_BROWSE_BUTTON_LABEL", "&Browse...", new Object[0]);
        int index = StringUtils.getMnemonicIndex((String)browseBtnText);
        int keycode = StringUtils.getMnemonicKeyCode((String)browseBtnText);
        if (index != -1) {
            this.buttonBrowse.setMnemonic(keycode);
        }
        this.buttonBrowse.setText(StringUtils.stripMnemonic((String)browseBtnText));
        this.buttonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SafeLogLocationInputPane.this.browseButtonClicked();
            }
        });
        this.logLocationPanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblLogLocationDesc, this.logLocationPanel, 0, 0, 3, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.lblLogLocation, this.logLocationPanel, 0, 1, 1, 1, 0, 18, 0.0, 0.0, new Insets(5, 5, 10, 5));
        LayoutUtils.addComponent(this.textLogLocation, this.logLocationPanel, 1, 1, 1, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 10, 5));
        LayoutUtils.addComponent(this.buttonBrowse, this.logLocationPanel, 2, 1, 1, 1, 0, 12, 0.0, 0.0, new Insets(5, 5, 10, 5));
    }

    protected void updateBestSize() {
        Dimension bestSize = SwingUtils.getBestSize(this.lblLogLocationDesc, DEFAULT_MULTILINE_LABEL_SIZE);
        if (!bestSize.equals(DEFAULT_MULTILINE_LABEL_SIZE)) {
            this.lblLogLocationDesc.setPreferredSize(bestSize);
        }
    }

    private void browseButtonClicked() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(this.resource.getString("INSTALL_CHOOSE_DIRECTORY_LABEL", "Select Directory", new Object[0]));
        chooser.setApproveButtonText(this.resource.getString("INSTALL_SELECT_LABEL", "Select", new Object[0]));
        String defaultDir = this.textLogLocation.getText();
        if (defaultDir.length() == 0) {
            defaultDir = File.separator;
        }
        File curDir = new File(defaultDir);
        chooser.setCurrentDirectory(curDir);
        int returnVal = chooser.showOpenDialog(this.logLocationPanel);
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.textLogLocation.setText(path);
        }
    }

    public JPanel getSafeLogLocationPane() {
        return this.logLocationPanel;
    }

    public String getSafeLogLocation() {
        return this.textLogLocation.getText();
    }

    public void setSafeLogLocation(String loc) {
        this.textLogLocation.setText(loc);
    }

    public void setSafeLogLocDesc(String desc) {
        this.lblLogLocationDesc.setText(desc);
        this.updateBestSize();
    }
}

