/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.concurrent.Callable;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Pausable;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.InstallProgressMonitor;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SessionInitProgressMonitor;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupJob
extends CompositeJob
implements Callable<Void> {
    private boolean mutlinodeSetup;
    private SessionDetails sessionDetails;
    private SessionInitProgressMonitor sessionInitMonitor;
    private InstallProgressMonitor installProgressMonitor;
    private OiifmIRootShInfo[] rootScripts;
    private boolean configurationRequired;
    private static final Pausable PAUSABLE = new Pausable(){

        public void pause() throws Exception {
            Object driver = SetupDriver.getInstance();
            ((SetupDriver)driver).pause();
        }

        public void resume() throws Exception {
            Object driver = SetupDriver.getInstance();
            ((SetupDriver)driver).resume();
        }
    };

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails) {
        this(id, description, weightage, sessionDetails, false, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, boolean multinodeSetup) {
        this(id, description, weightage, sessionDetails, multinodeSetup, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, boolean multinodeSetup, boolean sharedHome) {
        super(id, description, weightage);
        this.sessionDetails = sessionDetails;
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        CompositeJob initPhase = new CompositeJob((Object)"init", 0.1f);
        initPhase.setHidden(true);
        Job job = new Job((Object)"prepare", resource.getString("setupJob.init.prepare.text", "Prepare", new Object[0]));
        initPhase.add(job);
        this.add(initPhase);
        CompositeJob installPhase = new CompositeJob((Object)"install", 0.9f);
        installPhase.setHidden(true);
        job = new Job(OiifrProgressPhases.INSTALL_PHASE, resource.getString("setupJob.install.copy.text", "Copy files", new Object[0]), 0.6f);
        installPhase.add(job);
        if (!PlatformInfo.getInstance().isWindows()) {
            job = new Job(OiifrProgressPhases.LINK_PHASE, resource.getString("setupJob.install.link.text", "Link binaries", new Object[0]), 0.2f);
            installPhase.add(job);
        }
        job = new Job(OiifrProgressPhases.INSTALL_PHASE2, resource.getString("setupJob.install.setup.text", "Setup files", new Object[0]), 0.2f);
        installPhase.add(job);
        if (multinodeSetup) {
            if (sharedHome) {
                job = new Job(OiifrProgressPhases.ADD_NODE_SAVE_INV_PHASE, resource.getString("setupJob.install.remoteinventorycopy.text", "Setup cluster inventory", new Object[0]), 0.2f);
                installPhase.add(job);
            } else {
                job = new Job(OiifrProgressPhases.CLUSTER_PHASE, resource.getString("setupJob.install.remotesetup.text", "Setup remote nodes", new Object[0]), 0.2f);
                installPhase.add(job);
            }
        }
        this.add(installPhase);
        this.sessionInitMonitor = new SessionInitProgressMonitor(initPhase, null);
        this.installProgressMonitor = new InstallProgressMonitor(installPhase, null);
        this.setPausable(PAUSABLE);
    }

    public boolean isMutlinodeSetup() {
        return this.mutlinodeSetup;
    }

    public OiifmIRootShInfo[] getRootScripts() {
        return this.rootScripts;
    }

    void setRootScripts(OiifmIRootShInfo[] rootScripts) {
        this.rootScripts = rootScripts;
    }

    public Callable<Void> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        Object driver = SetupDriver.getInstance();
        if (driver instanceof OUISetupDriver) {
            OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
            ouiSetupDriver.setup(this);
        }
        return null;
    }

    public InstallProgressMonitor getInstallProgressMonitor() {
        return this.installProgressMonitor;
    }

    public SessionInitProgressMonitor getSessionInitMonitor() {
        return this.sessionInitMonitor;
    }

    public SessionDetails getSessionDetails() {
        return this.sessionDetails;
    }

    public boolean isConfigurationRequired() {
        return this.configurationRequired;
    }

    public void setConfigurationRequired(boolean configurationRequired) {
        this.configurationRequired = configurationRequired;
    }
}

