/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BeanDef(value="shiphome-metadata", beanStore=true)
public class ShiphomeMetadata {
    private static final Logger logger = Logger.getLogger(ShiphomeMetadata.class.getName());
    public static final String ARCHITECTURE = "ARCHITECTURE";
    private Map<String, String> properties;
    private static final URL ext2raw = ShiphomeMetadata.class.getResource("resource/shiphomemetadatafmt_ext2raw.xsl");

    @PropertyDef(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getArchitecture() {
        return this.getProperty(ARCHITECTURE);
    }

    public String getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public static ShiphomeMetadata newInstance(File metadataFile) throws Exception {
        logger.log(Level.INFO, "Reading shiphome metadata from {0}", metadataFile);
        XmlBeanStoreSource source = new XmlBeanStoreSource(metadataFile.toURL(), new XmlBeanStoreFormat(null, null, ext2raw, null));
        ShiphomeMetadata metadata = BeanStoreUtils.restoreFromXML(source, ShiphomeMetadata.class);
        return metadata;
    }
}

