/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.etc;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.exception.UncheckedException;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;

public class UnhandledDriverException
extends UncheckedException {
    Severity severity;

    public UnhandledDriverException(ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        this.init();
    }

    public UnhandledDriverException(ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        this.init();
    }

    public UnhandledDriverException(Throwable cause) {
        super(cause);
        this.init();
    }

    public UnhandledDriverException(Content extraDetails, ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Content extraDetails, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, Content extraDetails, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, Content extraDetails, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, Content extraDetails) {
        super(cause);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    private void init() {
        this.severity = super.getErrorInfo().getSeverity();
        if (Application.isCommandLineSwitchEnabled("-ignoreInternalDriverError") && this.severity != Severity.WARNING) {
            this.severity = Severity.WARNING;
        }
    }

    public static PlainContent createExtraDetails(VerificationResultSet resultSet) {
        List failedNodes = new ArrayList();
        failedNodes = resultSet.getFailedNodes();
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append("<b>Summary of the failed nodes</b><br>");
        if (resultSet.hasNodeResults()) {
            try {
                List nodeResults = resultSet.getNodeResults();
                if (nodeResults != null) {
                    for (VerificationResult nodeResult : nodeResults) {
                        String node = nodeResult.getNode();
                        if (!failedNodes.contains(node)) continue;
                        messageBuffer.append("<b>" + node + "</b><br>");
                        List nodeSpecificErrors = nodeResult.getErrors();
                        for (VerificationError error : nodeSpecificErrors) {
                            messageBuffer.append("&nbsp;-&nbsp;");
                            messageBuffer.append(error.getErrorMessage() + "<br>");
                        }
                    }
                }
            }
            catch (NodeResultsUnavailableException e) {
                // empty catch block
            }
        }
        PlainContent content = new PlainContent(messageBuffer.toString());
        ContentType contentType = ContentType.HTML;
        content.setContentType(contentType);
        return content;
    }

    public Severity getSeverity() {
        return this.severity;
    }
}

