/*
 * Decompiled with CFR 0.152.
 */
package oracle.apex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.sql.CLOB;

/*
 * Exception performing whole class analysis ignored.
 */
public class APEXExport {
    Connection gConn;
    private final String gStmt = "select application_id, application_name from apex_applications order by application_id";
    private final String gStmtInstance = "select id, name from wwv_flows where security_group_id <> 10 order by id";
    private final String gStmtSetSGID = "begin wwv_flow_api.set_security_group_id(p_security_group_id=>?); end;";
    private final String gStmtGetSGID = "select v('FLOW_SECURITY_GROUP_ID') from dual";
    public boolean debug = false;
    public boolean skipDate = false;
    public boolean instance = false;
    public boolean savedReports = false;

    private void ExportFiles(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) throws SQLException, IOException {
        if (this.instance) {
            String string2 = null;
            PreparedStatement preparedStatement = this.gConn.prepareStatement("select id, name from wwv_flows where security_group_id <> 10 order by id");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Date date;
                BigDecimal bigDecimal3 = resultSet.getBigDecimal(1);
                string2 = resultSet.getString(2);
                System.out.println("Exporting Application " + bigDecimal3 + ":'" + string2 + "' ");
                if (this.debug) {
                    date = new Date();
                    System.out.println(" Start " + date);
                }
                this.ExportFile(bigDecimal3);
                date = new Date();
                System.out.println("  Completed at " + date);
            }
            resultSet.close();
            preparedStatement.close();
        } else if (bigDecimal2 != null && bigDecimal2.longValue() != 0L) {
            BigDecimal bigDecimal4 = new BigDecimal(0);
            String string3 = null;
            PreparedStatement preparedStatement = this.gConn.prepareStatement("begin wwv_flow_api.set_security_group_id(p_security_group_id=>?); end;");
            preparedStatement.setBigDecimal(1, bigDecimal2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.gConn.prepareStatement("select v('FLOW_SECURITY_GROUP_ID') from dual");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                bigDecimal4 = resultSet.getBigDecimal(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (!bigDecimal4.equals(bigDecimal2)) {
                System.out.println("Invalid Workspace ID '" + bigDecimal2 + "' for User '" + string + "'");
                System.exit(1);
            }
            preparedStatement = this.gConn.prepareStatement("select application_id, application_name from apex_applications order by application_id");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Date date;
                BigDecimal bigDecimal5 = resultSet.getBigDecimal(1);
                string3 = resultSet.getString(2);
                System.out.println("Exporting Application " + bigDecimal5 + ":'" + string3 + "' ");
                if (this.debug) {
                    date = new Date();
                    System.out.println(" Start " + date);
                }
                this.ExportFile(bigDecimal5);
                date = new Date();
                System.out.println("  Completed at " + date);
            }
            resultSet.close();
            preparedStatement.close();
        } else {
            Date date;
            System.out.println("Exporting application " + bigDecimal);
            if (this.debug) {
                date = new Date();
                System.out.println(" Start " + date);
            }
            this.ExportFile(bigDecimal);
            date = new Date();
            System.out.println("  Completed at " + date);
        }
    }

    public void ExportFile(BigDecimal bigDecimal) throws SQLException, IOException {
        boolean bl = true;
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.gConn.prepareCall("begin ? := wwv_flow_utilities.export_application_to_clob(?, ?); end;");
        if (this.savedReports) {
            oracleCallableStatement.setString(3, "Y");
        } else {
            oracleCallableStatement.setString(3, "N");
        }
        oracleCallableStatement.setBigDecimal(2, bigDecimal);
        oracleCallableStatement.registerOutParameter(1, 2005);
        oracleCallableStatement.execute();
        CLOB cLOB = oracleCallableStatement.getCLOB(1);
        Reader reader = cLOB.getCharacterStream();
        int n = cLOB.getBufferSize();
        char[] cArray = new char[n];
        int n2 = -1;
        File file = new File("f" + bigDecimal + ".sql");
        file.delete();
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            string = string + "\n";
            if (bl) {
                if (string.indexOf("set define") != 0) continue;
                bl = false;
                outputStreamWriter.write(string, 0, string.length());
                continue;
            }
            if (this.skipDate && string.indexOf("--   Date and Time:") == 0) continue;
            outputStreamWriter.write(string, 0, string.length());
        }
        outputStreamWriter.flush();
        if (this.debug) {
            System.out.println(" Wrote " + file.length() + " bytes to " + file.getAbsolutePath());
        }
        reader.close();
        outputStreamWriter.close();
        fileOutputStream.close();
        oracleCallableStatement.close();
    }

    private static void usage() {
        System.out.println("Usage APEXExport -db  -user  -password  -applicationid  -workspaceid -instance -skipExportDate -expSavedReports -debug  ");
        System.out.println("    -db:              Database connect url in JDBC format ");
        System.out.println("    -user:            Database username");
        System.out.println("    -password :       Database password");
        System.out.println("    -applicationid :  ID for application to be exported");
        System.out.println("    -workspaceid :    Workspace ID for which all applications to be exported");
        System.out.println("    -instance :       Export all applications");
        System.out.println("    -skipExportDate : Exclude export date from application export files");
        System.out.println("    -expSavedReports: Export all user saved interactive reports");
        System.out.println("    ");
        System.out.println("    Application Example: ");
        System.out.println("       APEXExport -db candy.us.oracle.com:1521:ORCL -user scott -password tiger -applicationid 31500 ");
        System.out.println("    Workspace  Example: ");
        System.out.println("       APEXExport -db candy.us.oracle.com:1521:ORCL -user scott -password tiger -workspaceid 9999 ");
        System.out.println("    Instance Example:");
        System.out.println("       APEXExport -db candy.us.oracle.com:1521:ORCL -user flows_020200 -password apex -instance ");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        BigDecimal bigDecimal = null;
        BigDecimal bigDecimal2 = null;
        APEXExport aPEXExport = new APEXExport();
        for (int i = 0; i < stringArray.length; ++i) {
            if (aPEXExport.debug) {
                System.out.println("Parameter:" + stringArray[i]);
            }
            if (stringArray[i].equalsIgnoreCase("-db")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-user")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-password")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-workspaceid")) {
                bigDecimal2 = new BigDecimal(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-applicationid")) {
                bigDecimal = new BigDecimal(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-debug")) {
                aPEXExport.debug = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-skipExportDate")) {
                aPEXExport.skipDate = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-expSavedReports")) {
                aPEXExport.savedReports = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-instance")) {
                aPEXExport.instance = true;
                continue;
            }
            APEXExport.usage();
        }
        if (aPEXExport.debug) {
            System.out.println(string);
            System.out.println(string2);
            System.out.println(string3);
            System.out.println(bigDecimal2);
            System.out.println(bigDecimal);
            System.out.println(aPEXExport.skipDate);
            System.out.println(aPEXExport.savedReports);
            System.out.println(aPEXExport.instance);
        }
        if (string == null || string2 == null || string3 == null || bigDecimal != null && bigDecimal.longValue() == 0L && bigDecimal2 != null && bigDecimal2.longValue() == 0L) {
            APEXExport.usage();
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        aPEXExport.gConn = DriverManager.getConnection("jdbc:oracle:thin:@" + string, string2, string3);
        aPEXExport.gConn.setAutoCommit(true);
        aPEXExport.ExportFiles(bigDecimal, bigDecimal2, string2);
        aPEXExport.gConn.close();
    }
}

