/*
 * Decompiled with CFR 0.152.
 */
package oracle.apex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class APEXExportSplitter {
    private static boolean flatten = false;
    private static boolean checksum = true;
    private static boolean debug = false;
    private static boolean update = false;
    private static String baseFolder;
    private static FileOutputStream updateFile;

    private static void printUpdate(String string) throws Exception {
        if (update) {
            if (updateFile == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Calendar.getInstance().get(2));
                stringBuffer.append("-");
                stringBuffer.append(Calendar.getInstance().get(5));
                stringBuffer.append("-");
                stringBuffer.append(Calendar.getInstance().get(1));
                stringBuffer.append("-");
                stringBuffer.append(Calendar.getInstance().get(11));
                stringBuffer.append("-");
                stringBuffer.append(Calendar.getInstance().get(12));
                stringBuffer.append("-");
                stringBuffer.append(Calendar.getInstance().get(13));
                String string2 = baseFolder + File.separator + "update-" + stringBuffer.toString() + ".sql";
                if (flatten) {
                    string2 = string2.replaceAll("/", "_");
                }
                updateFile = new FileOutputStream(new File(string2));
                updateFile.write("@init.sql \r\n".getBytes());
                updateFile.write("@env.sql \r\n".getBytes());
            }
            updateFile.write(("@" + string + " \r\n").getBytes());
        }
    }

    private static void log(String string) {
        if (debug) {
            System.out.print(string);
        }
    }

    private static void copy(File file, File file2) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private static void checkFileForChanges(File file, String string) throws Exception {
        File file2 = new File(string);
        boolean bl = true;
        if (file2.exists() && checksum && APEXExportSplitter.getCheckSum((File)file) == APEXExportSplitter.getCheckSum((File)file2)) {
            bl = false;
        }
        if (bl || !checksum) {
            APEXExportSplitter.log((String)("---Renaming... to " + string + "\n"));
            APEXExportSplitter.copy((File)file, (File)file2);
            APEXExportSplitter.printUpdate((String)string);
        }
        file.delete();
    }

    private static long getCheckSum(File file) {
        long l = 0L;
        try {
            CheckedInputStream checkedInputStream = new CheckedInputStream(new FileInputStream(file), new Adler32());
            byte[] byArray = new byte[128];
            while (checkedInputStream.read(byArray) >= 0) {
            }
            l = checkedInputStream.getChecksum().getValue();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    public static void processFile(String string) throws Exception {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        File file = null;
        baseFolder = string.substring(0, string.indexOf("."));
        String string3 = "application/init.sql";
        if (flatten) {
            string3 = string3.replaceAll("/", "_");
        }
        StringBuffer stringBuffer = new StringBuffer("@" + string3 + "\n");
        string3 = baseFolder + "/" + string3;
        String string4 = null;
        OutputStreamWriter outputStreamWriter = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.indexOf("--application") == 0) {
                if (outputStreamWriter != null) {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    APEXExportSplitter.checkFileForChanges(file, string4);
                }
                string4 = string2.substring(string2.indexOf("--") + 2).trim().replaceAll("\\.", "").replaceAll(" ", "_");
                string4 = string4 + ".sql";
                if (flatten) {
                    string4 = string4.replaceAll("/", "_");
                }
                string4 = baseFolder + "/" + string4;
                object = new File(string4.substring(0, string4.lastIndexOf("/")));
                ((File)object).mkdirs();
                stringBuffer.append("@" + string4.substring(string4.indexOf("/") + 1) + "\n");
                file = File.createTempFile("apex", ".sql");
                APEXExportSplitter.log((String)("--Processing:" + string4 + "\n"));
                outputStreamWriter = new FileWriter(file);
            }
            if (outputStreamWriter != null) {
                outputStreamWriter.write(string2 + "\n");
                continue;
            }
            stringBuffer2.append(string2 + "\n");
        }
        outputStreamWriter.flush();
        outputStreamWriter.close();
        APEXExportSplitter.checkFileForChanges(file, string4);
        object = new FileWriter(string3);
        ((Writer)object).write(stringBuffer2.toString());
        ((OutputStreamWriter)object).flush();
        ((OutputStreamWriter)object).close();
        String string5 = "install.sql";
        if (flatten) {
            string5 = string5.replaceAll("/", "_");
        }
        object = new FileWriter(baseFolder + "/" + string5);
        ((Writer)object).write(stringBuffer.toString());
        ((OutputStreamWriter)object).flush();
        ((OutputStreamWriter)object).close();
        if (updateFile != null) {
            updateFile.close();
        }
    }

    public static void usage() {
        System.out.println("-help       : < print this syntax >");
        System.out.println("-flat       : < flat file structure >");
        System.out.println("-debug      : < print debug info >");
        System.out.println("-update     : < create update file >");
        System.out.println("-nochecksum : < don't check for changes >");
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        int n;
        if (stringArray.length == 0) {
            APEXExportSplitter.usage();
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string.equals("-flat")) {
                flatten = true;
                System.out.println("Using flat structure");
                continue;
            }
            if (string.equals("-nochecksum")) {
                checksum = false;
                continue;
            }
            if (string.equals("-debug")) {
                debug = true;
                continue;
            }
            if (string.equals("-update")) {
                update = true;
                continue;
            }
            if (!string.equals("-help")) continue;
            APEXExportSplitter.usage();
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string.indexOf("-") != -1) continue;
            try {
                System.out.println("Processing:" + string);
                APEXExportSplitter.processFile((String)string);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Could not process:" + string);
                System.err.println(exception.getMessage());
            }
        }
    }
}

