/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.ComponentEvtDispatchThread;
import com.sun.java.accessibility.util.EventQueueMonitorItem;
import com.sun.java.accessibility.util.GUIInitializedListener;
import com.sun.java.accessibility.util.GUIInitializedMulticaster;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import com.sun.java.accessibility.util.TopLevelWindowMulticaster;
import com.sun.java.accessibility.util.Translator;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;

public class EventQueueMonitor
implements AWTEventListener {
    static Vector topLevelWindows = new Vector();
    static Window topLevelWindowWithFocus = null;
    static Point currentMousePosition = null;
    static Component currentMouseComponent = null;
    static GUIInitializedListener guiInitializedListener = null;
    static TopLevelWindowListener topLevelWindowListener = null;
    static MouseMotionListener mouseMotionListener = null;
    static boolean guiInitialized = false;
    static EventQueueMonitorItem componentEventQueue = null;
    private static ComponentEvtDispatchThread cedt = null;
    static Object componentEventQueueLock = new Object();

    public EventQueueMonitor() {
        if (cedt == null) {
            cedt = new ComponentEvtDispatchThread("EventQueueMonitor-ComponentEvtDispatch");
            cedt.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void queueComponentEvent(ComponentEvent e) {
        Object object = componentEventQueueLock;
        synchronized (object) {
            EventQueueMonitorItem eqi = new EventQueueMonitorItem(e);
            if (componentEventQueue == null) {
                componentEventQueue = eqi;
            } else {
                EventQueueMonitorItem q = componentEventQueue;
                while (q.next != null) {
                    q = q.next;
                }
                q.next = eqi;
            }
            componentEventQueueLock.notifyAll();
        }
    }

    public static void maybeInitialize() {
        if (cedt == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        long eventMask = 100L;
                        Toolkit.getDefaultToolkit().addAWTEventListener(new EventQueueMonitor(), eventMask);
                    }
                    catch (Exception e) {}
                    return null;
                }
            });
        }
    }

    public void eventDispatched(AWTEvent theEvent) {
        EventQueueMonitor.processEvent(theEvent);
    }

    static void maybeNotifyAssistiveTechnologies() {
        if (!guiInitialized) {
            guiInitialized = true;
            if (guiInitializedListener != null) {
                guiInitializedListener.guiInitialized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean addTopLevelWindow(Component c) {
        Container parent;
        if (c == null) {
            return false;
        }
        if (!(c instanceof Window)) {
            return EventQueueMonitor.addTopLevelWindow(c.getParent());
        }
        if (c instanceof Dialog || c instanceof Window) {
            parent = (Container)c;
        } else {
            parent = c.getParent();
            if (parent != null) {
                return EventQueueMonitor.addTopLevelWindow(parent);
            }
        }
        if (parent == null) {
            parent = (Container)c;
        }
        Vector vector = topLevelWindows;
        synchronized (vector) {
            if (parent != null && !topLevelWindows.contains(parent)) {
                topLevelWindows.addElement(parent);
                if (topLevelWindowListener != null) {
                    topLevelWindowListener.topLevelWindowCreated((Window)parent);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTopLevelWindow(Window w) {
        Vector vector = topLevelWindows;
        synchronized (vector) {
            if (topLevelWindows.contains(w)) {
                topLevelWindows.removeElement(w);
                if (topLevelWindowListener != null) {
                    topLevelWindowListener.topLevelWindowDestroyed(w);
                }
            }
        }
    }

    static void updateCurrentMousePosition(MouseEvent mouseEvent) {
        Point oldMousePos = currentMousePosition;
        try {
            Point eventPoint = mouseEvent.getPoint();
            currentMouseComponent = (Component)mouseEvent.getSource();
            currentMousePosition = currentMouseComponent.getLocationOnScreen();
            currentMousePosition.translate(eventPoint.x, eventPoint.y);
        }
        catch (Exception e) {
            currentMousePosition = oldMousePos;
        }
    }

    static void processEvent(AWTEvent theEvent) {
        switch (theEvent.getID()) {
            case 206: 
            case 503: 
            case 506: 
            case 1004: {
                EventQueueMonitor.queueComponentEvent((ComponentEvent)theEvent);
                break;
            }
            case 205: {
                if (theEvent instanceof ComponentEvent) {
                    ComponentEvent ce = (ComponentEvent)theEvent;
                    if (ce.getComponent() instanceof Window) {
                        EventQueueMonitor.addTopLevelWindow(ce.getComponent());
                        EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                    } else {
                        EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                        EventQueueMonitor.addTopLevelWindow(ce.getComponent());
                    }
                }
                EventQueueMonitor.queueComponentEvent((ComponentEvent)theEvent);
                break;
            }
            case 200: {
                if (!(theEvent instanceof ComponentEvent)) break;
                ComponentEvent ce = (ComponentEvent)theEvent;
                if (ce.getComponent() instanceof Window) {
                    EventQueueMonitor.addTopLevelWindow(ce.getComponent());
                    EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                    break;
                }
                EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                EventQueueMonitor.addTopLevelWindow(ce.getComponent());
                break;
            }
            case 202: {
                if (!(theEvent instanceof ComponentEvent)) break;
                ComponentEvent ce = (ComponentEvent)theEvent;
                EventQueueMonitor.removeTopLevelWindow((Window)ce.getComponent());
                break;
            }
        }
    }

    static synchronized Component getShowingComponentAt(Container c, int x, int y) {
        if (!c.contains(x, y)) {
            return null;
        }
        int ncomponents = c.getComponentCount();
        int i = 0;
        while (i < ncomponents) {
            Component comp = c.getComponent(i);
            if (comp != null && comp.isShowing()) {
                Point location = comp.getLocation();
                if (comp.contains(x - location.x, y - location.y)) {
                    return comp;
                }
            }
            ++i;
        }
        return c;
    }

    static synchronized Component getComponentAt(Container c, Point p) {
        if (!c.isShowing()) {
            return null;
        }
        Point containerLoc = c.getLocationOnScreen();
        Point containerPoint = new Point(p.x - containerLoc.x, p.y - containerLoc.y);
        Component comp = EventQueueMonitor.getShowingComponentAt(c, containerPoint.x, containerPoint.y);
        if (comp != c && comp instanceof Container) {
            return EventQueueMonitor.getComponentAt((Container)comp, p);
        }
        return comp;
    }

    public static Accessible getAccessibleAt(Point p) {
        Window w = EventQueueMonitor.getTopLevelWindowWithFocus();
        Window[] wins = EventQueueMonitor.getTopLevelWindows();
        Component c = null;
        if (currentMousePosition == null) {
            return null;
        }
        if (currentMousePosition.equals(p) && currentMouseComponent instanceof Container) {
            c = EventQueueMonitor.getComponentAt((Container)currentMouseComponent, p);
        }
        if (c == null && w != null) {
            c = EventQueueMonitor.getComponentAt(w, p);
        }
        if (c == null) {
            int i = 0;
            while (i < wins.length) {
                c = EventQueueMonitor.getComponentAt(wins[i], p);
                if (c != null) break;
                ++i;
            }
        }
        if (c instanceof Accessible) {
            AccessibleComponent acmp;
            AccessibleContext ac = ((Accessible)((Object)c)).getAccessibleContext();
            if (ac != null && (acmp = ac.getAccessibleComponent()) != null && ac.getAccessibleChildrenCount() != 0) {
                Point location = acmp.getLocationOnScreen();
                location.move(p.x - location.x, p.y - location.y);
                return acmp.getAccessibleAt(location);
            }
            return (Accessible)((Object)c);
        }
        return Translator.getAccessible(c);
    }

    public static boolean isGUIInitialized() {
        EventQueueMonitor.maybeInitialize();
        return guiInitialized;
    }

    public static void addGUIInitializedListener(GUIInitializedListener l) {
        EventQueueMonitor.maybeInitialize();
        guiInitializedListener = GUIInitializedMulticaster.add(guiInitializedListener, l);
    }

    public static void removeGUIInitializedListener(GUIInitializedListener l) {
        guiInitializedListener = GUIInitializedMulticaster.remove(guiInitializedListener, l);
    }

    public static void addTopLevelWindowListener(TopLevelWindowListener l) {
        topLevelWindowListener = TopLevelWindowMulticaster.add(topLevelWindowListener, l);
    }

    public static void removeTopLevelWindowListener(TopLevelWindowListener l) {
        topLevelWindowListener = TopLevelWindowMulticaster.remove(topLevelWindowListener, l);
    }

    public static Point getCurrentMousePosition() {
        return currentMousePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window[] getTopLevelWindows() {
        Vector vector = topLevelWindows;
        synchronized (vector) {
            int count = topLevelWindows.size();
            if (count > 0) {
                Window[] w = new Window[count];
                int i = 0;
                while (i < count) {
                    w[i] = (Window)topLevelWindows.elementAt(i);
                    ++i;
                }
                return w;
            }
            return new Window[0];
        }
    }

    public static Window getTopLevelWindowWithFocus() {
        return topLevelWindowWithFocus;
    }
}

