/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.i18n.net.GDKMessage;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.LocaleMapper;
import oracle.sql.converter.CharacterConverters;

public class MimeUtility {
    static final byte BYTE_ERROR = -1;
    private static final byte M_C_BYTE_NULL = 0;
    private static final byte M_C_BYTE_LF = 10;
    private static final byte M_C_BYTE_CR = 13;
    private static final byte M_C_BYTE_SP = 32;
    private static final byte M_C_BYTE_PLUS = 43;
    private static final byte M_C_BYTE_SLASH = 47;
    private static final byte M_C_BYTE_ZERO = 48;
    private static final byte M_C_BYTE_NINE = 57;
    private static final byte M_C_BYTE_EQUAL = 61;
    private static final byte M_C_BYTE_GT = 62;
    private static final byte M_C_BYTE_QUESTION = 63;
    private static final byte M_C_BYTE_ATMARK = 64;
    private static final byte M_C_BYTE_CAP_A = 65;
    private static final byte M_C_BYTE_CAP_F = 70;
    private static final byte M_C_BYTE_CAP_Z = 90;
    private static final byte M_C_BYTE_LOWLINE = 95;
    private static final byte M_C_BYTE_A = 97;
    private static final byte M_C_BYTE_F = 102;
    private static final byte M_C_BYTE_Z = 122;
    private static final byte M_C_BYTE_TILDE = 126;
    private static final byte M_C_BYTE_ESC = 27;
    private static final byte[] M_C_HEX2VAL_TBL = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int resw = "=??b??=".length();
    private static final int M_C_MAX_BASE64_WIDTH = 64;
    private static final int M_C_MAX_QP_WIDTH = 75;
    private static final byte[] M_C_BASE64_MAPPING = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte[] M_C_QP_MAPPING = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int AL16UTF16_CHARSET = 2000;
    private static final int AL16UTF16LE_CHARSET = 2002;
    private static final int UNICODE_1_CHARSET = 870;
    private static final int UNICODE_2_CHARSET = 871;
    private static final int AL32UTF8_CHARSET = 873;
    private static final int ISO_2022_JP_CHARSET = 9999;

    private MimeUtility() {
    }

    static byte hex2val(byte by) {
        return by > 0 ? M_C_HEX2VAL_TBL[by] : (byte)-1;
    }

    private static String getIANACharset(String string) throws UnsupportedEncodingException {
        String string2 = null;
        String string3 = null;
        string2 = LocaleMapper.getIANACharacterSet(1, string);
        if (string2 == null) {
            string3 = LocaleMapper.getOraCharacterSet(2, string);
            if (string3 == null) {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
            }
            string2 = string;
        } else {
            string3 = string;
        }
        return string2.toLowerCase(Locale.US);
    }

    public static String encodeHeader(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        int n = string5 == "B" ? 64 - resw - string4.length() : 75 - resw - string4.length();
        String string6 = MimeUtility.encodeBody(string, string4, string5, n);
        StringBuffer stringBuffer = new StringBuffer(string6.length() + resw + string4.length());
        String string7 = "=?" + string4 + "?" + string5 + "?";
        StringTokenizer stringTokenizer = new StringTokenizer(string6, "\r\n");
        int n2 = stringTokenizer.countTokens();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(string7);
            String string8 = stringTokenizer.nextToken();
            stringBuffer.append(string8);
            stringBuffer.append("?=");
            if (i >= n2 - 1) continue;
            stringBuffer.append("\r\n ");
        }
        return stringBuffer.toString();
    }

    static String encodeBody(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        int n = string5 == "B" ? 64 : 75;
        return MimeUtility.encodeBody(string, string4, string5, n);
    }

    private static String encodeBody(String string, String string2, String string3, int n) throws UnsupportedEncodingException {
        String string4 = null;
        string4 = string3 == "B" ? MimeUtility.encodeBodyBase64(string, string2, n) : MimeUtility.encodeBodyQP(string, string2, n);
        return string4;
    }

    private static byte base64_byte1(byte by) {
        return (byte)(by >>> 2 & 0x3F);
    }

    private static byte base64_byte2(byte by, byte by2) {
        return (byte)((by << 4 | by2 >>> 4 & 0xF) & 0x3F);
    }

    private static byte base64_byte3(byte by, byte by2) {
        return (byte)((by << 2 | by2 >>> 6 & 3) & 0x3F);
    }

    private static byte base64_byte4(byte by) {
        return (byte)(by & 0x3F);
    }

    private static String encodeBodyBase64(String string, String string2, int n) throws UnsupportedEncodingException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 / 2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        int n5 = 0;
        while (n2 < n3) {
            String string3;
            int n6;
            n5 = n3 - n2;
            n4 = n5 < n4 ? n5 : n4;
            byte[] byArray = null;
            while ((n6 = (byArray = MimeUtility.getBytes(string3 = string.substring(n2, n2 + n4), string2)).length * 4 / 3) >= n) {
                n4 /= 2;
            }
            n2 += n4;
            int n7 = 0;
            while (n7 + 2 < byArray.length) {
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], byArray[n7 + 1])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte3(byArray[n7 + 1], byArray[n7 + 2])]);
                byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte4(byArray[n7 + 2])]);
                n7 += 3;
            }
            switch (byArray.length - n7) {
                case 0: {
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], (byte)0)]);
                    byteArrayOutputStream.write(61);
                    byteArrayOutputStream.write(61);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte1(byArray[n7])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte2(byArray[n7], byArray[n7 + 1])]);
                    byteArrayOutputStream.write(M_C_BASE64_MAPPING[MimeUtility.base64_byte3(byArray[n7 + 1], (byte)0)]);
                    byteArrayOutputStream.write(61);
                }
            }
            byteArrayOutputStream.write(13);
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toString("ISO-8859-1");
    }

    private static String encodeBodyQP(String string, String string2, int n) throws UnsupportedEncodingException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 / 2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = 0;
        while (n2 < n3) {
            String string3;
            int n6;
            n5 = n3 - n2;
            n4 = n5 < n4 ? n5 : n4;
            byte[] byArray = null;
            while ((n6 = (byArray = MimeUtility.getBytes(string3 = string.substring(n2, n2 + n4), string2)).length * 3) >= n) {
                n4 /= 2;
            }
            n2 += n4;
            int n7 = 0;
            while (n7 < byArray.length) {
                if ((n6 = byArray[n7++] & 0xFF) == 13 && n7 < byArray.length && byArray[n7] == 10) {
                    byteArrayOutputStream.write(13);
                    byteArrayOutputStream.write(byArray[n7++]);
                    continue;
                }
                if (n6 == 63 || n6 == 95 || n6 == 61 || n6 <= 32 || n6 > 126) {
                    byteArrayOutputStream.write(61);
                    byteArrayOutputStream.write(M_C_QP_MAPPING[n6 >>> 4]);
                    byteArrayOutputStream.write(M_C_QP_MAPPING[n6 & 0xF]);
                    continue;
                }
                byteArrayOutputStream.write(n6);
            }
            byteArrayOutputStream.write(13);
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toString("ISO-8859-1");
    }

    public static String decodeHeader(String string) throws UnsupportedEncodingException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n \t");
        String string2 = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (!((String)object).startsWith("=?")) {
                    return string;
                }
                int n = ((String)object).indexOf(63, 2);
                string2 = ((String)object).substring(2, n);
                String string3 = ((String)object).substring(n + 1, n + 2);
                String string4 = ((String)object).substring(n + 3, ((String)object).indexOf(63, n + 3));
                byteArrayOutputStream.write(MimeUtility.decodeBodyArray(string4, string3));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 != null) {
            object = byteArrayOutputStream.toByteArray();
            return MimeUtility.toString((byte[])object, 0, ((Object)object).length, string2);
        }
        return "";
    }

    static String decodeBody(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = MimeUtility.getIANACharset(string2);
        String string5 = string3.equalsIgnoreCase("B") ? "B" : "Q";
        StringBuffer stringBuffer = new StringBuffer("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        if (string5 == "B") {
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(MimeUtility.decodeBodyBase64(stringTokenizer.nextToken(), string4));
            }
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(MimeUtility.decodeBodyQP(stringTokenizer.nextToken(), string4));
            }
        }
        return stringBuffer.toString();
    }

    private static byte[] decodeBodyArray(String string, String string2) throws UnsupportedEncodingException {
        String string3;
        String string4 = string3 = string2.equalsIgnoreCase("B") ? "B" : "Q";
        if (string3 == "B") {
            return MimeUtility.decodeBodyArrayBase64(string);
        }
        return MimeUtility.decodeBodyArrayQP(string);
    }

    private static String decodeBodyQP(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = MimeUtility.decodeBodyArrayQP(string);
        return MimeUtility.toString(byArray, 0, byArray.length, string2);
    }

    private static byte[] decodeBodyArrayQP(String string) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes("iso-8859-1");
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block9: while (n4 < n) {
            byte by = byArray[n4++];
            switch (by) {
                case 61: {
                    byte by2;
                    if (n4 >= n) continue block9;
                    by = byArray[n4++];
                    switch (by) {
                        case 0: {
                            --n4;
                            continue block9;
                        }
                        case 10: 
                        case 13: {
                            byte by3;
                            n2 = n3;
                            if (n4 >= n || (by3 = byArray[n4]) != 13 && by3 != 10) continue block9;
                            ++n4;
                            continue block9;
                        }
                    }
                    if (n4 >= n || (by = MimeUtility.hex2val(by)) == -1 || (by2 = MimeUtility.hex2val(byArray[n4++])) == -1) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5204));
                    }
                    byArray2[n3++] = (byte)(by2 + (by << 4));
                    n2 = n3;
                    continue block9;
                }
                case 32: {
                    byArray2[n3++] = by;
                    continue block9;
                }
                case 13: {
                    n3 = n2;
                    byArray2[n3++] = by;
                    n2 = n3;
                    continue block9;
                }
            }
            byArray2[n3++] = by;
            n2 = n3;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    private static String decodeBodyBase64(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = MimeUtility.decodeBodyArrayBase64(string);
        return MimeUtility.toString(byArray, 0, byArray.length, string2);
    }

    private static byte[] decodeBodyArrayBase64(String string) throws UnsupportedEncodingException {
        int n;
        byte[] byArray = string.getBytes("iso-8859-1");
        int n2 = n = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            byte by = 0;
            if (byArray[n4] == 61) break;
            if (byArray[n4] >= 65 && byArray[n4] <= 90) {
                by = (byte)(byArray[n4] - 65);
            } else if (byArray[n4] >= 97 && byArray[n4] <= 122) {
                by = (byte)(byArray[n4] - 97 + 26);
            } else if (byArray[n4] >= 48 && byArray[n4] <= 57) {
                by = (byte)(byArray[n4] - 48 + 52);
            } else if (byArray[n4] == 43) {
                by = (byte)62;
            } else if (byArray[n4] == 47) {
                by = (byte)63;
            } else {
                by = (byte)64;
                if (byArray[n4] == 10 || byArray[n4] == 13) {
                    --n5;
                }
            }
            if (by < 64) {
                switch (n5 & 3) {
                    case 0: {
                        byArray2[n3] = (byte)(by << 2);
                        break;
                    }
                    case 1: {
                        int n6 = n3++;
                        byArray2[n6] = (byte)(byArray2[n6] | (byte)(by >>> 4));
                        byArray2[n3] = (byte)((by & 0xF) << 4);
                        break;
                    }
                    case 2: {
                        int n7 = n3++;
                        byArray2[n7] = (byte)(byArray2[n7] | (byte)((by & 0x3C) >>> 2));
                        byArray2[n3] = (byte)((by & 3) << 6);
                        break;
                    }
                    default: {
                        int n8 = n3++;
                        byArray2[n8] = (byte)(byArray2[n8] | by);
                    }
                }
            }
            ++n4;
            ++n5;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    static byte[] getBytes(String string, String string2) throws UnsupportedEncodingException {
        String string3 = MimeUtility.getOraCharacterSet(string2);
        String string4 = OraBoot.getInstance().getCharSetId(string3);
        if (string4 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
        }
        int n = Integer.parseInt(string4);
        switch (n) {
            case 870: 
            case 871: {
                return string.getBytes("UTF-8");
            }
            case 873: {
                return string.getBytes("UTF-8");
            }
            case 9999: {
                return string.getBytes("X-ORACLE-ISO2022-JP");
            }
            case 2000: 
            case 2002: {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
            }
        }
        CharacterConverters characterConverters = CharacterConverterOGS.getInstance(n);
        if (characterConverters == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string2));
        }
        return characterConverters.toOracleStringWithReplacement(string);
    }

    static String toString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        String string2 = MimeUtility.getOraCharacterSet(string);
        String string3 = OraBoot.getInstance().getCharSetId(string2);
        if (string3 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
        }
        int n3 = Integer.parseInt(string3);
        switch (n3) {
            case 870: 
            case 871: {
                return new String(byArray, n, n2, "UTF-8");
            }
            case 873: {
                return new String(byArray, n, n2, "UTF-8");
            }
            case 9999: {
                return new String(byArray, n, n2, "X-ORACLE-ISO2022-JP");
            }
            case 2000: 
            case 2002: {
                throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
            }
        }
        CharacterConverters characterConverters = CharacterConverterOGS.getInstance(n3);
        if (characterConverters == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5220, (Object)string));
        }
        return characterConverters.toUnicodeStringWithReplacement(byArray, n, n2);
    }

    static String getOraCharacterSet(String string) {
        String string2 = LocaleMapper.getOraCharacterSet(2, string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }
}

