/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraLinguistic;
import oracle.i18n.text.OraNormalizer;

class OraCollationElementIterator {
    public static final int NULLORDER = -1;
    private static final int KEYBUFFERSIZE = 2048;
    private static OraNormalizer on = null;
    private OraCollator owner;
    private char[] source;
    private int[] keysBuffer = new int[2048];
    private int ucPos;
    private int ckPos;
    private int getPos;
    private int keysLeft;
    private char[] compBuffer = new char[24];
    private int[] prevKeys = new int[24];
    private int prevKeyCount;
    private int currentKeyCount;
    private int compPos;
    private int prevCompPos;
    private int compCnt;
    private int slen;

    OraCollationElementIterator(String string, OraCollator oraCollator) {
        this.source = string.toCharArray();
        this.owner = oraCollator;
        this.ucPos = 0;
        this.ckPos = 0;
        this.getPos = -1;
        this.compCnt = 0;
        this.keysLeft = 0;
        this.compPos = 0;
        this.currentKeyCount = 0;
        this.prevKeyCount = 0;
        this.slen = this.source.length;
    }

    public int next(int[] nArray, boolean bl) {
        if (this.keysLeft > 0) {
            --this.keysLeft;
            return this.keysBuffer[++this.getPos];
        }
        if (this.GenerateOraCollationKey(nArray, bl) > -1) {
            if (nArray[0] > 0) {
                return 0;
            }
            if (this.keysLeft > 0) {
                --this.keysLeft;
                if (this.getPos == 2047) {
                    this.getPos = -1;
                }
                return this.keysBuffer[++this.getPos];
            }
            return 0;
        }
        return -1;
    }

    public void moveback(int n) {
        this.keysLeft = this.isSpacingKey(n) ? this.currentKeyCount + this.prevKeyCount : this.currentKeyCount;
        this.getPos = this.ckPos - this.keysLeft - 1;
        if (this.getPos < -1) {
            this.getPos += 2048;
        }
    }

    public static final int primaryOrder(int n) {
        return n >>> 16;
    }

    public static final short secondaryOrder(int n) {
        return (short)((n &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n &= 0xFF);
    }

    public int getMaxExpansion(int n) {
        OraLinguistic oraLinguistic = this.owner.getTables();
        return oraLinguistic.getMaxExpansion(n);
    }

    public void setText(String string) {
        this.source = string.toCharArray();
        this.ucPos = 0;
        this.ckPos = 0;
        this.getPos = -1;
        this.compCnt = 0;
        this.keysLeft = 0;
        this.compPos = 0;
        this.currentKeyCount = 0;
        this.prevKeyCount = 0;
        this.slen = this.source.length;
    }

    private int GenerateOraCollationKey(int[] nArray, boolean bl) {
        if (this.slen == this.ucPos) {
            return -1;
        }
        OraLinguistic oraLinguistic = this.owner.getTables();
        char c = this.source[this.ucPos];
        int n = oraLinguistic.getCollationItem(c);
        if (oraLinguistic.isSwapWithNext() && oraLinguistic.isSwapping(c)) {
            ++this.ucPos;
            if (this.slen == this.ucPos) {
                this.writeKey(n);
                return 1;
            }
            char c2 = this.source[this.ucPos++];
            int n2 = oraLinguistic.getCollationItem(c2);
            if (c2 >= '\u0e00' && c2 <= '\u0eff') {
                this.source[this.ucPos - 2] = c2;
                this.source[this.ucPos - 1] = c;
                if (!oraLinguistic.isIgnorable(n2)) {
                    this.compPos = this.ucPos - 2;
                    this.compCnt = 0;
                    this.prevKeyCount = this.currentKeyCount;
                    this.currentKeyCount = 0;
                }
                ++this.compCnt;
                this.writeKey(n2);
                if (!oraLinguistic.isIgnorable(n)) {
                    this.compPos = this.ucPos - 1;
                    this.compCnt = 0;
                    this.prevKeyCount = this.currentKeyCount;
                    this.currentKeyCount = 0;
                }
                ++this.compCnt;
                this.writeKey(n);
            } else {
                if (!oraLinguistic.isIgnorable(n)) {
                    this.compPos = this.ucPos - 2;
                    this.compPos = 0;
                    this.prevKeyCount = this.currentKeyCount;
                    this.currentKeyCount = 0;
                }
                ++this.compCnt;
                this.writeKey(n);
                if (!oraLinguistic.isIgnorable(n2)) {
                    this.compPos = this.ucPos - 1;
                    this.compCnt = 0;
                    this.prevKeyCount = this.currentKeyCount;
                    this.currentKeyCount = 0;
                }
                ++this.compCnt;
                this.writeKey(n2);
            }
            return 2;
        }
        if (oraLinguistic.isIgnorable(n)) {
            ++this.ucPos;
            if (this.owner.getComposition() == 1 && (!bl || oraLinguistic.isReverseSort())) {
                ++this.compCnt;
                for (int i = this.ucPos; i < this.slen; ++i) {
                    if (!oraLinguistic.isIgnorable(oraLinguistic.getCollationItem(this.source[i]))) continue;
                    ++this.compCnt;
                }
                if (on == null) {
                    on = OraNormalizer.getInstance();
                }
                if (this.compCnt == 1) {
                    this.writeKey(n);
                    return 1;
                }
                String string = new String(this.source, this.compPos, this.compCnt);
                String string2 = on.compose(string);
                if (string2.equals(string)) {
                    this.writeKey(n);
                    return 1;
                }
                char[] cArray = string2.toCharArray();
                int n3 = 0;
                int n4 = 0;
                for (n3 = 0; n3 < cArray.length; ++n3) {
                    this.source[this.compPos + n3] = cArray[n3];
                }
                for (n4 = 0; n4 < this.slen - this.compPos - this.compCnt; ++n4) {
                    this.source[this.compPos + n3 + n4] = this.source[this.compPos + this.compCnt + n4];
                }
                this.slen = this.compPos + n3 + n4;
                this.ckPos -= this.currentKeyCount;
                if (this.ckPos < 0) {
                    this.ckPos += 2048;
                }
                this.getPos = this.ckPos - 1;
                this.ucPos = this.compPos;
                this.compCnt = 1;
                nArray[2] = 0;
                nArray[1] = 0;
                nArray[0] = 0;
                for (n3 = 0; n3 < this.currentKeyCount; ++n3) {
                    n = this.keysBuffer[this.ckPos + n3 >= 2048 ? this.ckPos + n3 - 2048 : this.ckPos + n3];
                    if ((n & 0xFFFF0000) != 0) {
                        nArray[0] = nArray[0] + 1;
                    }
                    if ((n & 0xFF00) != 0) {
                        nArray[1] = nArray[1] + 1;
                    }
                    if ((n & 0xFF) == 0 && n != 65536) continue;
                    nArray[2] = nArray[2] + 1;
                }
                this.currentKeyCount = this.prevKeyCount;
                return nArray[0];
            }
            this.writeKey(n);
            return 1;
        }
        if (oraLinguistic.isSimple(n) || oraLinguistic.isPuncuation(n)) {
            ++this.ucPos;
            if (this.isSpacingKey(n)) {
                this.prevKeyCount = this.currentKeyCount;
                this.currentKeyCount = 0;
            }
            this.writeKey(n);
            if (!oraLinguistic.isIgnorable(n)) {
                this.compPos = this.ucPos - 1;
                this.compCnt = 0;
            }
            ++this.compCnt;
            return 1;
        }
        if (oraLinguistic.isZero(n)) {
            ++this.ucPos;
            if (oraLinguistic.isMono()) {
                this.writeKey(c >>> 8);
                this.writeKey(c & 0xFF);
                this.compCnt = 0;
                return 2;
            }
            if (c == '\u0000') {
                this.prevKeyCount = this.currentKeyCount;
                this.currentKeyCount = 0;
                this.writeKey(1);
                this.compPos = this.ucPos - 1;
                this.compCnt = 1;
                return 1;
            }
            if ((c & 0x1100) != 0 && oraLinguistic.isHangulJamo()) {
                int n5 = this.slen > this.ucPos + 2 ? 3 : this.slen - this.ucPos + 1;
                String string = new String(this.source, this.ucPos - 1, n5);
                String string3 = OraNormalizer.composeHangul(string);
                if (string3.equals(string)) {
                    this.prevKeyCount = this.currentKeyCount;
                    this.currentKeyCount = 0;
                    this.writeKey(-65536);
                    this.writeKey(c << 16);
                    this.compPos = this.ucPos - 1;
                    this.compCnt = 1;
                    return 2;
                }
                --this.ucPos;
                char[] cArray = string3.toCharArray();
                int n6 = 0;
                int n7 = 0;
                for (n6 = 0; n6 < cArray.length; ++n6) {
                    this.source[this.ucPos + n6] = cArray[n6];
                }
                for (n7 = 0; n7 < this.slen - this.ucPos - n5; ++n7) {
                    this.source[this.ucPos + n6 + n7] = this.source[this.ucPos + n5 + n7];
                }
                this.slen = this.ucPos + n6 + n7;
                return 0;
            }
            this.prevKeyCount = this.currentKeyCount;
            this.currentKeyCount = 0;
            this.writeKey(-65536);
            this.writeKey(c << 16);
            this.compPos = this.ucPos - 1;
            this.compCnt = 1;
            return 2;
        }
        if (oraLinguistic.isExpanding(n)) {
            int n8 = oraLinguistic.getIndex(n);
            int[] nArray2 = oraLinguistic.getExpandExpCharKey(n8);
            int n9 = nArray2.length;
            if (!oraLinguistic.isIgnorable(nArray2[0])) {
                this.compPos = this.ucPos;
                this.compCnt = 0;
            }
            if (this.isSpacingKey(nArray2[0])) {
                this.prevKeyCount = this.currentKeyCount;
                this.currentKeyCount = 0;
            }
            for (int i = 0; i < n9; ++i) {
                this.writeKey(nArray2[i]);
            }
            ++this.compCnt;
            ++this.ucPos;
            return n9;
        }
        if (oraLinguistic.isContracting(n)) {
            this.compPos = this.ucPos;
            this.compCnt = 1;
            int n10 = this.getContractingKey(oraLinguistic, n);
            this.ucPos += n10;
            if (n10 != 1) {
                this.compCnt = 0;
            }
            return 1;
        }
        if (oraLinguistic.isSurrogate(n)) {
            int n11 = this.getSurrogateKey(oraLinguistic, n);
            return n11;
        }
        if (oraLinguistic.isExtendedPrimary(n)) {
            this.prevKeyCount = this.currentKeyCount;
            this.currentKeyCount = 0;
            this.writeKey((n & 0xFFFF0000) + 256 + 1);
            this.writeKey((n << 16) + 256 + 1);
            this.compPos = this.ucPos++;
            this.compCnt = 1;
            return 2;
        }
        if (oraLinguistic.isContextSensitive(n)) {
            n = this.getContextSensitiveKey(oraLinguistic, n);
            ++this.ucPos;
            if (!oraLinguistic.isIgnorable(n)) {
                this.compPos = this.ucPos - 1;
                this.compCnt = 1;
            } else {
                ++this.compCnt;
            }
            return 1;
        }
        return 0;
    }

    private int getContextSensitiveKey(OraLinguistic oraLinguistic, int n) {
        char c;
        int n2 = oraLinguistic.getIndex(n);
        char c2 = this.source[this.ucPos];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        int n8 = 0;
        char c3 = this.ucPos - 1 < 0 ? (char)'\u0000' : this.source[this.ucPos - 1];
        n3 = n2 + oraLinguistic.getContextNumOfFE(n2);
        n4 = n2;
        char c4 = oraLinguistic.getContextPrevCpt(n3);
        char c5 = oraLinguistic.getContextPrevCpt(n4);
        if (c5 == '\u0000') {
            c5 = oraLinguistic.getContextPrevCpt(n4 + 1);
        }
        if ((double)(n3 - n4) * 0.7 < (double)(c4 - c5) && (double)(n3 - n4) * 1.25 > (double)(c4 - c5) && c3 <= c4 && c3 >= c5) {
            n7 = c3 == c5 ? n2 + 1 : (c3 - c5) * (n3 - n4) / (c4 - c5) + n2;
            while (n5 < 4) {
                c = oraLinguistic.getContextPrevCpt(n7);
                if (c3 == c) {
                    n8 = oraLinguistic.getContextCollKey(n7);
                    if (this.isSpacingKey(n8)) {
                        this.prevKeyCount = this.currentKeyCount;
                        this.currentKeyCount = 0;
                    }
                    this.writeKey(n8);
                    return n8;
                }
                if (c3 < c) {
                    ++n5;
                    n6 = c - c3;
                    if (n6 != 0) {
                        n7 -= n6;
                    }
                    n3 = --n7;
                    continue;
                }
                ++n5;
                n6 = c3 - c;
                if (n6 != 0) {
                    n7 += n6;
                }
                n4 = ++n7;
            }
        } else {
            n7 = (n3 + n4) / 2;
        }
        if (c3 <= c4 && c3 >= c5) {
            while (n3 >= n4) {
                c = oraLinguistic.getContextPrevCpt(n7);
                if (c3 == c) {
                    n8 = oraLinguistic.getContextCollKey(n7);
                    if (this.isSpacingKey(n8)) {
                        this.prevKeyCount = this.currentKeyCount;
                        this.currentKeyCount = 0;
                    }
                    this.writeKey(n8);
                    return n8;
                }
                if (c3 > c) {
                    n4 = n7 + 1;
                } else {
                    n3 = n7 - 1;
                }
                n7 = (n3 + n4) / 2;
            }
        }
        if (this.isSpacingKey(n8 = oraLinguistic.getContextPrevCpt(n2) == '\u0000' ? oraLinguistic.getContextCollKey(n2) : c2 << 16)) {
            this.prevKeyCount = this.currentKeyCount;
            this.currentKeyCount = 0;
        }
        this.writeKey(n8);
        return n8;
    }

    private int getContractingKey(OraLinguistic oraLinguistic, int n) {
        int n2 = oraLinguistic.getIndex(n);
        String string = new String(this.source, 0, this.slen);
        while (true) {
            String string2;
            if (string.startsWith(string2 = new String(oraLinguistic.getContractConChar(n2)), this.ucPos)) {
                int n3 = oraLinguistic.getContractCollKey(n2);
                if (this.isSpacingKey(n3)) {
                    this.prevKeyCount = this.currentKeyCount;
                    this.currentKeyCount = 0;
                }
                this.writeKey(oraLinguistic.getContractCollKey(n2));
                return string2.length();
            }
            if (oraLinguistic.getContractNumOfFE(n2) == 0) break;
            ++n2;
        }
        this.prevKeyCount = this.currentKeyCount;
        this.currentKeyCount = 0;
        this.writeKey(-65536);
        this.writeKey(this.source[this.ucPos] << 16);
        return 1;
    }

    private int getSurrogateKey(OraLinguistic oraLinguistic, int n) {
        int n2 = this.slen - this.ucPos - 1;
        char c = this.source[this.ucPos];
        int n3 = 0;
        if (n2 > 0) {
            n3 = this.source[this.ucPos + 1] & 0xFFFF;
        }
        if (n2 == 0 || n3 < 56064 || n3 > 57343) {
            this.prevKeyCount = this.currentKeyCount;
            this.currentKeyCount = 0;
            this.writeKey(-65536);
            this.writeKey(c << 16);
            this.compPos = this.ucPos++;
            this.compCnt = 1;
            return 2;
        }
        char c2 = this.source[this.ucPos + 1];
        int n4 = c - 55296 >> 6;
        int n5 = oraLinguistic.getIndex(n) + c2 - 56320;
        this.compPos = this.ucPos;
        this.compCnt = 2;
        this.ucPos += 2;
        int n6 = oraLinguistic.getSurrogateKey(n4, n5);
        if (oraLinguistic.isZero(n6)) {
            this.prevKeyCount = this.currentKeyCount;
            this.currentKeyCount = 0;
            this.writeKey(-65536);
            this.writeKey(c << 16);
            this.writeKey(-65536);
            this.writeKey(c2 << 16);
            return 4;
        }
        if (oraLinguistic.isExtendedPrimary(n6)) {
            this.prevKeyCount = this.currentKeyCount;
            this.currentKeyCount = 0;
            this.writeKey((n6 & 0xFFFF0000) + 256 + 1);
            this.writeKey((n6 << 16) + 256 + 1);
            return 2;
        }
        if (oraLinguistic.isExpanding(n6)) {
            int n7 = oraLinguistic.getIndex(n);
            int[] nArray = oraLinguistic.getExpandExpCharKey(n7);
            int n8 = nArray.length;
            if (this.isSpacingKey(nArray[0])) {
                this.prevKeyCount = this.currentKeyCount;
                this.currentKeyCount = 0;
            }
            for (int i = 0; i < n8; ++i) {
                this.writeKey(nArray[i]);
            }
            return n8;
        }
        if (this.isSpacingKey(n6)) {
            this.prevKeyCount = this.currentKeyCount;
            this.currentKeyCount = 0;
        }
        this.writeKey(n6);
        return 1;
    }

    private void writeKey(int n) {
        if (this.ckPos == 2048) {
            this.ckPos = 0;
        }
        this.keysBuffer[this.ckPos++] = n;
        ++this.keysLeft;
        ++this.currentKeyCount;
    }

    private boolean isSpacingKey(int n) {
        return (n & 0xFFFF0000) != 0;
    }
}

