/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.i18n.text.OraDateFormat;
import oracle.i18n.text.OraDateFormatPattern;
import oracle.i18n.text.OraDateFormatSymbols;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;

public class OraSimpleDateFormat
extends OraDateFormat {
    private static final int FIELD_NULL = Integer.MIN_VALUE;
    private static final int RR_CROSS = 50;
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private Locale locale;
    private OraDateFormatPattern oraDatePat;
    private OraDateFormatSymbols symbols;

    public OraSimpleDateFormat() {
        this(127, 127, OraLocaleInfo.getDefault());
    }

    public OraSimpleDateFormat(String string) throws ParseException {
        this(string, Locale.getDefault());
    }

    public OraSimpleDateFormat(String string, Locale locale) throws ParseException {
        this(string, OraLocaleInfo.getInstance(locale));
    }

    public OraSimpleDateFormat(String string, OraLocaleInfo oraLocaleInfo) throws ParseException {
        this.initialize(string, new OraDateFormatSymbols(oraLocaleInfo), oraLocaleInfo.getLocale());
    }

    public OraSimpleDateFormat(String string, OraDateFormatSymbols oraDateFormatSymbols) throws ParseException {
        this(string, oraDateFormatSymbols, Locale.getDefault());
    }

    public OraSimpleDateFormat(String string, OraDateFormatSymbols oraDateFormatSymbols, Locale locale) throws ParseException {
        this.initialize(string, oraDateFormatSymbols, locale);
    }

    public OraSimpleDateFormat(String string, OraDateFormatSymbols oraDateFormatSymbols, OraLocaleInfo oraLocaleInfo) throws ParseException {
        this.initialize(string, oraDateFormatSymbols, oraLocaleInfo.getLocale());
    }

    OraSimpleDateFormat(int n, int n2, OraLocaleInfo oraLocaleInfo) {
        try {
            this.initialize(OraSimpleDateFormat.getDefaultFormatPattern(n, n2, true, oraLocaleInfo.getOraTerritory()), new OraDateFormatSymbols(oraLocaleInfo), oraLocaleInfo.getLocale());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public void applyPattern(String string) throws ParseException {
        String string2 = null;
        if (string == null || string.equals("")) {
            throw new ParseException(GDKMessage.getMessage(5087), -1);
        }
        char c = string.charAt(0);
        int n = string.length();
        if (!(n != DEFAULT_DATE_OR_TIME_FORMAT_LENGTH && n != DEFAULT_DATE_AND_TIME_FORMAT_LENGTH || c != "DL".charAt(0) && c != "TS".charAt(0))) {
            string2 = this.toDefaultFormatPattern(string, n);
        }
        if (string2 == null) {
            string2 = string;
        }
        if (this.oraDatePat == null || !string2.equals(this.oraDatePat.pattern)) {
            ParsePosition parsePosition = new ParsePosition(0);
            this.oraDatePat = new OraDateFormatPattern(string2, parsePosition);
            if (parsePosition.getErrorIndex() >= 0) {
                int n2 = parsePosition.getIndex();
                parsePosition.setIndex(0);
                throw new ParseException(GDKMessage.getMessage(n2), parsePosition.getErrorIndex());
            }
        }
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTime(date);
        int n = this.format(calendar, stringBuffer, fieldPosition);
        if (n > 0) {
            throw new IllegalArgumentException(GDKMessage.getMessage(n));
        }
        return stringBuffer;
    }

    public OraDateFormatSymbols getOraDateFormatSymbols() {
        return (OraDateFormatSymbols)this.symbols.clone();
    }

    public void setOraDateFormatSymbols(OraDateFormatSymbols oraDateFormatSymbols) {
        this.symbols = oraDateFormatSymbols;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n = this.oraDatePat.checkConflictingFormatElements();
        if (n > 0) {
            throw new IllegalArgumentException(GDKMessage.getMessage(n));
        }
        int n2 = parsePosition.getIndex();
        Calendar calendar = (Calendar)this.calendar.clone();
        n = this.parse(string, parsePosition, calendar);
        if (n > 0) {
            parsePosition.setIndex(n2);
            throw new IllegalArgumentException(GDKMessage.getMessage(n));
        }
        parsePosition.setIndex(string.length());
        return calendar.getTime();
    }

    public String toPattern() {
        return this.oraDatePat.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object clone() {
        OraSimpleDateFormat oraSimpleDateFormat = (OraSimpleDateFormat)super.clone();
        oraSimpleDateFormat.locale = (Locale)this.locale.clone();
        oraSimpleDateFormat.oraDatePat = (OraDateFormatPattern)this.oraDatePat.clone();
        oraSimpleDateFormat.symbols = (OraDateFormatSymbols)this.symbols.clone();
        return oraSimpleDateFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraSimpleDateFormat) || !super.equals(object)) {
            return false;
        }
        OraSimpleDateFormat oraSimpleDateFormat = (OraSimpleDateFormat)object;
        return this.locale.equals(oraSimpleDateFormat.locale) && this.oraDatePat.equals(oraSimpleDateFormat.oraDatePat) && this.symbols.equals(oraSimpleDateFormat.symbols);
    }

    public int hashCode() {
        return this.oraDatePat.hashCode();
    }

    private void initialize(String string, OraDateFormatSymbols oraDateFormatSymbols, Locale locale) throws ParseException {
        this.locale = locale;
        this.symbols = oraDateFormatSymbols;
        this.applyPattern(string);
        this.calendar = locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0 ? new GregorianCalendar(locale) : Calendar.getInstance(locale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toDefaultFormatPattern(String string, int n) {
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        if (string.startsWith("DL")) {
            n2 = 1;
        } else if (string.startsWith("DS")) {
            n2 = 3;
        } else {
            if (!string.startsWith("TS")) return null;
            n3 = 3;
        }
        if (n != DEFAULT_DATE_AND_TIME_FORMAT_LENGTH) return OraSimpleDateFormat.getDefaultFormatPattern(n2, n3, bl, OraLocaleInfo.getInstance(this.locale).getOraTerritory());
        if (string.charAt(DEFAULT_DATE_OR_TIME_FORMAT_LENGTH) != ' ') {
            return null;
        }
        if (n2 != -1) {
            if (!string.regionMatches(true, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH + 1, "TS", 0, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH)) return null;
            n3 = 3;
            return OraSimpleDateFormat.getDefaultFormatPattern(n2, n3, bl, OraLocaleInfo.getInstance(this.locale).getOraTerritory());
        } else {
            if (string.regionMatches(true, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH + 1, "DL", 0, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH)) {
                n2 = 1;
            } else {
                if (!string.regionMatches(true, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH + 1, "DS", 0, DEFAULT_DATE_OR_TIME_FORMAT_LENGTH)) return null;
                n2 = 3;
            }
            bl = false;
        }
        return OraSimpleDateFormat.getDefaultFormatPattern(n2, n3, bl, OraLocaleInfo.getInstance(this.locale).getOraTerritory());
    }

    private int format(Calendar calendar, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string = null;
        boolean bl = false;
        Calendar calendar2 = null;
        TimeZone timeZone = this.calendar.getTimeZone();
        if (fieldPosition.getField() == 1000) {
            fieldPosition.setBeginIndex(stringBuffer.length());
        }
        int n = 0;
        int n2 = 0;
        block37: while (n2 < this.oraDatePat.iPatternLength) {
            char c;
            char c2 = this.oraDatePat.iPattern[n2++];
            char c3 = this.oraDatePat.iPattern[n2++];
            if (c2 > '>') {
                c = c2 - 63;
                if (fieldPosition.getField() == this.oraDatePat.getFormatField(62)) {
                    fieldPosition.setBeginIndex(stringBuffer.length());
                }
                stringBuffer.append(this.oraDatePat.iPattern, n2, (int)c);
                n2 += c;
                if (fieldPosition.getField() != this.oraDatePat.getFormatField(62)) continue;
                fieldPosition.setEndIndex(stringBuffer.length());
                continue;
            }
            int[] nArray = OraDateFormatPattern.FORMAT_ATTR[c2];
            int n3 = nArray[3];
            int n4 = -1;
            if (fieldPosition.getField() == this.oraDatePat.getFormatField(c2)) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            switch (c2) {
                case '\u0001': 
                case '\u0002': {
                    n4 = calendar.get(1) / 100 + 1;
                    break;
                }
                case '\u0012': {
                    if (!bl) {
                        calendar2 = (Calendar)calendar.clone();
                        calendar2.setFirstDayOfWeek(2);
                        calendar2.setMinimalDaysInFirstWeek(4);
                        calendar2.clear(3);
                        bl = true;
                    }
                    n4 = calendar2.get(3);
                    break;
                }
                case '\u0003': 
                case '\u0005': 
                case '\u0007': 
                case '\t': {
                    if (!bl) {
                        calendar2 = (Calendar)calendar.clone();
                        calendar2.setFirstDayOfWeek(2);
                        calendar2.setMinimalDaysInFirstWeek(4);
                        calendar2.clear(3);
                        bl = true;
                    }
                    n4 = calendar2.get(1);
                    if (calendar2.get(2) == 11) {
                        if (calendar2.get(3) == 1) {
                            ++n4;
                        }
                    } else if (calendar2.get(3) == 53) {
                        --n4;
                    }
                    if (c2 == '\t') break;
                    if (c2 == '\u0007') {
                        n4 %= 1000;
                        break;
                    }
                    if (c2 == '\u0005') {
                        n4 %= 100;
                        break;
                    }
                    n4 %= 10;
                    break;
                }
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ')': {
                    n4 = calendar.get(1);
                    break;
                }
                case '\b': {
                    n4 = calendar.get(1) % 1000;
                    break;
                }
                case '\u0006': 
                case '(': {
                    n4 = calendar.get(1) % 100;
                    break;
                }
                case '\u0004': {
                    n4 = calendar.get(1) % 10;
                    break;
                }
                case '\u0010': {
                    n4 = 1 + calendar.get(2) / 3;
                    break;
                }
                case '\u0013': {
                    n4 = (calendar.get(6) + 6) / 7;
                    break;
                }
                case '\u0014': {
                    n4 = (calendar.get(5) + 6) / 7;
                    break;
                }
                case '\u0016': {
                    n4 = calendar.get(5);
                    break;
                }
                case '\u0017': {
                    n4 = calendar.get(6);
                    break;
                }
                case '\u0018': {
                    n4 = calendar.get(11);
                    break;
                }
                case '\u0019': {
                    n4 = calendar.get(10);
                    if (n4 != 0) break;
                    n4 = 12;
                    break;
                }
                case '\u001a': {
                    n4 = calendar.get(12);
                    break;
                }
                case '\u001b': {
                    n4 = calendar.get(13);
                    break;
                }
                case '\u001c': {
                    n4 = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
                    break;
                }
                case '\u001d': {
                    n4 = this.toJulianDay(calendar);
                    if (n4 > 0) break;
                    return -n4;
                }
                case '\u0011': {
                    n4 = calendar.get(2) + 1;
                    break;
                }
                case '\u001e': {
                    n4 = calendar.get(2);
                    string = this.symbols.getMonthsRaw()[n4];
                    n = this.symbols.getMonthLength();
                    break;
                }
                case '\u001f': {
                    n4 = calendar.get(2);
                    string = this.symbols.getShortMonthsRaw()[n4];
                    n = this.symbols.getShortMonthLength();
                    break;
                }
                case ' ': {
                    n4 = calendar.get(7);
                    string = this.symbols.getWeekdaysRaw()[n4 - 1];
                    n = this.symbols.getWeekdayLength();
                    break;
                }
                case '!': {
                    n4 = calendar.get(7);
                    string = this.symbols.getShortWeekdaysRaw()[n4 - 1];
                    n = this.symbols.getShortWeekdayLength();
                    break;
                }
                case '\u0015': {
                    c = OraLocaleInfo.getInstance(this.locale).getOraTerritory().getStartDayOfTheWeek().charAt(0);
                    n4 = (calendar.get(7) + 7 - Character.digit(c, 10)) % 7;
                    if (n4 != 0) break;
                    n4 = 7;
                    break;
                }
                case '#': {
                    if (this.locale.equals(Locale.US)) {
                        if (calendar.get(9) == 0) {
                            string = "a.m.";
                            break;
                        }
                        string = "p.m.";
                        break;
                    }
                }
                case '\"': {
                    if (calendar.get(9) == 0) {
                        string = this.symbols.getAmPmStringsRaw()[0];
                        break;
                    }
                    string = this.symbols.getAmPmStringsRaw()[1];
                    break;
                }
                case '%': {
                    if (this.locale.equals(Locale.US)) {
                        if (calendar.get(0) == 1) {
                            string = "a.d.";
                            break;
                        }
                        string = "b.c.";
                        break;
                    }
                }
                case '$': {
                    if (calendar.get(0) == 1) {
                        string = this.symbols.getErasRaw()[1];
                        break;
                    }
                    string = this.symbols.getErasRaw()[0];
                    break;
                }
                case '+': 
                case ',': {
                    string = "";
                    break;
                }
                case '3': {
                    string = String.valueOf(this.symbols.getDecimalSeparator());
                    break;
                }
                case '.': {
                    n4 = new Timestamp(calendar.getTime().getTime()).getNanos();
                    break;
                }
                case '2': {
                    string = timeZone.getID();
                    break;
                }
                case '1': {
                    String string2 = timeZone.getDisplayName(timeZone.inDaylightTime(calendar.getTime()), 0, Locale.US);
                    if (string2.startsWith("GMT")) {
                        string = string2.substring(3);
                        break;
                    }
                    string = string2;
                    break;
                }
                case '/': 
                case '0': {
                    int n5 = calendar.get(15) + calendar.get(16);
                    if (c2 == '/') {
                        n4 = n5 / 3600000;
                        break;
                    }
                    if (n5 < 0) {
                        n5 = -n5;
                    }
                    n4 = n5 % 3600000 / 60000;
                    break;
                }
                case '*': {
                    continue block37;
                }
                default: {
                    return 5091;
                }
            }
            if ((n3 & 0x80) == 0) {
                n = (c3 & 0x10) != 0 ? n3 & 0xF : 0;
                if (n4 < nArray[1] || n4 > nArray[2]) {
                    return nArray[0];
                }
                if ((n3 & 0x20) != 0) {
                    if (c2 == '\u0002' || c2 == '\f') {
                        if (calendar.get(0) == 0) {
                            stringBuffer.append('-');
                        } else {
                            stringBuffer.append(' ');
                        }
                    } else if (c2 == '/') {
                        if (n4 < 0) {
                            stringBuffer.append('-');
                            n4 = -n4;
                        } else {
                            stringBuffer.append('+');
                        }
                    }
                    --n;
                }
                stringBuffer.append(this.toNumericString(n4, n3, n));
            } else {
                if ((c3 & 0x10) == 0 || (n3 & 0x40) != 0) {
                    n = 0;
                }
                n3 &= 0xF;
                String string3 = (c3 & 8) == 8 ? string.toUpperCase() : ((c3 & 4) == 4 ? this.toTitleCase(string) : string);
                stringBuffer.append(string3);
                for (int i = n - string3.length() - 1; i >= 0; --i) {
                    stringBuffer.append(' ');
                }
            }
            if (fieldPosition.getField() != this.oraDatePat.getFormatField(c2)) continue;
            fieldPosition.setEndIndex(stringBuffer.length());
        }
        if (fieldPosition.getField() == 1000) {
            fieldPosition.setEndIndex(stringBuffer.length());
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int parse(String var1_1, ParsePosition var2_2, Calendar var3_3) {
        block135: {
            var10_4 = new char[this.oraDatePat.iPatternLength];
            var19_5 = var3_3.get(1);
            var24_6 = -2147483648;
            var23_7 = -2147483648;
            var22_8 = -2147483648;
            var32_9 = -2147483648;
            var27_10 = -2147483648;
            var26_11 = -2147483648;
            var25_12 = -2147483648;
            var34_13 = -2147483648;
            var33_14 = -2147483648;
            var31_15 = 0;
            var29_16 = 0;
            var30_17 = 0;
            var35_18 = null;
            var37_19 = null;
            var36_20 = null;
            var40_21 = -2147483648;
            var39_22 = -2147483648;
            var38_23 = -2147483648;
            var15_24 = 0;
            var16_25 = -1;
            var41_26 = false;
            var42_27 = true;
            var5_28 = var2_2.getIndex();
            var6_29 = var1_1.length();
            var9_30 = this.oraDatePat.iPattern;
            while (true) {
                var8_33 = 0;
                var14_37 = 0;
                while (var8_33 < this.oraDatePat.iPatternLength) {
                    block137: {
                        block136: {
                            var4_31 = var2_2.getIndex();
                            if (var4_31 >= var6_29) {
                                var14_37 = 5040;
                                break;
                            }
                            var45_42 = 0;
                            if (!var41_26) {
                                while (var4_31 < var6_29 && Character.isWhitespace(var1_1.charAt(var4_31))) {
                                    ++var4_31;
                                    ++var45_42;
                                }
                            }
                            var11_34 = var9_30[var8_33];
                            if (var42_27) {
                                var10_4[var8_33] = var11_34 == 6 ? 10 : (var11_34 == 40 ? 41 : var11_34);
                            }
                            var12_35 = var9_30[++var8_33];
                            if (var42_27) {
                                var10_4[var8_33] = var12_35;
                            }
                            ++var8_33;
                            if (var11_34 >= 62) {
                                var46_43 = var11_34 - 62 - 1;
                                if (var41_26) {
                                    if (!var1_1.regionMatches(true, var4_31, new String(var9_30), var8_33, var46_43)) {
                                        var2_2.setErrorIndex(var4_31);
                                        return 5061;
                                    }
                                    var8_33 += var46_43;
                                    var2_2.setIndex(var4_31 + var46_43);
                                    continue;
                                }
                                if (var42_27) {
                                    System.arraycopy(var9_30, var8_33, var10_4, var8_33, var46_43);
                                }
                                if (var8_33 < this.oraDatePat.iPatternLength) {
                                    var47_44 = var9_30[var8_33 + var46_43];
                                    var48_45 = var9_30[var8_33 + var46_43 + 1];
                                } else {
                                    var48_45 = '\u0000';
                                    var47_44 = '\u0000';
                                }
                                if (var47_44 < '>') {
                                    var49_46 = OraDateFormatPattern.FORMAT_ATTR[var47_44];
                                    var50_47 = var49_46[3];
                                    if (var12_35 == '\u0001') {
                                        if (var6_29 - var4_31 < var46_43 || var8_33 + var45_42 + var46_43 > var9_30.length || !var1_1.regionMatches(true, var4_31, new String(var9_30), var8_33 + var45_42, var46_43)) {
                                            var2_2.setErrorIndex(var4_31);
                                            return 5061;
                                        }
                                        var4_31 += var46_43;
                                    } else {
                                        var51_48 = var46_43;
                                        while (!(var4_31 >= var6_29 || var51_48 <= 0 || Character.isLetterOrDigit(var13_36 = var1_1.charAt(var4_31)) || (var50_47 & 32) > 0 && var13_36 == '-')) {
                                            if (!Character.isWhitespace(var13_36)) {
                                                --var51_48;
                                            }
                                            ++var4_31;
                                        }
                                        while (var4_31 < var6_29 && Character.isWhitespace(var1_1.charAt(var4_31))) {
                                            ++var4_31;
                                        }
                                    }
                                }
                                var8_33 += var46_43;
                                var2_2.setIndex(var4_31);
                                continue;
                            }
                            if (var11_34 == 42) {
                                var41_26 = var41_26 == false;
                                var42_27 = false;
                                continue;
                            }
                            var43_39 = OraDateFormatPattern.FORMAT_ATTR[var11_34];
                            var44_41 = var43_39[3];
                            if ((var44_41 & 128) != 0) break block136;
                            var46_43 = 0;
                            if (var1_1.charAt(var4_31) == '-' || var1_1.charAt(var4_31) == '+') {
                                if (var1_1.charAt(var4_31) == '-') {
                                    var46_43 = 1;
                                }
                                if (++var4_31 < var6_29) {
                                    var2_2.setIndex(var4_31);
                                } else {
                                    var14_37 = 5058;
                                    break;
                                }
                            }
                            var2_2.setIndex(var4_31);
                            var17_38 = this.toNumber(var1_1, var6_29, var2_2, var44_41, (var44_41 & 16) > 0, var41_26, (var12_35 & 16) == 0);
                            if (var17_38 < 0) {
                                var14_37 = -var17_38;
                                break;
                            }
                            if (var46_43 != 0) {
                                var17_38 = -var17_38;
                            }
                            if (var17_38 < var43_39[1] || var17_38 > var43_39[2]) {
                                var14_37 = var43_39[0];
                                break;
                            }
                            switch (var11_34) {
                                case 21: {
                                    var47_44 = OraLocaleInfo.getInstance(this.locale).getOraTerritory().getStartDayOfTheWeek().charAt(0);
                                    var29_16 = (var17_38 + Character.digit(var47_44, 10)) % 7;
                                    if (var29_16 == 0) {
                                        var29_16 = 7;
                                        break;
                                    }
                                    break block137;
                                }
                                case 22: {
                                    var24_6 = var17_38;
                                    break;
                                }
                                case 23: {
                                    var30_17 = var17_38;
                                    break;
                                }
                                case 25: {
                                    var25_12 = var17_38;
                                    break;
                                }
                                case 24: {
                                    var25_12 = var17_38;
                                    break;
                                }
                                case 29: {
                                    var31_15 = var17_38;
                                    break;
                                }
                                case 26: {
                                    var26_11 = var17_38;
                                    break;
                                }
                                case 27: {
                                    var27_10 = var17_38;
                                    break;
                                }
                                case 28: {
                                    var32_9 = var17_38;
                                    break;
                                }
                                case 17: {
                                    var23_7 = var17_38 - 1;
                                    break;
                                }
                                case 10: 
                                case 11: 
                                case 12: {
                                    var22_8 = var17_38;
                                    break;
                                }
                                case 41: {
                                    var22_8 = var17_38;
                                    if (var17_38 >= 1000) break;
                                }
                                case 40: {
                                    var48_45 = var19_5 % 100;
                                    if (var48_45 <= '2') ** GOTO lbl161
                                    if (var17_38 < 50) {
                                        var22_8 = var19_5 + 100 - var48_45 + var17_38;
                                        break;
                                    }
                                    ** GOTO lbl164
lbl161:
                                    // 1 sources

                                    if (var17_38 >= 50) {
                                        var22_8 = var19_5 - 100 - var48_45 + var17_38;
                                        break;
                                    }
                                }
lbl164:
                                // 4 sources

                                case 6: {
                                    var22_8 = var19_5 - var19_5 % 100 + var17_38;
                                    break;
                                }
                                case 4: {
                                    var22_8 = var19_5 - var19_5 % 10 + var17_38;
                                    break;
                                }
                                case 8: {
                                    var22_8 = var19_5 - var19_5 % 1000 + var17_38;
                                    break;
                                }
                                case 47: {
                                    var39_22 = var17_38;
                                    break;
                                }
                                case 48: {
                                    var40_21 = var17_38;
                                    break;
                                }
                                default: {
                                    var14_37 = 5002;
                                    break;
                                }
                            }
                            break block137;
                        }
                        switch (var11_34) {
                            case 35: {
                                if (this.locale.equals(Locale.US)) {
                                    if (var1_1.regionMatches(true, var4_31, "a.m.", 0, 4)) {
                                        var33_14 = 0;
                                        var2_2.setIndex(var4_31 + 4);
                                        break;
                                    }
                                    if (var1_1.regionMatches(true, var4_31, "p.m.", 0, 4)) {
                                        var33_14 = 1;
                                        var2_2.setIndex(var4_31 + 4);
                                        break;
                                    }
                                    var14_37 = 5055;
                                    break;
                                }
                            }
                            case 34: {
                                var7_32 = this.symbols.getAmPmStringsRaw()[0].length();
                                if (var6_29 - var4_31 >= var7_32 && var1_1.regionMatches(true, var4_31, this.symbols.getAmPmStringsRaw()[0], 0, var7_32)) {
                                    var33_14 = 0;
                                } else {
                                    var7_32 = this.symbols.getAmPmStringsRaw()[1].length();
                                    if (var6_29 - var4_31 >= var7_32 && var1_1.regionMatches(true, var4_31, this.symbols.getAmPmStringsRaw()[1], 0, var7_32)) {
                                        var33_14 = 1;
                                    } else {
                                        var14_37 = 5055;
                                    }
                                }
                                var2_2.setIndex(var4_31 + var7_32);
                                break;
                            }
                            case 37: {
                                if (this.locale.equals(Locale.US)) {
                                    if (var4_31 + 4 <= var6_29 && var1_1.regionMatches(true, var4_31, "a.d.", 0, 4)) {
                                        var34_13 = 1;
                                        var2_2.setIndex(var4_31 + 4);
                                        break;
                                    }
                                    if (var4_31 + 4 <= var6_29 && var1_1.regionMatches(true, var4_31, "b.c.", 0, 4)) {
                                        var34_13 = 0;
                                        var2_2.setIndex(var4_31 + 4);
                                        break;
                                    }
                                    var14_37 = 5056;
                                    break;
                                }
                            }
                            case 36: {
                                var7_32 = this.symbols.getErasRaw()[0].length();
                                if (var6_29 - var4_31 >= var7_32 && var1_1.regionMatches(true, var4_31, this.symbols.getErasRaw()[0], 0, var7_32)) {
                                    var34_13 = 0;
                                } else {
                                    var7_32 = this.symbols.getErasRaw()[1].length();
                                    if (var6_29 - var4_31 >= var7_32 && var1_1.regionMatches(true, var4_31, this.symbols.getErasRaw()[1], 0, var7_32)) {
                                        var34_13 = 1;
                                    } else {
                                        var14_37 = 5056;
                                        break;
                                    }
                                }
                                var2_2.setIndex(var4_31 + var7_32);
                                break;
                            }
                            case 43: 
                            case 44: {
                                break;
                            }
                            case 31: {
                                var23_7 = this.toMonthNumber(var1_1, var6_29, var2_2, var41_26, false);
                                if (var23_7 >= 0) break;
                                var14_37 = 5043;
                                break;
                            }
                            case 30: {
                                var23_7 = this.toMonthNumber(var1_1, var6_29, var2_2, var41_26, true);
                                if (var23_7 >= 0) break;
                                var14_37 = 5043;
                                break;
                            }
                            case 33: {
                                var29_16 = this.findName(var1_1, var6_29, var2_2, this.symbols.getShortWeekdaysRaw());
                                if (var29_16 < 0) {
                                    var14_37 = 5046;
                                    break;
                                }
                                ++var29_16;
                                break;
                            }
                            case 32: {
                                var29_16 = this.findName(var1_1, var6_29, var2_2, this.symbols.getWeekdaysRaw());
                                if (var29_16 < 0) {
                                    var14_37 = 5046;
                                    break;
                                }
                                ++var29_16;
                                break;
                            }
                            case 50: {
                                if (var39_22 != -2147483648 || var40_21 != -2147483648) {
                                    var14_37 = 5057;
                                    break;
                                }
                                var38_23 = this.getTimeZoneOffset(var1_1, var6_29, var2_2, var11_34, var41_26, (var12_35 & 16) == 0);
                                if (var38_23 != -2147483648 || (var36_20 = this.getTimeZoneID(var1_1, var6_29, var2_2)) != null) break;
                                var14_37 = 5057;
                                break;
                            }
                            case 49: {
                                if (var39_22 != -2147483648 || var40_21 != -2147483648) {
                                    var14_37 = 5057;
                                }
                                if ((var37_19 = this.getTimeZoneAbbr(var1_1, var6_29, var2_2)) != null) break;
                                var14_37 = 5057;
                                break;
                            }
                            default: {
                                var14_37 = 5091;
                            }
                        }
                    }
                    if (var14_37 <= 0) continue;
                }
                if (var14_37 == 0 && var2_2.getIndex() < var6_29) {
                    if (var41_26) {
                        var14_37 = 5030;
                    } else {
                        for (var4_31 = var2_2.getIndex(); var4_31 < var6_29 && Character.isWhitespace(var1_1.charAt(var4_31)); ++var4_31) {
                        }
                        if (var4_31 < var6_29) {
                            var14_37 = 5030;
                        }
                    }
                }
                if (var14_37 <= 0) break block135;
                if (!var42_27) break;
                var9_30 = var10_4;
                var16_25 = var2_2.getIndex();
                var2_2.setIndex(var5_28);
                var42_27 = false;
                var15_24 = var14_37;
            }
            if (var15_24 > 0) {
                var2_2.setErrorIndex(var16_25);
                return var15_24;
            }
            var2_2.setErrorIndex(var2_2.getIndex());
            return var14_37;
        }
        if (var33_14 != -2147483648 && var25_12 != -2147483648) {
            if (var25_12 == 12) {
                var25_12 = 0;
            } else if (var33_14 == 1) {
                var25_12 += 12;
            }
        }
        var21_49 = 1;
        if (var31_15 > 0) {
            var3_3.clear();
            var14_37 = this.julianToCalendar(var31_15, var3_3);
            if (var14_37 > 0) {
                return var14_37;
            }
            var21_49 = var3_3.get(5);
        }
        var18_50 = var3_3.get(0);
        var19_5 = var3_3.get(1);
        var20_51 = var3_3.get(2);
        if (var34_13 != -2147483648) {
            if (var31_15 > 0 && var34_13 != var18_50) {
                return 5031;
            }
        } else {
            var34_13 = var18_50;
        }
        if (var22_8 == -2147483648) {
            var22_8 = var19_5;
        } else if (var31_15 > 0 && var22_8 != var19_5) {
            return 5031;
        }
        if (var22_8 == 0) {
            return 5041;
        }
        if (var30_17 > 0) {
            var3_3.clear();
            var3_3.set(1, var22_8);
            var3_3.set(6, var30_17);
            var20_51 = var3_3.get(2);
            var21_49 = var3_3.get(5);
        }
        if (var23_7 != -2147483648) {
            if ((var30_17 > 0 || var31_15 > 0) && var23_7 != var20_51) {
                return 5033;
            }
        } else {
            var23_7 = var20_51;
        }
        if (var24_6 != -2147483648) {
            if ((var30_17 > 0 || var31_15 > 0) && var24_6 != var21_49) {
                return 5034;
            }
        } else {
            var24_6 = var21_49;
        }
        if (var32_9 != -2147483648) {
            var43_40 = var32_9 / 3600;
            var44_41 = var32_9 % 3600 / 60;
            var45_42 = var32_9 % 3600 % 60;
            if (var25_12 != -2147483648) {
                if (var25_12 != var43_40) {
                    return 5036;
                }
            } else {
                var25_12 = var43_40;
            }
            if (var26_11 != -2147483648) {
                if (var26_11 != var44_41) {
                    return 5037;
                }
            } else {
                var26_11 = var44_41;
            }
            if (var27_10 != -2147483648) {
                if (var27_10 != var45_42) {
                    return 5038;
                }
            } else {
                var27_10 = var45_42;
            }
        } else {
            if (var25_12 == -2147483648) {
                var25_12 = 0;
            }
            if (var26_11 == -2147483648) {
                var26_11 = 0;
            }
            if (var27_10 == -2147483648) {
                var27_10 = 0;
            }
        }
        if (var22_8 == 1582 && var23_7 == 9 && var24_6 >= 5 && var24_6 < 15) {
            var24_6 = 15;
        }
        var3_3.clear();
        if (var22_8 < 0) {
            var3_3.set(-var22_8, var23_7, var24_6, var25_12, var26_11, var27_10);
            var3_3.set(0, 0);
        } else {
            var3_3.set(var22_8, var23_7, var24_6, var25_12, var26_11, var27_10);
            if (var34_13 != -2147483648) {
                var3_3.set(0, var34_13);
            }
        }
        if (var38_23 != -2147483648) {
            var3_3.setTimeZone(TimeZone.getTimeZone("GMT"));
            var3_3.set(15, var38_23);
        } else if (var39_22 != -2147483648 || var40_21 != -2147483648) {
            if (var39_22 == -2147483648 && ((var39_22 = this.calendar.get(15) / 3600000) > 0 && var40_21 < 0 || var39_22 < 0 && var40_21 > 0)) {
                return 5057;
            }
            if (var40_21 == -2147483648) {
                var40_21 = this.calendar.get(15) % 60000;
            }
            var38_23 = var39_22 * 3600000;
            if (var40_21 != 0) {
                var38_23 += var40_21 * 60000;
            }
            var3_3.setTimeZone(TimeZone.getTimeZone("GMT"));
            var3_3.set(15, var38_23);
        } else if (!this.setTimeZone(var36_20, var37_19, var3_3, this.locale)) {
            return 5057;
        }
        if (var29_16 > 0 && var3_3.get(7) != var29_16) {
            return 5035;
        }
        return 0;
    }

    private int getTimeZoneOffset(String string, int n, ParsePosition parsePosition, int n2, boolean bl, boolean bl2) {
        int n3 = Integer.MIN_VALUE;
        int n4 = parsePosition.getIndex();
        boolean bl3 = false;
        if (n4 >= n) {
            return Integer.MIN_VALUE;
        }
        char c = string.charAt(n4);
        if (c == ':') {
            if (++n4 >= n) {
                return Integer.MIN_VALUE;
            }
            parsePosition.setIndex(n4);
            c = string.charAt(n4);
            bl3 = true;
        }
        if (Character.isDigit(c) || n4 + 2 <= n && (c == '+' || c == '-')) {
            boolean bl4;
            n3 = 0;
            int n5 = 0;
            int n6 = 0;
            if (c == '-') {
                bl4 = true;
                ++n4;
            } else {
                bl4 = false;
                if (c == '+') {
                    ++n4;
                }
            }
            parsePosition.setIndex(n4);
            n6 = this.toNumber(string, n, parsePosition, 2, false, bl, bl2);
            if (n6 >= 0) {
                if (bl3) {
                    n5 = n6;
                    int[] nArray = OraDateFormatPattern.FORMAT_ATTR[48];
                    if (bl4 && -n5 < nArray[1] || !bl4 && n5 > nArray[2]) {
                        return Integer.MIN_VALUE;
                    }
                    n3 = n5 * 60000;
                } else {
                    int[] nArray = OraDateFormatPattern.FORMAT_ATTR[47];
                    if (bl4 && -n6 < nArray[1] || !bl4 && n6 > nArray[2]) {
                        return Integer.MIN_VALUE;
                    }
                    n3 = n6 * 3600000;
                    n4 = parsePosition.getIndex();
                    if (n4 < n && string.charAt(n4) == ':') {
                        parsePosition.setIndex(++n4);
                    }
                    if (n4 < n && string.charAt(n4) == '+') {
                        parsePosition.setIndex(++n4);
                    }
                    if (n4 < n && (n5 = this.toNumber(string, n, parsePosition, 2, false, bl, bl2)) >= 0) {
                        nArray = OraDateFormatPattern.FORMAT_ATTR[48];
                        if (n5 < nArray[1] || n5 > nArray[2]) {
                            return Integer.MIN_VALUE;
                        }
                        n3 += n5 * 60000;
                    }
                }
            }
            if (bl4) {
                n3 = -n3;
            }
        }
        return n3;
    }

    private String getTimeZoneID(String string, int n, ParsePosition parsePosition) {
        String[] stringArray = TimeZone.getAvailableIDs();
        int n2 = parsePosition.getIndex();
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = stringArray[i].length();
            if (n2 + n3 > n || !string.regionMatches(true, n2, stringArray[i], 0, n3)) continue;
            parsePosition.setIndex(n2 + n3);
            return stringArray[i];
        }
        return null;
    }

    private String getTimeZoneAbbr(String string, int n, ParsePosition parsePosition) {
        int n2 = parsePosition.getIndex();
        if (n2 + 3 > n) {
            return null;
        }
        parsePosition.setIndex(n2 + 3);
        return string.substring(n2, n2 + 3);
    }

    private boolean setTimeZone(String string, String string2, Calendar calendar, Locale locale) {
        TimeZone timeZone;
        if (string != null) {
            timeZone = TimeZone.getTimeZone(string);
            calendar.setTimeZone(timeZone);
        } else {
            timeZone = calendar.getTimeZone();
        }
        if (string2 != null) {
            if (timeZone.getDisplayName(true, 0, locale).equals(string2) && !timeZone.inDaylightTime(calendar.getTime())) {
                return false;
            }
            if (timeZone.getDisplayName(false, 0, locale).equals(string2) && timeZone.inDaylightTime(calendar.getTime())) {
                return false;
            }
        }
        return true;
    }

    private int toMonthNumber(String string, int n, ParsePosition parsePosition, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return this.findName(string, n, parsePosition, this.symbols.getMonthsRaw());
            }
            return this.findName(string, n, parsePosition, this.symbols.getShortMonthsRaw());
        }
        int n2 = this.findName(string, n, parsePosition, this.symbols.getMonthsRaw());
        if (n2 < 0) {
            return this.findName(string, n, parsePosition, this.symbols.getShortMonthsRaw());
        }
        return n2;
    }

    private int findName(String string, int n, ParsePosition parsePosition, String[] stringArray) {
        int n2 = parsePosition.getIndex();
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = stringArray[i].length();
            if (n3 > n || stringArray[i].equals("") || !string.regionMatches(true, n2, stringArray[i], 0, n3)) continue;
            parsePosition.setIndex(n2 + n3);
            return i;
        }
        return -1;
    }

    private String toTitleCase(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) {
                stringBuffer.append(c);
                if (bl) continue;
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toTitleCase(c));
                bl = false;
                continue;
            }
            stringBuffer.append(Character.toLowerCase(c));
        }
        return stringBuffer.toString();
    }

    private int toNumber(String string, int n, ParsePosition parsePosition, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        int n4 = parsePosition.getIndex();
        char c = string.charAt(n4);
        if (!Character.isDigit(c)) {
            return -5058;
        }
        int n5 = Character.digit(c, 10);
        ++n4;
        for (n3 = 1; n3 < n2 && n4 < n; ++n3, ++n4) {
            c = string.charAt(n4);
            if (c == this.symbols.getGroupingSeparator()) {
                if (bl) continue;
                break;
            }
            if (!Character.isDigit(c)) break;
            n5 = n5 * 10 + Character.digit(c, 10);
        }
        if (bl2 && !bl3 && n3 != n2) {
            return -5062;
        }
        parsePosition.setIndex(n4);
        return n5;
    }

    private String toNumericString(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 0x10) != 0 && (n3 > 0 || n > 1000)) {
            stringBuffer.append(n / 1000);
            stringBuffer.append(this.symbols.getGroupingSeparator());
            n %= 1000;
            n3 = n3 > 0 ? (n3 -= 2) : 3;
        }
        String string = String.valueOf(n);
        for (int i = n3 - string.length() - 1; i >= 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private int toJulianDay(Calendar calendar) {
        int n;
        int n2;
        int n3 = calendar.get(0) == 1 ? calendar.get(1) : -calendar.get(1);
        if (n3 < -4712 || n3 > 9999) {
            return -5041;
        }
        if (n3 == -4712) {
            n2 = 0;
        } else {
            n2 = n3 + 4712;
            n2 = 365 * n2 + (n2 - 1) / 4;
        }
        if (n3 >= 1583) {
            n2 = n2 - 10 - (n3 - 1501) / 100 + (n3 - 1201) / 400;
        }
        n2 += calendar.get(6);
        if (n3 == 1582 && ((n = calendar.get(2)) == 9 && calendar.get(5) >= 15 || n >= 10)) {
            n2 -= 10;
        }
        return n2;
    }

    private int julianToCalendar(int n, Calendar calendar) {
        if (n < 1) {
            int n2 = 5054;
        } else {
            if (n < 366) {
                int n3 = 4712;
                calendar.set(0, 0);
                calendar.set(1, n3);
                calendar.set(6, n);
                return 0;
            }
            if (n < 2299161) {
                int n4 = -4711 + (n -= 366) / 1461 * 4;
                int n5 = (n %= 1461) / 365;
                int n6 = n % 365;
                if (n6 == 0 && n5 == 4) {
                    n6 = 366;
                    n5 = 3;
                } else {
                    ++n6;
                }
                if ((n4 += n5) < 0) {
                    calendar.set(0, 0);
                    calendar.set(1, -n4);
                } else {
                    calendar.set(0, 1);
                    calendar.set(1, n4);
                }
                calendar.set(6, n6);
                return 0;
            }
            n = 4 * (n - 1721119) - 1;
            int n7 = n / 146097;
            int n8 = (n %= 146097) / 4;
            n = 4 * n8 + 3;
            n8 = n % 1461;
            n /= 1461;
            n8 /= 4;
            int n9 = 5 * ++n8 - 3;
            n8 = n9 % 153;
            n8 /= 5;
            ++n8;
            n7 *= 100;
            n7 += n;
            if ((n9 /= 153) < 10) {
                n9 += 3;
            } else {
                n9 -= 9;
                ++n7;
            }
            calendar.set(n7, n9 - 1, n8);
        }
        return 0;
    }
}

