/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.Vector;
import oracle.i18n.text.OraLinguistic;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.UnicodeMapChar;
import oracle.sql.converter.CharacterConverters;

public class OraLinguisticSetter
extends OraLinguistic {
    static final int FIRST_LEVEL_LENGTH = 256;
    static final int SECOND_LEVEL_LENGTH = 65536;
    static final short BASE_PRIMARY_PART = 31;
    static final short BASE_SECONDARY_PART = 1;
    static final short BASE_TERTIARY_PART = 31;
    static final int TWOBYTESHIFT = 16;
    static final int ONEBYTESHIFT = 8;
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();

    public void setVersion(String string) {
        this.VERSION = string;
    }

    public void setSortName(String string) {
        this.SORTNAME = string;
    }

    public void setSortId(String string) {
        this.SORTID = string == null ? -1 : Integer.parseInt(string);
    }

    public void setBaseSortName(String string) {
        this.BASESORTNAME = string;
    }

    public void setBaseSortId(String string) {
        this.BASESORTID = string == null ? 0 : Integer.parseInt(string);
    }

    public void setReverseSec(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Reverse_secondary = true;
        }
    }

    public void setCanonicalEq(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Canonical_equivalence = true;
        }
    }

    public void setSwapWithNext(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Swap_with_next = true;
        }
    }

    public void setHangulJamo(String string) {
        if (string != null && string.compareTo("TRUE") == 0) {
            this.Hangul_jamo_composition = true;
        }
    }

    public void setMonolingual(boolean bl) {
        this.monolingual = bl;
    }

    public void setCollationLevel1(int[] nArray) {
        this.collationLevel1 = new int[256];
        System.arraycopy(nArray, 0, this.collationLevel1, 0, 256);
    }

    public void setCollationLevel2(int n, int n2) {
        this.collationLevel2[n] = n2;
    }

    public void setCollationLevel2(int n, int[] nArray) {
        this.collationLevel2 = new int[n];
        System.arraycopy(nArray, 0, this.collationLevel2, 0, n);
    }

    public void setContractTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.contractCollKey = new int[n];
        this.contractNumOfFE = new byte[n];
        this.contractConChar = new char[n][];
        for (int i = 0; i < n; ++i) {
            int[] nArray = (int[])vector.elementAt(i);
            this.contractCollKey[i] = nArray[1];
            this.contractNumOfFE[i] = (byte)nArray[2];
            this.contractConChar[i] = new char[nArray.length - 3];
            for (int j = 3; j < nArray.length; ++j) {
                this.contractConChar[i][j - 3] = (char)nArray[j];
            }
        }
    }

    public void setExpandingTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.expandExpCharKey = new int[n][];
        for (int i = 0; i < n; ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            this.expandExpCharKey[i] = new int[vector2.size()];
            for (int j = 0; j < vector2.size(); ++j) {
                this.expandExpCharKey[i][j] = (Integer)vector2.elementAt(j);
            }
        }
    }

    public void setContextSensitiveTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.contextPrevCpt = new int[n];
        this.contextCollKey = new int[n];
        this.contextSenChar = new char[n];
        this.contextNumOfFE = new byte[n];
        for (int i = 0; i < n; ++i) {
            int[] nArray = (int[])vector.elementAt(i);
            this.contextNumOfFE[i] = (byte)nArray[1];
            this.contextCollKey[i] = nArray[2];
            this.contextPrevCpt[i] = nArray[3] << 16 + nArray[4];
            this.contextSenChar[i] = (char)nArray[0];
        }
    }

    public void setSurrogateTable(Vector[] vectorArray) {
        if (vectorArray == null) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            if (vectorArray[i] == null) continue;
            if (this.surrogateTable == null) {
                this.surrogateTable = new int[16][];
            }
            this.surrogateTable[i] = new int[vectorArray[i].size()];
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                this.surrogateTable[i][j] = (Integer)vectorArray[i].elementAt(j);
            }
        }
    }

    public void setBaseLetterTable(UnicodeMapChar unicodeMapChar) {
        this.baseLetterTable = unicodeMapChar;
    }

    public void statistic() {
        System.out.println(" this is the statistic");
        System.out.println(" The first level length is " + this.collationLevel1.length);
        System.out.println(" The secondary level length is " + this.collationLevel2.length);
        if (this.contractCollKey != null) {
            System.out.println(" The contract table entry#  is " + this.contractCollKey.length);
            System.out.println(" More length " + this.contractNumOfFE.length + " " + this.contractConChar.length);
        }
        if (this.expandExpCharKey != null) {
            System.out.println(" The expanding table entry# is " + this.expandExpCharKey.length);
        }
        if (this.contextPrevCpt != null) {
            System.out.println(" The context sensitive table is " + this.contextPrevCpt.length);
            System.out.println(this.contextCollKey.length + " " + this.contextSenChar.length + " " + this.contextNumOfFE.length);
        }
        if (this.surrogateTable == null) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.surrogateTable[i] == null) {
                System.out.println("table " + i + " is empty");
                continue;
            }
            System.out.println("table " + i + " length is " + this.surrogateTable[i].length);
        }
    }

    public static OraLinguistic buildFromCharSet(CharacterConverters characterConverters, int n) {
        int n2;
        OraLinguisticSetter oraLinguisticSetter = new OraLinguisticSetter();
        oraLinguisticSetter.setSortName("BINARY");
        oraLinguisticSetter.setSortId(Integer.toString(n + 8192));
        int n3 = 31;
        int n4 = 2;
        Vector vector = new Vector();
        characterConverters.extractCodepoints(vector);
        Vector[] vectorArray = new Vector[16];
        int[] nArray = new int[65536];
        int n5 = 0;
        Object object = null;
        for (int i = 0; i < vector.size(); ++i) {
            int n6 = ((int[])vector.elementAt(i))[1];
            n5 = OraLinguisticSetter.combineKey(n3, 1, 31);
            n3 += n4;
            if (((long)n6 & 0xFFFFFFFFL) > 65535L) {
                n2 = n6 >>> 16;
                int n7 = n6 & 0xFFFF;
                if (n2 < 55296 || n2 > 56319 || n7 < 56320 || n7 > 57343) continue;
                if (object == null) {
                    object = new int[1024][];
                }
                OraLinguisticSetter.processSurrogate(object, n2, n7, n5);
                continue;
            }
            nArray[n6] = n5;
        }
        if (object != null) {
            OraLinguisticSetter.compressSurrogateTables(object, nArray, vectorArray);
        }
        if (vectorArray != null) {
            oraLinguisticSetter.setSurrogateTable(vectorArray);
        }
        int[] nArray2 = new int[256];
        n2 = OraLinguisticSetter.compressIntArray(nArray, nArray2);
        oraLinguisticSetter.setCollationLevel1(nArray2);
        oraLinguisticSetter.setCollationLevel2(n2, nArray);
        return oraLinguisticSetter;
    }

    static void processSurrogate(int[][] object, int n, int n2, int n3) {
        int n4 = n - 55296;
        int n5 = n2 - 56320;
        if (object == null) {
            object = new int[1024][];
        }
        if (object[n4] == null) {
            object[n4] = new int[1024];
        }
        object[n4][n5] = n3;
    }

    static void compressSurrogateTables(int[][] nArray, int[] nArray2, Vector[] vectorArray) {
        if (nArray == null) {
            return;
        }
        int n = 0;
        for (int i = 55296; i < 56319; ++i) {
            int n2;
            int n3 = i - 55296;
            int n4 = n3 >> 6;
            int[] nArray3 = nArray[n3];
            if (nArray3 == null) continue;
            if (vectorArray[n4] == null) {
                vectorArray[n4] = new Vector();
                n = 0;
            }
            nArray2[i] = n2 = -3866624 + n;
            for (int j = 0; j < 1024; ++j) {
                vectorArray[n4].addElement(new Integer(nArray[n3][j]));
            }
            n += 1024;
        }
    }

    static int compressIntArray(int[] nArray, int[] nArray2) {
        nArray2[0] = 0;
        int n = 256;
        for (int i = 1; i < 256; ++i) {
            int n2;
            int n3;
            int n4 = i << 8;
            for (n3 = 0; n3 < n; ++n3) {
                int n5;
                int n6;
                int n7 = 256 < n - n3 ? 256 : n - n3;
                for (n2 = 0; n2 < n7 && (n6 = nArray[n3 + n2]) == (n5 = nArray[n4 | n2]); ++n2) {
                }
                if (n2 == n7) break;
            }
            nArray2[i] = n3;
            for (n2 = (i << 8) + (n - n3); n2 < i + 1 << 8; ++n2) {
                nArray[n++] = nArray[n2];
            }
        }
        return n;
    }

    private static int combineKey(int n, int n2, int n3) {
        if (((long)n & 0xFFFFFFFFL) >= 0xFFF00000L) {
            return n;
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    public void setLatinOneTable() {
        this.LatinOneTable = new int[257][2];
        if (this.collationLevel2[0] == 0) {
            this.LatinOneTable[0][0] = 1;
            this.LatinOneTable[0][1] = 0;
        }
        for (int i = 1; i <= 255; ++i) {
            int n = this.collationLevel2[i];
            if (this.isExpanding(n)) {
                int n2 = this.getIndex(n);
                int[] nArray = this.getExpandExpCharKey(n2);
                if (nArray.length > 2) {
                    this.LatinOneTable = null;
                    return;
                }
                this.LatinOneTable[i][0] = nArray[0];
                this.LatinOneTable[i][1] = nArray.length > 1 ? nArray[1] : 0;
                continue;
            }
            if (this.isZero(n)) {
                this.LatinOneTable[i][0] = -65536;
                this.LatinOneTable[i][1] = i << 16;
                continue;
            }
            this.LatinOneTable[i][0] = n;
            this.LatinOneTable[i][1] = 0;
        }
    }
}

