/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import oracle.ewt.EwtComponent;
import oracle.ewt.UIManager;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.SortableTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.event.Cancelable;
import oracle.ewt.grid.CheckPainter;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.GridToolTipClient;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderItemInputHandler;
import oracle.ewt.header.HeaderKeyHandler;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.header.StandardHeaderKeyHandler;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.SeparatorBorderPainter;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class ASMConfiguration
extends OiifpWizPanel
implements ItemListener,
ActionListener,
GridEditListener,
GridRowSelectListener {
    private static final String DEFAULT_TITLE = "Configure Automatic Storage Manager (ASM)";
    private static final String DEFAULT_PROMPT_0 = "Specify Disk Group Characteristics.";
    private static final String DEFAULT_PROMPT_1 = "Note: if you don't see disks which you believe should be available, you may need  to change the Disk Discovery Path.";
    private static final String DEFAULT_LABEL_0 = "Disk Group Name:";
    private static final String DEFAULT_SUBTITLE_0 = "Redundancy";
    private static final String DEFAULT_SUBTITLE_1 = "Required Storage Space";
    private static final String DEFAULT_SUBTITLE_2 = "Add Member Disks";
    private static final String DEFAULT_CHECKBOX_0 = "High";
    private static final String DEFAULT_CHECKBOX_1 = "Normal";
    private static final String DEFAULT_CHECKBOX_2 = "External";
    private static final String DEFAULT_CHECKBOX_3 = "Show Candidates";
    private static final String DEFAULT_CHECKBOX_4 = "Show All";
    private static final String DEFAULT_LABEL_1 = "Data File Storage:";
    private static final String DEFAULT_LABEL_2 = "Recovery Area Storage:";
    private static final String DEFAULT_LABEL_3 = "Redundancy:";
    private static final String DEFAULT_LABEL_4 = "Existing Free Space in Disk Group:";
    private static final String DEFAULT_LABEL_5 = "Size of New Disks Selected:";
    private static final String DEFAULT_LABEL_6 = "Additional Space Needed:";
    private static final String DEFAULT_LABEL_1_0 = "700";
    private static final String DEFAULT_LABEL_2_0 = "1400";
    private static final String DEFAULT_LABEL_4_0 = "0";
    private static final String DEFAULT_LABEL_5_0 = "0";
    private static final String DEFAULT_LABEL_7 = "MB";
    private static final String DEFAULT_LABEL_8 = "+";
    private static final String DEFAULT_LABEL_9 = "x";
    private static final String DEFAULT_LABEL_10 = "-";
    private static final String DEFAULT_LABEL_12 = "N/A";
    private static final String DEFAULT_BUTTON_LABEL_0 = "Change Disk Discovery Path...";
    private static final String DEFAULT_BUTTON_LABEL_1 = "Stamp Disks...";
    private static final String DEFAULT_TEXT_0 = "DATA";
    private MultiLineLabel prompt0 = new MultiLineLabel(WordWrapper.getTextWrapper(), "Specify Disk Group Characteristics.");
    private MultiLineLabel prompt1 = new MultiLineLabel(WordWrapper.getTextWrapper(), "Note: if you don't see disks which you believe should be available, you may need  to change the Disk Discovery Path.");
    private LWCheckboxGroup checkGroup0 = new LWCheckboxGroup();
    private LWCheckbox checkbox0 = new LWCheckbox("High", this.checkGroup0, false);
    private LWCheckbox checkbox1 = new LWCheckbox("Normal", this.checkGroup0, true);
    private LWCheckbox checkbox2 = new LWCheckbox("External", this.checkGroup0, false);
    private LWCheckboxGroup checkGroup1 = new LWCheckboxGroup();
    private LWCheckbox checkbox3 = new LWCheckbox("Show Candidates", this.checkGroup1, true);
    private LWCheckbox checkbox4 = new LWCheckbox("Show All", this.checkGroup1, false);
    private LWLabel label0 = new LWLabel("Disk Group Name:");
    private LWLabel label1 = new LWLabel("Data File Storage:");
    private LWLabel label1_0 = new LWLabel("700");
    private LWLabel label1_1 = new LWLabel("MB");
    private LWLabel label2 = new LWLabel("Recovery Area Storage:");
    private LWLabel label2_0 = new LWLabel("1400");
    private LWLabel label2_1 = new LWLabel("MB");
    private LWLabel label3 = new LWLabel("Redundancy:");
    private LWLabel label3_0 = new LWLabel("2 (Norm)");
    private LWLabel label4 = new LWLabel("Existing Free Space in Disk Group:");
    private LWLabel label4_0 = new LWLabel("0");
    private LWLabel label4_1 = new LWLabel("MB");
    private LWLabel label5 = new LWLabel("Size of New Disks Selected:");
    private LWLabel label5_0 = new LWLabel("0");
    private LWLabel label5_1 = new LWLabel("MB");
    private LWLabel label6 = new LWLabel("Additional Space Needed:");
    private LWLabel label6_0 = new LWLabel(String.valueOf(this.calculateAdditionalSpace()) + " " + "MB");
    private LWLabel label7 = new LWLabel("MB");
    private LWLabel label8 = new LWLabel("+");
    private LWLabel label9 = new LWLabel("x");
    private LWLabel label10 = new LWLabel("-");
    private LWLabel label11 = new LWLabel("-");
    private LWLabel label12 = new LWLabel("N/A");
    private LWLabel subTitle0 = new LWLabel("Redundancy");
    private LWLabel subTitle1 = new LWLabel("Required Storage Space");
    private LWLabel subTitle2 = new LWLabel("Add Member Disks");
    private LWButton button0 = new LWButton("Change Disk Discovery Path...");
    private LWButton button1 = new LWButton("Stamp Disks...");
    private LWTextField text0 = new LWTextField("DATA");
    private LWContainer panel0 = null;
    private LWContainer panel1 = null;
    private LWContainer panel2 = null;
    private LWContainer subpanel00 = null;
    private static String[] DEF_COL_HEADERS = new String[]{OiStdDialogRes.getString("SELECT"), OiStdDialogRes.getString("OiASM_DISKPATH_COL_LABEL"), OiStdDialogRes.getString("OiASM_SIZE_COL_LABEL"), OiStdDialogRes.getString("OiASM_STATUS_COL_LABEL")};
    private static int S_SELECT_COLWIDTH = 40;
    private static int S_DISKPATH_COLWIDTH = 370;
    private static int S_SIZE_COLWIDTH = 80;
    private static int S_STATUS_COLWIDTH = 85;
    private static int totRows = 0;
    private DisableRowSpreadTable sTable;
    private SortableTwoDDataSource data;
    private ArrayOneDDataSource header;
    private ScrollBox tableScroll;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private static final String HIGH_REDUNDANCY_VALUE = "3 (High)";
    private static final String NORMAL_REDUNDANCY_VALUE = "2 (Norm)";
    private static final String EXTERNAL_REDUNDANCY_VALUE = "1 (Ext)";
    private boolean allowDiskGroupCreation = true;
    private String diskDiscoveryString = "";
    private Vector vecSelectable = new Vector();
    private String[] mstrArrCandidateDisks = null;
    private String[] mstrArrAllDisks = null;
    private boolean windowsPlatform = false;
    private boolean processSpawnedForStampDisks = false;
    private long time1 = 0L;

    public ASMConfiguration() {
        super(DEFAULT_TITLE);
        this.gridbag = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)this.gridbag);
        this.c = new GridBagConstraints();
        this.createPanel0();
        this.createPanel1();
        this.createPanel2();
        this.addComponent((Component)this.panel0, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 0, 1, 1, 0.15, 0.25, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.panel1, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 1, 0, 1, 1, 0.75, 0.25, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.panel2, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 5, 2, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.checkbox0.addItemListener((ItemListener)this);
        this.checkbox1.addItemListener((ItemListener)this);
        this.checkbox2.addItemListener((ItemListener)this);
        this.checkbox3.addItemListener((ItemListener)this);
        this.checkbox4.addItemListener((ItemListener)this);
        this.button0.addActionListener((ActionListener)this);
        this.button1.addActionListener((ActionListener)this);
        try {
            int dataFileStorage = Integer.parseInt(this.label1_0.getText());
            this.label2_0.setText(String.valueOf(dataFileStorage * 2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.label0.setLabelFor((Component)this.text0);
        this.checkbox0.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox0.getLabel());
        this.checkbox1.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox1.getLabel());
        this.checkbox2.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox2.getLabel());
        this.checkbox3.getAccessibleContext().setAccessibleName(this.subTitle2.getText() + "\n" + this.checkbox3.getLabel());
        this.checkbox4.getAccessibleContext().setAccessibleName(this.subTitle2.getText() + "\n" + this.checkbox4.getLabel());
    }

    private void createPanel0() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.panel0 = new LWContainer();
        this.panel0.setLayout((LayoutManager)gridBag1);
        this.addComponent((Component)this.prompt0, (Container)this.panel0, gridBag1, c1, 1, 18, 0, 0, 2, 2, 0.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.label0, (Container)this.panel0, gridBag1, c1, 1, 17, 0, 2, 1, 1, 0.0, 0.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.text0, (Container)this.panel0, gridBag1, c1, 1, 17, 1, 2, 1, 1, 1.0, -1.0, new Insets(0, 5, 0, 20));
        this.createSubPanel00();
        this.addComponent((Component)this.subpanel00, (Container)this.panel0, gridBag1, c1, 1, 17, 0, 3, 2, 1, 1.0, -1.0, new Insets(10, 0, 10, 20));
    }

    private void createSubPanel00() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.subpanel00 = new LWContainer();
        this.subpanel00.setLayout((LayoutManager)gridBag1);
        this.subpanel00.setBorderPainter(UIManager.createGroupBoxPainter((String)this.getSubTitle0()));
        this.addComponent((Component)this.checkbox0, (Container)this.subpanel00, gridBag1, c1, 2, 17, 0, 0, 1, 1, 0.3, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.checkbox1, (Container)this.subpanel00, gridBag1, c1, 2, 17, 1, 0, 1, 1, 0.3, 1.0, new Insets(0, 40, 0, 0));
        this.addComponent((Component)this.checkbox2, (Container)this.subpanel00, gridBag1, c1, 2, 17, 2, 0, 1, 1, 0.3, 1.0, new Insets(0, 30, 0, 10));
    }

    private void createPanel1() {
        this.panel1 = new LWContainer();
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.panel1.setLayout((LayoutManager)gridBag1);
        this.panel1.setBorderPainter(UIManager.createGroupBoxPainter((String)this.getSubTitle1()));
        this.addComponent((Component)this.label1, (Container)this.panel1, gridBag1, c1, 2, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.label1_0, (Container)this.panel1, gridBag1, c1, 2, 13, 2, 0, 1, 1, 1.0, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.label1_1, (Container)this.panel1, gridBag1, c1, 2, 17, 3, 0, 1, 1, 1.0, 1.0, new Insets(0, 5, 0, 0));
        this.addComponent((Component)this.label2, (Container)this.panel1, gridBag1, c1, 2, 17, 0, 1, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.label8, (Container)this.panel1, gridBag1, c1, 2, 17, 1, 1, 1, 1, 1.0, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.label2_0, (Container)this.panel1, gridBag1, c1, 2, 13, 2, 1, 1, 1, 1.0, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.label2_1, (Container)this.panel1, gridBag1, c1, 2, 17, 3, 1, 1, 1, 1.0, 1.0, new Insets(0, 5, 0, 0));
        this.addComponent((Component)this.label3, (Container)this.panel1, gridBag1, c1, 2, 17, 0, 2, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.label9, (Container)this.panel1, gridBag1, c1, 2, 17, 1, 2, 1, 1, 1.0, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.label3_0, (Container)this.panel1, gridBag1, c1, 2, 17, 2, 2, 0, 1, 1.0, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.label4, (Container)this.panel1, gridBag1, c1, 2, 13, 0, 3, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.label10, (Container)this.panel1, gridBag1, c1, 2, 17, 1, 3, 1, 1, 1.0, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.label4_0, (Container)this.panel1, gridBag1, c1, 2, 13, 2, 3, 1, 1, 1.0, 1.0, new Insets(0, 5, 0, 0));
        this.addComponent((Component)this.label4_1, (Container)this.panel1, gridBag1, c1, 2, 17, 3, 3, 1, 1, 1.0, 1.0, new Insets(0, 5, 0, 0));
        this.addComponent((Component)this.label5, (Container)this.panel1, gridBag1, c1, 2, 13, 0, 4, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.label11, (Container)this.panel1, gridBag1, c1, 2, 17, 1, 4, 1, 1, 1.0, 1.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.label5_0, (Container)this.panel1, gridBag1, c1, 2, 13, 2, 4, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.label5_1, (Container)this.panel1, gridBag1, c1, 2, 17, 3, 4, 1, 1, 1.0, 1.0, new Insets(0, 5, 0, 0));
        this.addComponent((Component)this.label6, (Container)this.panel1, gridBag1, c1, 2, 17, 0, 6, 1, 1, 1.0, 1.0, new Insets(3, 0, 0, 0));
        this.addComponent((Component)this.label6_0, (Container)this.panel1, gridBag1, c1, 2, 13, 1, 6, 0, 1, 1.0, 1.0, new Insets(3, 0, 0, 10));
        this.label1_0.setAlignment(2);
        this.label2_0.setAlignment(2);
        this.label4_0.setAlignment(2);
        this.label5_0.setAlignment(2);
        this.label6_0.setAlignment(2);
        this.subTitle0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 12));
        this.subTitle1.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 12));
        this.subTitle2.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 12));
        this.label1.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label1_0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label1_1.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label2.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label2_0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label2_1.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label3.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label3_0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label4.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label4_0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label4_1.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label5.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label5_0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label5_1.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label6.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 1, 10));
        this.label6_0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 1, 10));
        this.label7.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label8.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label9.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label10.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.label11.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        EwtComponent separatorComp0 = new EwtComponent();
        separatorComp0.setBorderPainter((BorderPainter)new SeparatorBorderPainter(FilledRectPainter.getPainter(), 0, false, 1));
        EwtComponent separatorComp1 = new EwtComponent();
        separatorComp1.setBorderPainter((BorderPainter)new SeparatorBorderPainter(FilledRectPainter.getPainter(), 0, false, 1));
        this.addComponent((Component)separatorComp0, (Container)this.panel1, gridBag1, c1, 2, 15, 1, 1, 0, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)separatorComp1, (Container)this.panel1, gridBag1, c1, 1, 15, 0, 5, 0, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
    }

    private void createPanel2() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.panel2 = new LWContainer();
        this.panel2.setLayout((LayoutManager)gridBag1);
        this.panel2.setBorderPainter(UIManager.createGroupBoxPainter((String)this.getSubTitle2()));
        this.header = new ArrayOneDDataSource((Object[])DEF_COL_HEADERS);
        this.data = new SortableTwoDDataSource(4, 0);
        this.sTable = new DisableRowSpreadTable((TwoDDataSource)this.data, this.header, null);
        this.sTable.setColumnWidth(0, S_SELECT_COLWIDTH);
        this.sTable.setColumnWidth(1, S_DISKPATH_COLWIDTH);
        this.sTable.setColumnWidth(2, S_SIZE_COLWIDTH);
        this.sTable.setColumnWidth(3, S_STATUS_COLWIDTH);
        this.sTable.setHorizontalSeparatorsVisible(true);
        this.sTable.setVerticalSeparatorsVisible(true);
        Grid grid = this.sTable.getGrid();
        grid.setGridSelection((GridSelection)new SingleRowSelection());
        grid.setColumnPainter(0, CheckPainter.getPainter());
        grid.setColumnCellInputHandler(0, ReadOnlyBooleanInputHandler.getCellInputHandler());
        grid.setToolTipValue((ToolTipClient)new CustomToolTipClient());
        grid.addEditListener((GridEditListener)this);
        grid.addRowSelectListener((GridRowSelectListener)this);
        Header h = this.sTable.getColumnHeader();
        h.setCanMoveItems(false);
        h.setHeaderSelection(NullItemSelection.getHeaderSelection());
        h.setHeaderKeyHandler((HeaderKeyHandler)new KeyHandler());
        h.setItemInputHandler((HeaderItemInputHandler)new SortInputHandler(this.data));
        this.tableScroll = new ScrollBox((Component)((Object)this.sTable), 0, 0);
        this.addComponent((Component)this.checkbox3, (Container)this.panel2, gridBag1, c1, 0, 17, 0, 0, 1, 1, 0.0, 0.0, new Insets(0, 5, 0, 0));
        this.addComponent((Component)this.checkbox4, (Container)this.panel2, gridBag1, c1, 0, 17, 1, 0, 1, 1, 0.0, 0.0, new Insets(0, 10, 0, 0));
        this.addComponent((Component)this.tableScroll, (Container)this.panel2, gridBag1, c1, 1, 17, 0, 1, 0, 1, 1.0, 1.5, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.button1, (Container)this.panel2, gridBag1, c1, 0, 13, 0, 3, 1, 1, 1.0, 0.1, new Insets(0, 0, 5, 0));
        this.addComponent((Component)this.button0, (Container)this.panel2, gridBag1, c1, 0, 13, 1, 3, 1, 1, 0.0, 0.1, new Insets(0, 0, 5, 0));
    }

    public void setPrompt0(String text) {
        if (text != null) {
            this.prompt0.setText(text);
        }
    }

    public String getPrompt0() {
        return this.prompt0.getText();
    }

    public void setPrompt1(String text) {
        if (text != null) {
            this.prompt1.setText(text);
        }
    }

    public String getPrompt1() {
        return this.prompt1.getText();
    }

    public void setSubTitle0(String text) {
        if (text != null) {
            this.subTitle0.setText(text);
            this.subpanel00.setBorderPainter(UIManager.createGroupBoxPainter((String)text));
            this.checkbox0.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox0.getLabel());
            this.checkbox1.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox1.getLabel());
            this.checkbox2.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox2.getLabel());
        }
    }

    public String getSubTitle0() {
        return this.subTitle0.getText();
    }

    public void setSubTitle1(String text) {
        if (text != null) {
            this.subTitle1.setText(text);
            this.panel1.setBorderPainter(UIManager.createGroupBoxPainter((String)text));
        }
    }

    public String getSubTitle1() {
        return this.subTitle1.getText();
    }

    public void setSubTitle2(String text) {
        if (text != null) {
            this.subTitle2.setText(text);
            this.panel2.setBorderPainter(UIManager.createGroupBoxPainter((String)text));
            this.checkbox3.getAccessibleContext().setAccessibleName(this.subTitle2.getText() + "\n" + this.checkbox3.getLabel());
            this.checkbox4.getAccessibleContext().setAccessibleName(this.subTitle2.getText() + "\n" + this.checkbox4.getLabel());
        }
    }

    public String getSubTitle2() {
        return this.subTitle2.getText();
    }

    public void setCheckBoxLabel0(String text) {
        if (text != null) {
            this.checkbox0.setLabel(text);
            this.checkbox0.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox0.getLabel());
        }
    }

    public String getCheckBoxLabel0() {
        return this.checkbox0.getLabel();
    }

    public void setCheckBoxLabel1(String text) {
        if (text != null) {
            this.checkbox1.setLabel(text);
            this.checkbox1.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox1.getLabel());
        }
    }

    public String getCheckBoxLabel1() {
        return this.checkbox1.getLabel();
    }

    public void setCheckBoxLabel2(String text) {
        if (text != null) {
            this.checkbox2.setLabel(text);
            this.checkbox2.getAccessibleContext().setAccessibleName(this.subTitle0.getText() + "\n" + this.checkbox2.getLabel());
        }
    }

    public String getCheckBoxLabel2() {
        return this.checkbox2.getLabel();
    }

    public void setCheckBoxLabel3(String text) {
        if (text != null) {
            this.checkbox3.setLabel(text);
            this.checkbox3.getAccessibleContext().setAccessibleName(this.subTitle2.getText() + "\n" + this.checkbox3.getLabel());
        }
    }

    public String getCheckBoxLabel3() {
        return this.checkbox3.getLabel();
    }

    public void setCheckBoxLabel4(String text) {
        if (text != null) {
            this.checkbox4.setLabel(text);
            this.checkbox4.getAccessibleContext().setAccessibleName(this.subTitle2.getText() + "\n" + this.checkbox4.getLabel());
        }
    }

    public String getCheckBoxLabel4() {
        return this.checkbox4.getLabel();
    }

    public void setLabel0(String text) {
        if (text != null) {
            this.label0.setText(text);
        }
    }

    public String getLabel0() {
        return this.label0.getText();
    }

    public void setLabel1(String text) {
        if (text != null) {
            this.label1.setText(text);
        }
    }

    public String getLabel1() {
        return this.label1.getText();
    }

    public void setLabel2(String text) {
        if (text != null) {
            this.label2.setText(text);
        }
    }

    public String getLabel2() {
        return this.label2.getText();
    }

    public void setLabel3(String text) {
        if (text != null) {
            this.label3.setText(text);
        }
    }

    public String getLabel3() {
        return this.label3.getText();
    }

    public void setLabel4(String text) {
        if (text != null) {
            this.label4.setText(text);
        }
    }

    public String getLabel4() {
        return this.label4.getText();
    }

    public void setLabel5(String text) {
        if (text != null) {
            this.label5.setText(text);
        }
    }

    public String getLabel5() {
        return this.label5.getText();
    }

    public void setLabel6(String text) {
        if (text != null) {
            this.label6.setText(text);
        }
    }

    public String getLabel6() {
        return this.label6.getText();
    }

    public void setLabel1_0(String text) {
        if (text != null) {
            this.label1_0.setText(text);
        }
        try {
            int dataFileStorage = Integer.parseInt(this.label1_0.getText());
            this.label2_0.setText(String.valueOf(dataFileStorage * 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLabel1_0() {
        return this.label1_0.getText();
    }

    public void setLabel2_0(String text) {
        if (text != null) {
            this.label2_0.setText(text);
        }
    }

    public String getLabel2_0() {
        return this.label2_0.getText();
    }

    public void setLabel3_0(String text) {
        if (text != null) {
            this.label3_0.setText(text);
        }
    }

    public String getLabel3_0() {
        return this.label3_0.getText();
    }

    public void setLabel4_0(String text) {
        if (text != null) {
            this.label4_0.setText(text);
        }
    }

    public String getLabel4_0() {
        return this.label4_0.getText();
    }

    public void setLabel5_0(String text) {
        if (text != null) {
            this.label5_0.setText(text);
        }
    }

    public String getLabel5_0() {
        return this.label5_0.getText();
    }

    public void setLabel6_0(String text) {
        if (text != null) {
            this.label6_0.setText(text);
        }
    }

    public String getLabel6_0() {
        return this.label6_0.getText();
    }

    public void setButtonLabel0(String text) {
        if (text != null) {
            this.button0.setLabel(text);
        }
    }

    public String getButtonLabel0() {
        return this.button0.getLabel();
    }

    public void setButtonLabel1(String text) {
        if (text != null) {
            this.button1.setLabel(text);
        }
    }

    public String getButtonLabel1() {
        return this.button1.getLabel();
    }

    public void setText0(String text) {
        if (text != null) {
            this.text0.setText(text.trim());
        }
    }

    public String getText0() {
        return this.text0.getText();
    }

    public void setCheckBoxValue0(boolean state) {
        this.checkbox0.setState(state);
    }

    public void setCheckBoxValue0(String text) {
        this.setCheckBoxValue0(text.equals("Y"));
    }

    public String getCheckBoxValue0() {
        return this.checkbox0.getState() ? "Y" : "N";
    }

    public void setCheckBoxValue1(boolean state) {
        this.checkbox1.setState(state);
    }

    public void setCheckBoxValue1(String text) {
        this.setCheckBoxValue1(text.equals("Y"));
    }

    public String getCheckBoxValue1() {
        return this.checkbox1.getState() ? "Y" : "N";
    }

    public void setCheckBoxValue2(boolean state) {
        this.checkbox2.setState(state);
    }

    public void setCheckBoxValue2(String text) {
        this.setCheckBoxValue2(text.equals("Y"));
    }

    public String getCheckBoxValue2() {
        return this.checkbox2.getState() ? "Y" : "N";
    }

    public void setShowCandidateDisks(Boolean bool) {
        this.checkbox3.setState(bool.booleanValue());
        this.checkbox4.setState(bool == false);
        if (this.getShowCandidateDisks().booleanValue()) {
            this.mstrArrCandidateDisks = this.getSelectable();
            this.mstrArrAllDisks = this.getDiskArray(this.diskDiscoveryString, false);
        } else {
            this.mstrArrAllDisks = this.getSelectable();
            this.mstrArrCandidateDisks = this.getDiskArray(this.diskDiscoveryString, true);
        }
    }

    public Boolean getShowCandidateDisks() {
        return new Boolean(this.checkbox3.getState());
    }

    public void setAllowDiskGroupCreation(boolean bool) {
        this.allowDiskGroupCreation = bool;
        this.checkbox0.setEnabled(bool);
        this.checkbox1.setEnabled(bool);
        this.checkbox2.setEnabled(bool);
        this.text0.setEnabled(bool);
    }

    public void setAllowDiskGroupCreation(String text) {
        this.setAllowDiskGroupCreation(text.equals("Y"));
    }

    public String getAllowDiskGroupCreation() {
        return this.allowDiskGroupCreation ? "Y" : "N";
    }

    public void setDiskDiscoveryString(String text) {
        this.diskDiscoveryString = text;
    }

    public String getDiskDiscoveryString() {
        return this.diskDiscoveryString;
    }

    public void setSelectable(String[] list) {
        this.invalidate();
        this.vecSelectable.removeAllElements();
        this.data.removeRows(0, this.data.getRowCount());
        int rows = list.length / 3;
        int listIdx = 0;
        this.data.addRows(0, rows);
        for (int rowIdx = 0; rowIdx < rows; ++rowIdx) {
            for (int colIdx = 1; colIdx < this.data.getColumnCount(); ++colIdx) {
                this.data.setData(colIdx, rowIdx, (Object)list[listIdx++]);
            }
            this.data.setData(0, rowIdx, (Object)new Boolean(false));
        }
        this.sTable.setDataSources((TwoDDataSource)this.data, (OneDDataSource)this.header, null);
        for (int i = 0; i < list.length; ++i) {
            this.vecSelectable.addElement(list[i]);
        }
        this.validate();
    }

    public String[] getSelectable() {
        int size = this.vecSelectable.size();
        String[] strArray = new String[size];
        for (int i = 0; i < size; ++i) {
            strArray[i] = (String)this.vecSelectable.elementAt(i);
        }
        return strArray;
    }

    public Integer getSelectedOption() {
        if (this.checkbox0.getState()) {
            return new Integer(3);
        }
        if (this.checkbox1.getState()) {
            return new Integer(2);
        }
        if (this.checkbox2.getState()) {
            return new Integer(1);
        }
        return new Integer(2);
    }

    public void setSelectedOption(Integer sequence) {
        if (sequence != null) {
            if (sequence == 3) {
                this.checkbox0.setState(true);
            } else if (sequence == 2) {
                this.checkbox1.setState(true);
            } else if (sequence == 1) {
                this.checkbox2.setState(true);
            }
        }
    }

    public void setASMOnlyInstall(Boolean state) {
        if (state.booleanValue()) {
            this.panel1.setBorderPainter(null);
            this.panel1.removeAll();
        }
    }

    public void setSelections(String[] answer) {
        if (answer.length != 0) {
            block0: for (int ansIdx = 0; ansIdx < answer.length; ansIdx += 2) {
                for (int rowIdx = 0; rowIdx < this.data.getRowCount(); ++rowIdx) {
                    if (!answer[ansIdx].equalsIgnoreCase((String)this.data.getData(1, rowIdx))) continue;
                    this.data.setData(0, rowIdx, (Object)new Boolean(true));
                    continue block0;
                }
            }
        }
    }

    public String[] getSelections() {
        int cellIdx;
        int selIdx = 0;
        for (cellIdx = 0; cellIdx < this.data.getRowCount(); ++cellIdx) {
            if (!((Boolean)this.data.getData(0, cellIdx)).booleanValue()) continue;
            ++selIdx;
        }
        String[] selections = new String[selIdx * 2];
        selIdx = 0;
        for (cellIdx = 0; cellIdx < this.data.getRowCount(); ++cellIdx) {
            if (!((Boolean)this.data.getData(0, cellIdx)).booleanValue()) continue;
            selections[selIdx++] = (String)this.data.getData(1, cellIdx);
            selections[selIdx++] = (String)this.data.getData(2, cellIdx);
        }
        return selections;
    }

    public void setWindowsPlatform(Boolean bool) {
        this.windowsPlatform = bool;
        if (!this.windowsPlatform) {
            this.button1.setVisible(false);
        }
    }

    public Boolean getWindowsPlatform() {
        return new Boolean(this.windowsPlatform);
    }

    private int calculateAdditionalSpace() {
        int dataFileStorage = 0;
        int recoveryAreaStorage = 0;
        int redundancy = 2;
        int existingFreeSpace = 0;
        int sizeOfNewDisks = 0;
        try {
            dataFileStorage = Integer.parseInt(this.label1_0.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            recoveryAreaStorage = Integer.parseInt(this.label2_0.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.checkbox0.getState()) {
            redundancy = 3;
        } else if (this.checkbox1.getState()) {
            redundancy = 2;
        } else if (this.checkbox2.getState()) {
            redundancy = 1;
        }
        try {
            existingFreeSpace = Integer.parseInt(this.label4_0.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            sizeOfNewDisks = Integer.parseInt(this.label5_0.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int size = (dataFileStorage + recoveryAreaStorage) * redundancy - existingFreeSpace - sizeOfNewDisks;
        if (size <= 0) {
            return 0;
        }
        return size;
    }

    private String[] getDiskArray(String strDiskString, boolean candidateDisksOnly) {
        GetASMDisks objGAD = new GetASMDisks();
        String[] strArrDisks = null;
        try {
            strArrDisks = (String[])objGAD.performQuery(strDiskString, candidateDisksOnly);
        }
        catch (Exception q) {
            System.out.println(q.getMessage());
        }
        return strArrDisks;
    }

    public void actionPerformed(ActionEvent e) {
        if (EventQueue.getMostRecentEventTime() > this.time1) {
            if (e.getSource() == this.button0) {
                Point pt = this.mainPanel.getLocation();
                int top = (int)pt.getY();
                int left = (int)pt.getX();
                Object c = this;
                while (!(c instanceof Frame)) {
                    c = ((Component)c).getParent();
                }
                OiASMDiskString objASMDiskString = new OiASMDiskString((Frame)c, top + 30, left + 100, this.diskDiscoveryString);
                objASMDiskString.display();
                String strDiskString = objASMDiskString.getText0();
                objASMDiskString.dispose();
                if (!strDiskString.trim().equals("") && strDiskString != this.diskDiscoveryString) {
                    this.mstrArrCandidateDisks = this.getDiskArray(strDiskString, true);
                    this.mstrArrAllDisks = this.getDiskArray(strDiskString, false);
                    if (this.getShowCandidateDisks().booleanValue()) {
                        this.setSelectable(this.mstrArrCandidateDisks);
                    } else {
                        this.setSelectable(this.mstrArrAllDisks);
                    }
                    this.label5_0.setText("0");
                    this.label6_0.setText(String.valueOf(this.calculateAdditionalSpace()) + " " + DEFAULT_LABEL_7);
                }
                this.diskDiscoveryString = strDiskString;
            } else if (e.getSource() == this.button1) {
                try {
                    if (!this.processSpawnedForStampDisks) {
                        String pathname = System.getProperty("oracle.installer.NatLibDir") + File.separator;
                        Runtime obj = Runtime.getRuntime();
                        String libpath = System.getProperty("oracle.installer.library_loc");
                        String[] envp = new String[]{"path=" + libpath};
                        Process objProcess = obj.exec(pathname + "asmtoolg.exe", envp);
                        while (objProcess.waitFor() != 0) {
                        }
                        this.time1 = new Date().getTime();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                this.mstrArrCandidateDisks = this.getDiskArray("", true);
                this.mstrArrAllDisks = this.getDiskArray("", false);
                if (this.getShowCandidateDisks().booleanValue()) {
                    this.setSelectable(this.mstrArrCandidateDisks);
                } else {
                    this.setSelectable(this.mstrArrAllDisks);
                }
                this.label5_0.setText("0");
                this.label6_0.setText(String.valueOf(this.calculateAdditionalSpace()) + " " + DEFAULT_LABEL_7);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.checkbox0) {
                this.label3_0.setText(HIGH_REDUNDANCY_VALUE);
            } else if (e.getSource() == this.checkbox1) {
                this.label3_0.setText(NORMAL_REDUNDANCY_VALUE);
            } else if (e.getSource() == this.checkbox2) {
                this.label3_0.setText(EXTERNAL_REDUNDANCY_VALUE);
            }
            if (e.getSource() == this.checkbox3) {
                String[] strtemp = this.getSelections();
                this.setSelectable(this.mstrArrCandidateDisks);
                this.setSelections(strtemp);
            } else if (e.getSource() == this.checkbox4) {
                String[] strtemp = this.getSelections();
                this.setSelectable(this.mstrArrAllDisks);
                this.setSelections(strtemp);
            }
        }
        this.label6_0.setText(String.valueOf(this.calculateAdditionalSpace()) + " " + DEFAULT_LABEL_7);
    }

    public void cellEditing(GridEvent e) {
        int selectedRow = e.getRow();
        DisableRowGrid drg = (DisableRowGrid)this.sTable.getGrid();
        if (drg.isRowDisabled(selectedRow) && e instanceof Cancelable) {
            ((Cancelable)e).cancel();
            return;
        }
    }

    public void cellEdited(GridEvent e) {
        if (e.getColumn() == 0) {
            int selectedRow = e.getRow();
            String strSize = (String)this.data.getData(2, selectedRow);
            int size = Integer.parseInt(strSize);
            if (!((Boolean)this.data.getData(0, selectedRow)).booleanValue()) {
                size *= -1;
            }
            try {
                int newSize = Integer.parseInt(this.label5_0.getText()) + size;
                this.label5_0.setText(String.valueOf(newSize));
                this.label6_0.setText(String.valueOf(this.calculateAdditionalSpace()) + " " + DEFAULT_LABEL_7);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    public void rowSelecting(GridEvent e) {
        int selectedRow = e.getRow();
        DisableRowGrid drg = (DisableRowGrid)this.sTable.getGrid();
        if (drg.isRowDisabled(selectedRow) && e instanceof Cancelable) {
            ((Cancelable)e).cancel();
            return;
        }
    }

    public void rowDeselecting(GridEvent e) {
    }

    public void rowDeselected(GridEvent e) {
    }

    public void rowSelected(GridEvent e) {
    }

    private void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    public static void main(String[] args) {
        BufferedFrame p = new BufferedFrame();
        ASMConfiguration obj = new ASMConfiguration();
        String[] str = new String[]{"123", "234", "CANDIDATE", "1234", "4356", "MEMBER", "34q543", "45324", "FOREIGN"};
        String[] selectedStr = new String[]{"123", "234"};
        obj.setSelectable(str);
        obj.setSelections(selectedStr);
        obj.setASMOnlyInstall(new Boolean(false));
        obj.setWindowsPlatform(new Boolean(true));
        p.add((Component)((Object)obj));
        p.setSize(630, 400);
        p.show();
    }

    public class SortInputHandler
    implements HeaderItemInputHandler {
        private SortableTwoDDataSource _ds;
        private int _item = -1;
        private boolean _inside;
        private boolean[] _order;

        public SortInputHandler(SortableTwoDDataSource ds) {
            this._ds = ds;
            this._order = new boolean[ds.getColumnCount()];
        }

        public void sort(int index) {
            boolean order = this._order[index];
            this._ds.sort(index, order);
            this._order[index] = !order;
            for (int i = 0; i < this._ds.getRowCount(); ++i) {
                Boolean bool = (Boolean)this._ds.getData(0, i);
                if (!bool.booleanValue()) continue;
                ASMConfiguration.this.sTable.getGrid().getGridSelection().setRowSelected(i, true);
                break;
            }
        }

        public void mousePressed(MouseEvent e, Header header, int itemIndex) {
            this._inside = true;
            this._item = itemIndex;
        }

        public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
        }

        public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
        }

        public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
            if (this._item == -1) {
                return;
            }
            if (this._inside && this._item == itemIndex) {
                this.sort(itemIndex);
            }
            this._item = -1;
        }

        public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
            if (itemIndex == this._item) {
                this._inside = true;
            }
        }

        public void mouseExited(MouseEvent e, Header header, int itemIndex) {
            if (itemIndex == this._item) {
                this._inside = false;
            }
        }

        public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent e) {
            if (e.getID() == 402 && e.getKeyCode() == 32) {
                SortInputHandler h = (SortInputHandler)header.getItemInputHandler();
                h.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, e);
            int selectedRow = 0;
            for (int i = 0; i < ASMConfiguration.this.data.getRowCount(); ++i) {
                Boolean bool = (Boolean)ASMConfiguration.this.data.getData(0, i);
                if (!bool.booleanValue()) continue;
                selectedRow = i;
                break;
            }
            ASMConfiguration.this.sTable.getGrid().getGridSelection().setRowSelected(selectedRow, true);
        }
    }

    private class CustomToolTipClient
    extends GridToolTipClient {
        private CustomToolTipClient() {
        }

        protected Object getCellToolTipValue(Grid grid, int column, int row) {
            return grid.getDataSource().getData(column, row);
        }

        protected boolean shouldDisplay(Grid grid, int column, int row) {
            return column != 0;
        }
    }

    private class DisableRowGrid
    extends Grid {
        public DisableRowGrid(TwoDDataSource ds) {
            super(ds);
        }

        protected int getCellPaintState(int baseState, int column, int row) {
            if (this.isRowDisabled(row)) {
                baseState |= 1;
            }
            return baseState;
        }

        boolean isRowDisabled(int row) {
            String upgradable = (String)this.getDataSource().getData(3, row);
            return !upgradable.equalsIgnoreCase("CANDIDATE");
        }
    }

    public class DisableRowSpreadTable
    extends SpreadTable {
        public DisableRowSpreadTable(TwoDDataSource a, ArrayOneDDataSource b, ArrayOneDDataSource c) {
            super(a, (OneDDataSource)b, (OneDDataSource)c);
        }

        protected Grid createGrid(TwoDDataSource ds) {
            return new DisableRowGrid(ds);
        }
    }
}

