/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class DisplayNodes
extends OiifpWizPanel
implements ItemListener,
ActionListener {
    private static final String NODELABEL = "Select the nodes which will be a part of this Oracle Parallel Server Database:";
    private static final String ADDLABEL = "Enter additional nodes: ";
    private static final String NODELISTLABEL = "Nodes: ";
    private static final int LEFT_PADDING = 10;
    private static final int RIGHT_PADDING = 10;
    private static final int CONTROL_SPACE = 7;
    private LWList nodeList;
    private MultiLineLabel nodeLabel;
    private MultiLineLabel addLabel;
    private LWTextField addEdit;
    private Button addButton;
    private Button remButton;
    private MultiLineLabel nodeListLabel;
    private Color nodeLabelColor;

    public DisplayNodes() {
        this("");
        String hostname = "";
        try {
            InetAddress hostAddr = InetAddress.getLocalHost();
            hostname = hostAddr.getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "localhost";
        }
        String[] tmp = new String[]{hostname};
        this.setNodeList(tmp);
    }

    public DisplayNodes(String promptString) {
        super("Title");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.mainPanel.setLayout((LayoutManager)gbl);
        this.nodeLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), NODELABEL);
        this.AddComponent((Component)this.nodeLabel, (Container)this.mainPanel, gbl, gbc, 1, 16, -1, -1, 0, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        this.addLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), ADDLABEL);
        this.AddComponent((Component)this.addLabel, (Container)this.mainPanel, gbl, gbc, 3, 18, -1, -1, 1, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.addEdit = new LWTextField();
        this.AddComponent((Component)this.addEdit, (Container)this.mainPanel, gbl, gbc, 2, 18, -1, -1, 1, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        this.addButton = new Button("Add");
        this.addButton.addActionListener(this);
        this.AddComponent(this.addButton, (Container)this.mainPanel, gbl, gbc, 0, 18, -1, -1, 0, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeListLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), NODELISTLABEL);
        this.AddComponent((Component)this.nodeListLabel, (Container)this.mainPanel, gbl, gbc, 3, 18, -1, -1, 1, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeList = new LWList();
        this.nodeList.setMultipleMode(true);
        this.AddComponent((Component)this.nodeList, (Container)this.mainPanel, gbl, gbc, 1, 18, -1, -1, 1, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeList.addItemListener((ItemListener)this);
        LWLabel dummy1 = new LWLabel("");
        this.AddComponent((Component)dummy1, (Container)this.mainPanel, gbl, gbc, 0, 18, -1, -1, 0, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        LWLabel dummy2 = new LWLabel("");
        this.AddComponent((Component)dummy2, (Container)this.mainPanel, gbl, gbc, 0, 18, -1, -1, 1, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.remButton = new Button("Remove");
        this.remButton.addActionListener(this);
        this.AddComponent(this.remButton, (Container)this.mainPanel, gbl, gbc, 0, 17, -1, -1, 1, 1, 1.0, 0.0, new Insets(0, 10, 7, 10));
        LWLabel dummy3 = new LWLabel("");
        this.AddComponent((Component)dummy3, (Container)this.mainPanel, gbl, gbc, 0, 18, -1, -1, 0, 1, 0.0, 0.0, new Insets(0, 10, 7, 10));
        this.nodeLabelColor = this.nodeLabel.getBackground();
    }

    private void AddComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    private void EnableControls(boolean bEnable) {
        this.nodeListLabel.setEnabled(bEnable);
        this.nodeList.setEnabled(bEnable);
    }

    private void UpdatenodeListBox() {
        if (this.nodeList.getItemCount() == 0) {
            this.EnableControls(false);
        } else {
            this.EnableControls(true);
        }
    }

    public void setPrompt(String text) {
        if (text != null) {
            this.nodeLabel.setText(text);
        }
    }

    public void setAddPrompt(String text) {
        if (text != null) {
            this.addLabel.setText(text);
        }
    }

    public void setNodePrompt(String text) {
        if (text != null) {
            this.nodeListLabel.setText(text);
        }
    }

    public void setNodeList(String[] text) {
        this.invalidate();
        this.nodeList.removeAll();
        for (int x = 0; x < text.length; ++x) {
            this.nodeList.add(text[x]);
        }
        this.validate();
    }

    public String[] getNodeList() {
        return this.nodeList.getItems();
    }

    public void markPrompt() {
        this.nodeLabel.setBackground(this._markColor);
    }

    public void unmarkPrompt() {
        this.nodeLabel.setBackground(this.nodeLabelColor);
    }

    public void markAddPrompt() {
        this.addLabel.setBackground(this._markColor);
    }

    public void unmarkAddPrompt() {
        this.addLabel.setBackground(this.nodeLabelColor);
    }

    public void markNodePrompt() {
        this.nodeListLabel.setBackground(this._markColor);
    }

    public void unmarkNodePrompt() {
        this.nodeListLabel.setBackground(this.nodeLabelColor);
    }

    public void markNodeList() {
        this.nodeList.setBackground(this._markColor);
    }

    public void unmarkNodeList() {
        this.nodeList.setBackground(this.nodeLabelColor);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2 && !this.nodeList.isIndexSelected(0)) {
            this.UpdatenodeListBox();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addButton) {
            String nodename = this.addEdit.getText();
            if (nodename.trim().compareTo("") != 0) {
                this.nodeList.add(nodename);
                this.addEdit.setText("");
            }
        } else if (source == this.remButton) {
            try {
                String[] selection = this.nodeList.getSelectedItems();
                for (int idx = 0; idx < selection.length; ++idx) {
                    this.nodeList.remove(selection[idx]);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.UpdatenodeListBox();
    }
}

