/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmInfo;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiCharSet
extends OiifpWizPanel
implements ItemListener {
    private static final String DEFAULT_TITLE = "Title";
    private static final String DEFAULT_PROMPT = "Prompt";
    private static final String[] DEFAULT_RCHOICES = new String[]{"US7ASCII", "Its the default character set for your database", "with UTF8", "to have multiple language groups", "With other characterset", ""};
    private static final String[] DEFAULT_CCHOICES = new String[]{"WEIOMSWIN", "WEIOP"};
    private static final String DEFAULT_LABEL = "Label";
    private static final int INSETS = 2;
    private OiifmInfo[] m_choices;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private MultiLineLabel prompt0;
    private LWCheckbox[] m_radio;
    private LWCheckboxGroup m_radioButtonGroup;
    private LWChoice myChoice;
    public LWContainer m_selectPanel;
    private ItemListener m_itemListener;

    public OiCharSet() {
        this(DEFAULT_PROMPT);
        this.setTitleLabel(DEFAULT_TITLE);
        this.setChoices(DEFAULT_RCHOICES);
        this.setCharChoices(DEFAULT_CCHOICES);
        this.validate();
    }

    public OiCharSet(String promptString) {
        super(DEFAULT_TITLE);
        this.prompt0 = new MultiLineLabel(WordWrapper.getTextWrapper(), promptString);
        GridBagLayout mgridbag = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)mgridbag);
        GridBagConstraints mc = new GridBagConstraints();
        mc.fill = 1;
        this.mainPanel.setLayout((LayoutManager)mgridbag);
        mc.gridx = 0;
        mc.weightx = 1.0;
        mc.weighty = 0.6;
        mc.anchor = 18;
        mc.gridwidth = 0;
        mgridbag.setConstraints((Component)this.prompt0, mc);
        this.mainPanel.add((Component)this.prompt0);
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.m_selectPanel = new LWContainer();
        this.c.fill = -1;
        this.c.anchor = 18;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.m_selectPanel.setLayout((LayoutManager)this.gridbag);
        this.m_selectPanel.setSize(100, 100);
        mc.gridwidth = 0;
        mc.insets = new Insets(0, 0, 10, 0);
        mc.fill = 1;
        mc.gridy = -1;
        mc.weightx = 0.1;
        mc.weighty = 0.2;
        mgridbag.setConstraints((Component)this.m_selectPanel, mc);
        this.mainPanel.add((Component)this.m_selectPanel);
        this.m_itemListener = null;
        this.validate();
    }

    private void addRadioButtons() {
        TextWrapper twrap = WordWrapper.getTextWrapper();
        Font smallfont = new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 0, 11);
        Font bigfont = new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 0, 14);
        this.c.anchor = 18;
        this.c.fill = 1;
        this.c.insets.top = 2;
        this.c.insets.left = 0;
        this.c.insets.bottom = 2;
        int size = this.m_choices.length;
        this.m_radioButtonGroup = new LWCheckboxGroup();
        this.m_radio = new LWCheckbox[size];
        for (int i = 0; i < size; ++i) {
            String cname = this.m_choices[i].getDisplayName();
            String d = this.m_choices[i].desc == null ? "" : this.m_choices[i].desc.trim();
            this.m_radio[i] = new LWCheckbox(cname, this.m_radioButtonGroup, false);
            this.m_radio[i].setFont(bigfont);
            new LWLabel(cname + "\n" + d).setLabelFor((Component)this.m_radio[i]);
            this.c.insets.top = 2;
            this.c.insets.left = 0;
            this.c.insets.bottom = 2;
            this.c.weighty = 0.0;
            this.gridbag.setConstraints((Component)this.m_radio[i], this.c);
            this.m_radio[i].addItemListener((ItemListener)this);
            this.m_selectPanel.add((Component)this.m_radio[i]);
            if (d.length() <= 0) continue;
            this.c.weightx = 0.1;
            this.c.insets.top = 0;
            this.c.insets.left = 16;
            this.c.insets.bottom = 4;
            this.c.weighty = i == 0 ? 1.0 : 0.4;
            this.c.gridwidth = 0;
            NonJAWSReadableMultiLineLabel mulLabel = new NonJAWSReadableMultiLineLabel(WordWrapper.getTextWrapper(), d);
            mulLabel.setPreferredAspectRatio(0.0f);
            mulLabel.setFont(smallfont);
            this.gridbag.setConstraints((Component)((Object)mulLabel), this.c);
            this.m_selectPanel.add((Component)((Object)mulLabel));
        }
        this.c.fill = 0;
        this.c.insets.top = 8;
        this.c.insets.left = 8;
        this.c.insets.bottom = 0;
        this.c.weightx = 0.0;
        this.c.weighty = 0.4;
        this.myChoice = new LWChoice();
        this.gridbag.setConstraints((Component)this.myChoice, this.c);
        this.m_selectPanel.add((Component)this.myChoice);
        this.setSelection(0);
    }

    private void removeChoices() {
        if (this.m_selectPanel != null) {
            Component[] clist = this.m_selectPanel.getComponents();
            for (int i = 0; i < clist.length; ++i) {
                this.m_selectPanel.remove(clist[i]);
            }
            this.m_choices = null;
        }
    }

    public void setPrompt(String text) {
        if (text != null) {
            this.prompt0.setText(text);
        }
    }

    public void setChoices(String[] choices) {
        this.removeChoices();
        this.setCompInfo(choices);
        if (choices != null) {
            this.addRadioButtons();
        }
    }

    public void setCompInfo(String[] list) {
        int rows = list.length / 2;
        this.m_choices = new OiifmInfo[rows];
        for (int rowIdx = 0; rowIdx < rows; ++rowIdx) {
            this.m_choices[rowIdx] = new OiifmInfo();
            this.m_choices[rowIdx].name = list[rowIdx * 2];
            this.m_choices[rowIdx].desc = list[rowIdx * 2 + 1];
        }
    }

    public void setCharChoices(String[] list) {
        this.invalidate();
        this.myChoice.removeAll();
        for (int i = 0; i < list.length; ++i) {
            this.myChoice.insert(list[i], i);
        }
        this.myChoice.select(this.myChoice.getItem(0));
        this.validate();
    }

    public String getSelection() {
        if (this.m_radio != null) {
            return this.m_radioButtonGroup.getSelectedCheckbox().getLabel();
        }
        return null;
    }

    public void setSelection(String selString) {
        int index = 0;
        if (this.m_radio != null) {
            for (int i = 0; i < this.m_radio.length; ++i) {
                if (!this.m_radio[i].getLabel().equals(selString)) continue;
                index = i;
                break;
            }
        }
        this.setSelection(index);
    }

    public void setSelection(int index) {
        if (this.m_radio != null && this.m_radio.length > index) {
            this.m_radioButtonGroup.setSelectedCheckbox(this.m_radio[index]);
        }
        if (index == this.m_radio.length - 1) {
            this.myChoice.setEnabled(true);
        } else {
            this.myChoice.setEnabled(false);
        }
    }

    public void setCharSelection(String text) {
        if (text != null) {
            this.myChoice.select(text);
        }
    }

    public String getCharSelection() {
        return this.myChoice.getSelectedItem();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_itemListener = listener;
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            String r_label = event.getItem().toString();
            if (r_label.equalsIgnoreCase(this.m_choices[this.m_choices.length - 1].name)) {
                this.myChoice.setEnabled(true);
            } else {
                this.myChoice.setEnabled(false);
            }
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        OiCharSet panel1 = new OiCharSet();
        f.add((Component)((Object)panel1));
        f.resize(600, 400);
        f.show();
    }
}

