/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class OiCharacterSet
extends OiifpWizPanel
implements ItemListener {
    private static final String DEFAULT_TITLE = "Title";
    private static final String DEFAULT_PROMPT = "Prompt";
    private static final String[] DEFAULT_RCHOICES = new String[]{"Do you wish US7ASCII hff sdfksdfsd fsdkfsdf dsfklsdfnsd fsdkfsdf sdfksdf sdfksdf sdfksdfsd fsdfjhsdf sdfksdhfjsda fsdkfhsdkjf", "with UTF8", "With other characterset"};
    private static final String[] DEFAULT_CCHOICES = new String[]{"WEIOMSWIN", "WEIOP"};
    private static final String DEFAULT_LABEL = "Label";
    private String[] m_choices;
    private int n_size;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private MultiLineLabel prompt0;
    private LWCheckbox[] m_radio;
    private LWCheckboxGroup m_radioButtonGroup;
    private LWChoice myChoice;
    public LWContainer m_selectPanel;
    private ItemListener m_itemListener;

    public OiCharacterSet() {
        this(DEFAULT_PROMPT);
        this.setTitleLabel(DEFAULT_TITLE);
        this.setChoices(DEFAULT_RCHOICES);
        this.setCharChoices(DEFAULT_CCHOICES);
        this.validate();
    }

    public OiCharacterSet(String promptString) {
        super(DEFAULT_TITLE);
        this.prompt0 = new MultiLineLabel(WordWrapper.getTextWrapper(), promptString);
        this.mainPanel.add((Component)this.prompt0, (Object)"North");
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.m_selectPanel = new LWContainer();
        this.c.fill = -1;
        this.c.anchor = 18;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.m_selectPanel.setLayout((LayoutManager)this.gridbag);
        this.m_selectPanel.setSize(50, 50);
        this.mainPanel.add((Component)this.m_selectPanel, (Object)"Center");
        this.m_itemListener = null;
        this.validate();
    }

    private void addRadioButtons() {
        this.m_radioButtonGroup = new LWCheckboxGroup();
        this.c.weightx = 1.0;
        this.c.weighty = 0.1;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 0;
        this.m_radio = new LWCheckbox[this.n_size];
        for (int i = 0; i < this.n_size; ++i) {
            String cname = this.m_choices[i];
            this.m_radio[i] = new LWCheckbox(cname, this.m_radioButtonGroup, false);
            this.gridbag.setConstraints((Component)this.m_radio[i], this.c);
            this.m_radio[i].addItemListener((ItemListener)this);
            this.m_selectPanel.add((Component)this.m_radio[i]);
            this.c.gridy = i + 2;
        }
        this.myChoice = new LWChoice();
        ++this.c.gridy;
        this.gridbag.setConstraints((Component)this.myChoice, this.c);
        this.m_selectPanel.add((Component)this.myChoice);
        this.setSelection(0);
    }

    private void removeChoices() {
        if (this.m_selectPanel != null) {
            Component[] clist = this.m_selectPanel.getComponents();
            for (int i = 0; i < clist.length; ++i) {
                this.m_selectPanel.remove(clist[i]);
            }
            this.m_choices = null;
        }
    }

    public void setPrompt(String text) {
        if (text != null) {
            this.prompt0.setText(text);
        }
    }

    public void setChoices(String[] choices) {
        this.n_size = choices.length;
        this.removeChoices();
        this.m_choices = choices;
        if (this.m_choices != null) {
            this.addRadioButtons();
        }
    }

    public void setCharChoices(String[] list) {
        this.invalidate();
        this.myChoice.removeAll();
        for (int i = 0; i < list.length; ++i) {
            this.myChoice.insert(list[i], i);
        }
        this.myChoice.select(this.myChoice.getItem(0));
        this.validate();
    }

    public String getSelection() {
        if (this.m_radio != null) {
            return this.m_radioButtonGroup.getSelectedCheckbox().getLabel();
        }
        return null;
    }

    public void setSelection(String selString) {
        int index = 0;
        if (this.m_radio != null) {
            for (int i = 0; i < this.m_radio.length; ++i) {
                if (!this.m_radio[i].getLabel().equals(selString)) continue;
                index = i;
                break;
            }
        }
        this.setSelection(index);
    }

    public void setSelection(int index) {
        if (this.m_radio != null && this.m_radio.length > index) {
            this.m_radioButtonGroup.setSelectedCheckbox(this.m_radio[index]);
        }
        if (index == this.n_size - 1) {
            this.myChoice.setEnabled(true);
        } else {
            this.myChoice.setEnabled(false);
        }
    }

    public void setCharSelection(String text) {
        if (text != null) {
            this.myChoice.select(text);
        }
    }

    public String getCharSelection() {
        return this.myChoice.getSelectedItem();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_itemListener = listener;
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            String r_label = event.getItem().toString();
            if (r_label.equalsIgnoreCase(this.m_choices[this.n_size - 1])) {
                this.myChoice.setEnabled(true);
            } else {
                this.myChoice.setEnabled(false);
            }
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        OiCharacterSet panel1 = new OiCharacterSet();
        f.add((Component)((Object)panel1));
        f.resize(600, 400);
        f.show();
    }
}

