/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmDummyPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiMultiSelPanel
extends OiifpWizPanel
implements ItemListener,
ActionListener {
    private static final int INSETS = 5;
    private static final int NUM_VISIBLE = 10;
    private static final int MAX_RADIO_ITEMS = 10;
    private LWContainer m_selectPanel;
    private MultiLineLabel m_textLabel;
    private LWCheckbox[] m_radio;
    private String[] m_choices;
    private ItemListener m_itemListener;
    private ActionListener m_actnListener;
    private PushButton m_infoButton;
    private GridBagConstraints c;
    private GridBagLayout gridbag;
    private static final int SOUTH_GAP = 50;
    private static final String DEFAULT_TITLE = "Title";
    private static final String DEFAULT_PROMPT = "Prompt";
    private static final String OPS = "Oracle 9i Real Application Clusters";
    private static final String RDBMS = "Oracle 9i Database";
    private static final String[] DEF_CONFIG = new String[]{"Oracle 9i Real Application Clusters", "Oracle 9i Database"};

    public OiMultiSelPanel() {
        this(DEFAULT_PROMPT);
        this.setTitleLabel(DEFAULT_TITLE);
        this.setPrompt(DEFAULT_PROMPT);
        this.setChoices(DEF_CONFIG);
        this.validate();
    }

    public OiMultiSelPanel(String promptString) {
        super(DEFAULT_TITLE);
        this.m_textLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), promptString);
        this.m_textLabel.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this.m_textLabel, (Object)"North");
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(5, 15, 5, 5);
        this.c.fill = 2;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.gridwidth = 0;
        this.m_selectPanel = new LWContainer();
        this.m_selectPanel.setLayout((LayoutManager)this.gridbag);
        this.m_selectPanel.setSize(20, 20);
        this.mainPanel.add((Component)this.m_selectPanel, (Object)"Center");
        OiifmDummyPanel dPanel = new OiifmDummyPanel(50, 50);
        this.mainPanel.add((Component)dPanel, (Object)"South");
        this.m_itemListener = null;
        this.m_actnListener = null;
        this.validate();
    }

    public void setChoices(String[] choices) {
        this.removeChoices();
        this.m_choices = choices;
        if (this.m_choices != null && this.m_choices.length <= 10) {
            this.addRadioButtons();
        }
    }

    private void addRadioButtons() {
        TextWrapper twrap = WordWrapper.getTextWrapper();
        Font smallfont = new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 0, 11);
        Font bigfont = new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 0, 14);
        int size = this.m_choices.length;
        this.c.anchor = 18;
        this.c.fill = 1;
        this.m_radio = new LWCheckbox[size];
        for (int i = 0; i < size; ++i) {
            String cname = this.m_choices[i];
            this.m_radio[i] = new LWCheckbox("  " + cname, false);
            this.m_radio[i].setFont(smallfont);
            this.gridbag.setConstraints((Component)this.m_radio[i], this.c);
            this.m_radio[i].addItemListener((ItemListener)this);
            this.m_selectPanel.add((Component)this.m_radio[i]);
            this.c.weighty = 0.0;
            this.c.insets.top = 5;
            this.c.insets.bottom = 5;
        }
    }

    private void removeChoices() {
        Component[] clist = this.m_selectPanel.getComponents();
        for (int i = 0; i < clist.length; ++i) {
            this.m_selectPanel.remove(clist[i]);
        }
        this.m_choices = null;
    }

    public String[] getChoices() {
        return this.m_choices;
    }

    public String[] getSelections() {
        String[] retNone = new String[]{"None"};
        if (this.m_radio != null) {
            int selIdx = 0;
            for (int i = 0; i < this.m_radio.length; ++i) {
                if (!this.m_radio[i].getState()) continue;
                ++selIdx;
            }
            if (selIdx == 0) {
                return retNone;
            }
            String[] retStr = new String[selIdx];
            int ridx = 0;
            for (int i = 0; i < this.m_radio.length; ++i) {
                if (!this.m_radio[i].getState()) continue;
                retStr[ridx++] = this.m_radio[i].getLabel().trim();
            }
            return retStr;
        }
        return retNone;
    }

    public void setSelections(String[] selList) {
        if (this.m_radio != null && selList != null) {
            for (int selIdx = 0; selIdx < selList.length; ++selIdx) {
                for (int i = 0; i < this.m_radio.length; ++i) {
                    if (!selList[selIdx].equals(this.m_radio[i].getLabel())) continue;
                    this.m_radio[i].setState(true);
                }
            }
        }
    }

    public String getPrompt() {
        return this.m_textLabel.getText();
    }

    public void setPrompt(String label) {
        this.m_textLabel.setText(label);
        this.invalidate();
        this.validate();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_itemListener = listener;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.m_actnListener = listener;
    }

    public void itemStateChanged(ItemEvent event) {
        block4: {
            block3: {
                if (event.getStateChange() != 1) break block3;
                if (!((LWCheckbox)event.getSource()).getLabel().equals("  Oracle 9i Real Application Clusters")) break block4;
                for (int i = 0; i < this.m_radio.length; ++i) {
                    if (!this.m_radio[i].getLabel().equals("  Oracle 9i Database")) continue;
                    this.m_radio[i].setState(true);
                    this.m_radio[i].setEnabled(false);
                }
                break block4;
            }
            if (((LWCheckbox)event.getSource()).getLabel().equals("  Oracle 9i Real Application Clusters")) {
                for (int i = 0; i < this.m_radio.length; ++i) {
                    if (!this.m_radio[i].getLabel().equals("  Oracle 9i Database")) continue;
                    this.m_radio[i].setEnabled(true);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_actnListener != null) {
            this.m_actnListener.actionPerformed(event);
        }
        Object source = event.getSource();
        OiifmCursorUtil.setCursor((int)3, (Component)((Object)this));
        if (source == this.m_infoButton) {
            // empty if block
        }
        OiifmCursorUtil.setCursor((int)0, (Component)((Object)this));
        if (source == this.m_infoButton) {
            this.m_infoButton.requestFocus();
        }
    }

    public static void main(String[] args) {
        Frame p = new Frame();
        OiMultiSelPanel top = new OiMultiSelPanel();
        p.add((Component)((Object)top));
        p.setSize(600, 400);
        p.show();
    }
}

