/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;

public class ReadOnlyBooleanInputHandler
extends BooleanInputHandler {
    public static int readOnlyRows;
    private static ReadOnlyBooleanInputHandler _sInputHandler;
    private static final int SPACE = 32;

    public void mousePressed(MouseEvent evt, Grid grid, int column, int row) {
        if ((evt.getModifiers() & 0x10) != 0) {
            this.toggleValue(grid, column, row);
        }
    }

    public void keyTyped(KeyEvent evt, Grid grid, int column, int row) {
        if (evt.getKeyChar() == ' ') {
            this.toggleValue(grid, column, row);
        }
    }

    private void toggleValue(Grid grid, int column, int row) {
        if (grid.fireCancelableCellEvent(column, row, 2019)) {
            return;
        }
        if (row < readOnlyRows) {
            return;
        }
        TwoDDataSource ds = grid.getDataSource();
        Object object = ds.getData(column, row);
        if (object == null) {
            ds.setData(column, row, (Object)Boolean.TRUE);
        } else if (((Boolean)object).booleanValue()) {
            ds.setData(column, row, (Object)Boolean.FALSE);
        } else {
            ds.setData(column, row, (Object)Boolean.TRUE);
        }
        grid.fireCellEvent(column, row, 2020);
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = new ReadOnlyBooleanInputHandler();
        }
        return _sInputHandler;
    }

    protected ReadOnlyBooleanInputHandler() {
    }
}

