/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmDirectoryDlg;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixPlatform;

public class SID2Migrate
extends OiifpWizPanel
implements TableRowSelectListener,
ActionListener,
ItemListener {
    private static final int DEF_PATH_SIZE = 350;
    private static final int DEF_SID_SIZE = 100;
    private static final String DEFAULT_TITLE = "Title";
    private static final String DEFAULT_PROMPT = "Prompt";
    private static final String[] HEADERS = new String[]{"SID", "Oracle Home Path"};
    private static final String[] DEF_LIST = new String[]{"scott", "/home/scott/oracle/scott/", "...", "..."};
    private static final String NT = "Windows NT";
    private static final String SOLARIS = "Solaris";
    private static final String SUNOS = "SunOS";
    private static final String HPUNIX = "HP-UX";
    private SpreadTable myTable;
    private ArrayTwoDDataSource myData;
    private ArrayOneDDataSource myHeader;
    private SingleRowSelection mySingleRowSelector;
    private MultiLineLabel myPrompt;
    private LWCheckbox myCheckbox;
    private String defcbLabel;
    private Color promptLabelColor;
    private boolean isUnix;
    private ScrollBox tableScroll;
    private LWTextField myTextSID;
    private LWTextField myTextOH;
    private LWButton browseButton;
    private Container frame;

    public SID2Migrate() {
        this("");
        this.setTitleLabel(DEFAULT_TITLE);
        this.setPrompt(DEFAULT_PROMPT);
        this.setTable(DEF_LIST);
        this.isUnix = OiixPlatform.isPlatInGroup((int)-1, (int)OiixPlatform.getCurrentPlatform());
        if (this.isUnix) {
            this.setSIDText((String)this.myData.getData(0, 0));
            this.setOHText((String)this.myData.getData(1, 0));
        }
    }

    public SID2Migrate(String promptString) {
        super(DEFAULT_TITLE);
        this.myPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), promptString);
        this.myPrompt.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this.myPrompt, (Object)"North");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.dlgPanel.setLayout((LayoutManager)gridbag);
        this.defcbLabel = "Default Text Should Not Appear";
        this.myCheckbox = new LWCheckbox(this.defcbLabel, false);
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 0, 10, 0);
        gridbag.setConstraints((Component)this.myCheckbox, c);
        this.myCheckbox.addItemListener((ItemListener)this);
        this.dlgPanel.add((Component)this.myCheckbox);
        this.myHeader = new ArrayOneDDataSource((Object[])HEADERS);
        this.myTable = new SpreadTable((TwoDDataSource)this.myData, (OneDDataSource)this.myHeader, null);
        this.mySingleRowSelector = new SingleRowSelection();
        this.myTable.setVerticalSeparatorsVisible(false);
        this.myTable.setHorizontalSeparatorsVisible(false);
        Grid grid = this.myTable.getGrid();
        grid.setGridSelection((GridSelection)this.mySingleRowSelector);
        this.mySingleRowSelector.setParent(grid);
        this.myTable.addRowSelectListener((TableRowSelectListener)this);
        this.tableScroll = new ScrollBox((Component)this.myTable, 0, 0);
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 20, 0);
        c.fill = 1;
        if (this.isUnix) {
            c.weightx = 1.0;
            c.weighty = 0.2;
        } else {
            c.weightx = 1.0;
            c.weighty = 0.4;
        }
        gridbag.setConstraints((Component)this.tableScroll, c);
        this.dlgPanel.add((Component)this.tableScroll);
        this.myTextSID = new LWTextField();
        this.myTextOH = new LWTextField();
        this.browseButton = new LWButton("Browse");
        if (this.isUnix) {
            c.fill = 2;
            c.gridwidth = 1;
            c.weightx = 0.4;
            c.weighty = 0.1;
            c.insets = new Insets(0, 0, 0, 5);
            gridbag.setConstraints((Component)this.myTextSID, c);
            this.dlgPanel.add((Component)this.myTextSID);
            c.weightx = 4.0;
            c.weighty = 0.1;
            c.insets = new Insets(0, 0, 0, 5);
            c.gridx = -1;
            gridbag.setConstraints((Component)this.myTextOH, c);
            this.dlgPanel.add((Component)this.myTextOH);
            this.frame = this;
            this.browseButton.addActionListener((ActionListener)this);
            c.weightx = 1.0;
            c.weighty = 0.1;
            c.fill = 0;
            c.gridx = -1;
            gridbag.setConstraints((Component)this.browseButton, c);
            this.dlgPanel.add((Component)this.browseButton);
        }
        if (!this.myCheckbox.getState()) {
            this.myTable.setEnabled(false);
            this.tableScroll.setEnabled(false);
            this.myTextSID.setEnabled(false);
            this.myTextOH.setEnabled(false);
            this.browseButton.setEnabled(false);
        }
        this.promptLabelColor = this.myPrompt.getBackground();
    }

    public void setPrompt(String text) {
        if (text != null) {
            this.myPrompt.setText(text);
        }
    }

    public void setCheckBoxLabel(String text) {
        if (text != null) {
            this.myCheckbox.setLabel(text);
        }
    }

    public void setTable(String[] list) {
        int rows = list.length / 2;
        this.myData = new ArrayTwoDDataSource(2, rows);
        int listIdx = 0;
        for (int rowIdx = 0; rowIdx < this.myData.getRowCount(); ++rowIdx) {
            for (int colIdx = 0; colIdx < this.myData.getColumnCount(); ++colIdx) {
                this.myData.setData(colIdx, rowIdx, (Object)list[listIdx]);
                ++listIdx;
            }
        }
        this.myTable.setDataSources((TwoDDataSource)this.myData, (OneDDataSource)this.myHeader, null);
        this.myTable.setColumnWidth(0, 100);
        this.myTable.setColumnWidth(1, 350);
        if (this.isUnix) {
            this.setSIDText((String)this.myData.getData(0, 0));
            this.setOHText((String)this.myData.getData(1, 0));
        }
    }

    public void setAnswer(String[] answer) {
        boolean rowSelected = false;
        if (answer.length != 0) {
            for (int rowIdx = 0; rowIdx < this.myData.getRowCount(); ++rowIdx) {
                if (!answer[0].equalsIgnoreCase((String)this.myData.getData(0, rowIdx))) continue;
                this.mySingleRowSelector.setRowSelected(rowIdx, true);
                rowSelected = true;
                break;
            }
        }
        if (!rowSelected) {
            this.mySingleRowSelector.setRowSelected(0, true);
        }
    }

    private void setOHText(String text) {
        if (text != null && this.isUnix) {
            this.myTextOH.setText(text);
        }
    }

    private void setSIDText(String text) {
        if (text != null && this.isUnix) {
            this.myTextSID.setText(text);
        }
    }

    public String[] getAnswer() {
        String[] ans = new String[]{this.sidAns(), this.ohAns()};
        return ans;
    }

    private String sidAns() {
        if (!this.myCheckbox.getState()) {
            return new String("<None>");
        }
        if (this.isUnix) {
            return this.myTextSID.getText();
        }
        int[] selectedRows = this.mySingleRowSelector.getSelectedRows();
        return (String)this.myData.getData(0, selectedRows[0]);
    }

    private String ohAns() {
        if (!this.myCheckbox.getState()) {
            return new String("<None>");
        }
        if (this.isUnix) {
            return this.myTextOH.getText();
        }
        int[] selectedRows = this.mySingleRowSelector.getSelectedRows();
        return (String)this.myData.getData(1, selectedRows[0]);
    }

    public String getCheckBoxValue() {
        return this.myCheckbox.getState() ? "Y" : "N";
    }

    public void setCheckBoxValue(String text) {
        this.setCheckBoxValue(text.equals("Y"));
    }

    public void setCheckBoxValue(boolean state) {
        this.myCheckbox.setState(state);
        this.myTable.setEnabled(state);
        this.tableScroll.setEnabled(state);
        this.myTextSID.setEnabled(state);
        this.myTextOH.setEnabled(state);
        this.browseButton.setEnabled(state);
    }

    public void markPrompt() {
        this.myPrompt.setBackground(this._markColor);
    }

    public void unmarkPrompt() {
        this.myPrompt.setBackground(this.promptLabelColor);
    }

    public void rowDeselected(TableEvent e) {
    }

    public void rowDeselecting(TableEvent e) {
    }

    public void rowSelecting(TableEvent e) {
    }

    public void rowSelected(TableEvent e) {
        int row = e.getRow();
        this.setSIDText((String)this.myData.getData(0, row));
        this.setOHText((String)this.myData.getData(1, row));
    }

    public void actionPerformed(ActionEvent e) {
        while (!(this.frame instanceof Frame)) {
            this.frame = this.frame.getParent();
        }
        String name = "Directory Dialog";
        OiifmDirectoryDlg fd = new OiifmDirectoryDlg((Frame)this.frame, name);
        File loc = new File(System.getProperty("user.dir"));
        File file = fd.runDialog(loc);
        if (file != null) {
            this.setOHText(file.getPath());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.myTable.setEnabled(true);
            this.tableScroll.setEnabled(true);
            this.myTextSID.setEnabled(true);
            this.myTextOH.setEnabled(true);
            this.browseButton.setEnabled(true);
        } else {
            this.myTable.setEnabled(false);
            this.tableScroll.setEnabled(false);
            this.myTextSID.setEnabled(false);
            this.myTextOH.setEnabled(false);
            this.browseButton.setEnabled(false);
        }
    }
}

