/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.oca.install;

import java.util.Vector;
import oracle.security.oca.install.OCAInvalidCNValueException;
import oracle.security.oca.install.OCAInvalidCValueException;
import oracle.security.oca.install.OCAInvalidDNFormatException;
import oracle.security.oca.install.OCAMissingOException;
import oracle.security.oca.install.OCANotSupportedRDNException;
import oracle.security.oca.install.OCANullDNException;

public class OCAValidateDN {
    private static final String[] countryLetters = new String[]{"AF", "AL", "DZ", "AD", "AO", "AI", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BA", "BW", "BR", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "CF", "TD", "CL", "CN", "CO", "KM", "CG", "CR", "CI", "HR", "CU", "CY", "CZ", "DK", "DJ", "DM", "DO", "TP", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GR", "GP", "GT", "GN", "GW", "GY", "HT", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MK", "MG", "MY", "ML", "MT", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "MS", "MA", "MZ", "MM", "NA", "NP", "NL", "AN", "NC", "NZ", "NI", "NE", "NG", "NU", "NO", "OM", "PK", "PA", "PG", "PY", "PE", "PH", "PL", "PT", "PR", "QA", "RO", "RU", "RW", "SA", "SN", "SP", "SC", "SL", "SG", "SK", "SI", "SO", "ZA", "ES", "LK", "SD", "SR", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "UG", "UA", "AE", "GB", "US", "UY", "UZ", "VU", "VA", "VE", "VN", "VG", "VI", "EH", "YE", "YU", "ZR", "ZM", "ZW"};

    public static String validate(String string) throws OCANullDNException, OCAInvalidDNFormatException, Exception {
        return OCAValidateDN.validate(string, null);
    }

    public static String validate(String string, String string2) throws OCANullDNException, OCAInvalidDNFormatException, OCAInvalidCNValueException, OCAInvalidCValueException, OCANotSupportedRDNException, OCAMissingOException {
        if (string == null) {
            throw new OCANullDNException();
        }
        Vector vector = OCAValidateDN.parse(string);
        String string3 = "";
        int n = vector.size();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = n - 1;
        while (n3 >= 0) {
            string4 = ((String)vector.elementAt(n3)).trim();
            n2 = string4.indexOf("=");
            string5 = string4.substring(0, n2);
            string6 = string4.substring(n2 + 1);
            if (string2 != null && string5.equalsIgnoreCase("cn") && string6.equalsIgnoreCase(string2)) {
                throw new OCAInvalidCNValueException("CA cannot have CN value as host name");
            }
            if (string5.equalsIgnoreCase("c")) {
                boolean bl2 = false;
                int n4 = 0;
                while (n4 < countryLetters.length) {
                    if (string6.equalsIgnoreCase(countryLetters[n4])) {
                        bl2 = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl2) {
                    throw new OCAInvalidCValueException("Country value is invalid");
                }
            }
            if (string5.equalsIgnoreCase("o")) {
                bl = true;
            }
            string3 = n3 == n - 1 ? string5 + "=" + string6 : string5 + "=" + string6 + "," + string3;
            --n3;
        }
        if (!bl) {
            throw new OCAMissingOException("RDN organization (O) is missing in DN");
        }
        return string3;
    }

    private static Vector parse(String string) throws OCAInvalidDNFormatException, OCANotSupportedRDNException {
        boolean bl = true;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (!OCAValidateDN.isWhitespace(string.charAt(n))) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        Vector<String> vector = new Vector<String>();
        while (n3 < string.length()) {
            String string2;
            String string3;
            char c = string.charAt(n3);
            char[] cArray = new char[]{c};
            String string4 = new String(cArray);
            if (string4.equals("\"") || string4.equals("'")) {
                if (n3 != 0 && n3 != string.length() - 1) {
                    bl2 = !bl2;
                    stringBuffer.append(c);
                }
            } else if (string4.equals(",") || string4.equals(";")) {
                if (bl2) {
                    stringBuffer.append(c);
                } else {
                    bl3 = true;
                }
            } else if (string4.equals("\\")) {
                stringBuffer.append(c);
                c = string.charAt(++n3);
                stringBuffer.append(c);
            } else {
                stringBuffer.append(c);
            }
            if (!bl3 && ++n3 != string.length()) continue;
            String string5 = stringBuffer.toString();
            int n4 = string5.indexOf("=");
            if (n4 != -1) {
                string3 = string5.substring(0, n4).trim();
                string2 = string5.substring(n4 + 1, string5.length()).trim();
                if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
                    throw new OCAInvalidDNFormatException("IncorrectDnFormat");
                }
                if (string3.compareToIgnoreCase("cn") != 0 && string3.compareToIgnoreCase("email") != 0 && string3.compareToIgnoreCase("o") != 0 && string3.compareToIgnoreCase("ou") != 0 && string3.compareToIgnoreCase("l") != 0 && string3.compareToIgnoreCase("st") != 0 && string3.compareToIgnoreCase("c") != 0 && string3.compareToIgnoreCase("dc") != 0) {
                    throw new OCANotSupportedRDNException("IncorrectDnFormat");
                }
            } else {
                throw new OCAInvalidDNFormatException("IncorrectDnFormat");
            }
            string5 = string3 + "=" + string2;
            vector.addElement(string5);
            stringBuffer = new StringBuffer();
            bl2 = false;
            bl3 = false;
        }
        return vector;
    }

    private static boolean isWhitespace(char c) {
        char[] cArray = new char[]{c};
        String string = new String(cArray);
        return string.equalsIgnoreCase(" ") || string.equalsIgnoreCase("\t") || string.equalsIgnoreCase("\r") || string.equalsIgnoreCase("\n");
    }
}

