/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmDirectoryDlg;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;

public class OiDirectoryPanel
extends OiifpWizPanel
implements ActionListener {
    private static final int INSETS = 5;
    private static final String DEFAULT_TITLE = OiStdDialogRes.getString("Directory_DefaultTitle");
    private static final String DEFAULT_PROMPT = OiStdDialogRes.getString("Directory_DefaultPrompt");
    private static final String DEFAULT_LABEL = OiStdDialogRes.getString("Directory_DefaultLabel");
    private static final String BROWSE_BUTTON = OiStdDialogRes.getString("Directory_Browse");
    private static final String CHOOSE_DIR = OiStdDialogRes.getString("Directory_DirectoryDlgTitle");
    private MultiLineLabel m_prompt = new MultiLineLabel(WordWrapper.getTextWrapper(), DEFAULT_PROMPT);
    private LWLabel m_textLabel;
    private LWTextField m_textField;
    private LWButton m_browse;
    private Color m_promptColor;
    private Color m_textLabelColor;
    private Color m_textFieldColor;

    public OiDirectoryPanel() {
        super(DEFAULT_TITLE);
        this.mainPanel.add((Component)this.m_prompt, (Object)"North");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.dlgPanel.setLayout((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.m_textLabel = new LWLabel(DEFAULT_LABEL);
        gridBagLayout.setConstraints((Component)this.m_textLabel, gridBagConstraints);
        this.dlgPanel.add((Component)this.m_textLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = -1;
        this.m_textField = new LWTextField();
        gridBagLayout.setConstraints((Component)this.m_textField, gridBagConstraints);
        this.dlgPanel.add((Component)this.m_textField);
        this.m_textLabel.setLabelFor((Component)this.m_textField);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        this.m_browse = new MyButton(BROWSE_BUTTON, this);
        this.m_browse.setRightmost(true);
        gridBagLayout.setConstraints((Component)this.m_browse, gridBagConstraints);
        this.dlgPanel.add((Component)this.m_browse);
        this.m_promptColor = this.m_prompt.getBackground();
        this.m_textLabelColor = this.m_textLabel.getBackground();
        this.m_textFieldColor = this.m_textField.getBackground();
        this.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_browse) {
            this.m_browse.setEnabled(false);
            this.onBrowse();
            this.m_browse.setEnabled(true);
        }
    }

    private void onBrowse() {
        File file;
        String string;
        OiipgFileSystem oiipgFileSystem = new OiipgFileSystem();
        OiifmDirectoryDlg oiifmDirectoryDlg = new OiifmDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), CHOOSE_DIR);
        oiifmDirectoryDlg.setMessage(this.getPrompt());
        oiifmDirectoryDlg.setCreateAllowed(true);
        DirectoryDrive[] directoryDriveArray = oiipgFileSystem.getDirectoryDrives();
        if (directoryDriveArray != null) {
            oiifmDirectoryDlg.setDrives(directoryDriveArray);
        }
        if ((string = this.getDirectory().trim()).length() == 0) {
            file = new File(System.getProperty("user.home"));
        } else {
            file = new File(string);
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"));
            }
        }
        Cursor cursor = Cursor.getPredefinedCursor(3);
        OiifmCursorUtil.setCursor((Cursor)cursor, (Component)((Object)this));
        File file2 = oiifmDirectoryDlg.runDialog(file);
        cursor = Cursor.getPredefinedCursor(0);
        OiifmCursorUtil.setCursor((Cursor)cursor, (Component)((Object)this));
        if (file2 != null) {
            String string2 = file2.getAbsolutePath();
            this.setDirectory(string2);
        }
    }

    public String getPrompt() {
        return this.m_prompt.getText();
    }

    public String getTextLabel() {
        return this.m_textLabel.getText();
    }

    public String getDirectory() {
        String string = this.m_textField.getText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setPrompt(String string) {
        this.invalidate();
        this.m_prompt.setText(string);
        this.validate();
    }

    public void setTextLabel(String string) {
        this.invalidate();
        this.m_textLabel.setText(string);
        this.validate();
    }

    public void setDirectory(String string) {
        if (string != null) {
            this.invalidate();
            this.m_textField.setText(string);
            this.validate();
        }
    }

    public void markPrompt() {
        this.m_prompt.setBackground(this._markColor);
    }

    public void markTextLabel() {
        this.m_textLabel.setBackground(this._markColor);
    }

    public void markDirectory() {
        this.m_textField.setBackground(this._markColor);
    }

    public void unmarkPrompt() {
        this.m_prompt.setBackground(this.m_promptColor);
    }

    public void unmarkTextLabel() {
        this.m_textLabel.setBackground(this.m_textLabelColor);
    }

    public void unmarkDirectory() {
        this.m_textField.setBackground(this.m_textFieldColor);
    }
}

