/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.collector.CollectorMsgID;
import oracle.sysman.ccr.collector.cmd.CommandDispatcher;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.AgentConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.JCEInitializationException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.util.UplinkPath;

public class Collector {
    private static final String SILENT_QUALIFIER = "silent";
    private static final String CONNECT_QUALIFIER = "connect";
    private static Logger s_log = null;
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.Collector");
    private static Boolean m_bFailOnError = null;
    public static final int ERR_NO_ORACLE_HOME = 1;
    public static final int ERR_UNABLE_TO_TRACE = 2;
    public static final int ERR_COMMAND_PROCESSING = 3;
    public static final int UPDATES_AVAILABLE = 5;
    public static final int LICENSE_DECLINED = 12;
    private static final String ENV_PERL5LIB = "PERL5LIB";
    private static boolean OCM_DISCONNECTED_MODE = false;
    private static boolean OCM_GRID_AGENT_REMOTE_MODE = false;
    public static final String ON_TARGET_LOCAL = "local";
    private static String OCM_GRID_AGENT_ON_TARGET = "local";
    private static final String ON_TARGET_QUALIFIER = "on_target";
    static String m_strOracleHome = null;
    static String m_strConfigHome = null;
    static String m_strCCRConfigHome = null;
    static HashMap s_hashQualifiers = new HashMap();
    static String m_strFullPath = null;
    static final int STDIN_READ_TIMEOUT = 2000;
    static boolean m_readAgentSeed = false;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$Collector;

    private static void checkForSignedLicenseAgreement() throws CCRException {
        if (UplinkPath.gridAgentMode()) {
            return;
        }
        Config config = UplinkHomeConfig.getInstance();
        String string = config.getProperty("ccr.agreement_signer");
        if (string == null || string.trim().length() == 0) {
            throw new CCRException("Unable to perform the requested operation.\nThe License Agreement has not been accepted.\nRe-run \"$ORACLE_HOME/ccr/bin/emCCR config\" and accept the license agreement.");
        }
    }

    private static void checkPERL5LIB(String[] stringArray) throws CCRException {
        String string = System.getProperty(ENV_PERL5LIB);
        if (string == null || string.trim().equals("")) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringBuffer.length() == 0 || stringBuffer.toString().equals("discover, collect, upload")) {
                stringBuffer = new StringBuffer("collect");
            }
            throw new CCRException(s_bundle.getMessage(CollectorMsgID.PERL5LIB_UNDEF, false, (Object[])new String[]{stringBuffer.toString()}));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void configLogging() {
        Config config = UplinkHomeConfig.getInstance();
        Properties properties = config.getProperties();
        Logger.init(properties);
        s_log = Logger.getRootLogger();
    }

    public static boolean failOnError() {
        if (m_bFailOnError == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector != null ? class$oracle$sysman$ccr$collector$Collector : (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector"));
            synchronized (clazz) {
                if (m_bFailOnError == null) {
                    Config config = UplinkHomeConfig.getInstance();
                    boolean bl = config.getProperty("ccr.fail_on_error", false);
                    String string = "false";
                    if (bl) {
                        string = "true";
                    }
                    m_bFailOnError = Boolean.valueOf(string);
                }
            }
        }
        return m_bFailOnError;
    }

    public static String getCCRConfigHome() {
        if (m_strCCRConfigHome == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector != null ? class$oracle$sysman$ccr$collector$Collector : (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector"));
            synchronized (clazz) {
                if (m_strCCRConfigHome == null) {
                    m_strCCRConfigHome = System.getProperty("CCR_CONFIG_HOME");
                }
            }
        }
        if (m_strCCRConfigHome == null) {
            throw new RuntimeException(s_bundle.getMessage(CollectorMsgID.ORACLE_HOME_UNDEF, false));
        }
        return m_strCCRConfigHome;
    }

    public static String getConfigHome() {
        if (m_strConfigHome == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector != null ? class$oracle$sysman$ccr$collector$Collector : (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector"));
            synchronized (clazz) {
                if (m_strConfigHome == null) {
                    m_strConfigHome = System.getProperty("ORACLE_CONFIG_HOME");
                }
            }
        }
        if (m_strConfigHome == null) {
            m_strConfigHome = "";
        }
        return m_strConfigHome;
    }

    public static String getFullPath() {
        if (m_strFullPath == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector != null ? class$oracle$sysman$ccr$collector$Collector : (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector"));
            synchronized (clazz) {
                if (m_strFullPath == null) {
                    m_strFullPath = System.getProperty("FULL_PATH");
                }
            }
        }
        if (m_strFullPath == null) {
            m_strFullPath = "";
        }
        return m_strFullPath;
    }

    public static String getGridAgentOnTarget() {
        return OCM_GRID_AGENT_ON_TARGET;
    }

    public static String getOracleHome() {
        if (m_strOracleHome == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector != null ? class$oracle$sysman$ccr$collector$Collector : (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector"));
            synchronized (clazz) {
                if (m_strOracleHome == null) {
                    m_strOracleHome = System.getProperty("ORACLE_HOME");
                }
            }
        }
        if (m_strOracleHome == null) {
            throw new RuntimeException(s_bundle.getMessage(CollectorMsgID.ORACLE_HOME_UNDEF, false));
        }
        return m_strOracleHome;
    }

    public static CommandQualifier getQualifier(String string) {
        return (CommandQualifier)s_hashQualifiers.get(string);
    }

    public static HashMap getQualifierMap() {
        return (HashMap)s_hashQualifiers.clone();
    }

    public static boolean isDisconnected() {
        return OCM_DISCONNECTED_MODE;
    }

    public static boolean isRemoteGridAgentMode() {
        return OCM_GRID_AGENT_REMOTE_MODE;
    }

    public static void logExceptionChainToStderr(CCRException cCRException) {
        Throwable throwable = cCRException;
        while (throwable != null) {
            System.err.println(throwable.getMessage());
            if (s_log != null) {
                s_log.error(CollectorMsgID.EXIT_ERROR_WRAPPER, new String[]{throwable.getMessage()});
            }
            if (throwable instanceof CCRException) {
                CCRException cCRException2 = throwable;
                throwable = cCRException2.getCause();
                continue;
            }
            throwable = null;
        }
    }

    public static void main(String[] stringArray) {
        Collector.getOracleHome();
        Collector.configLogging();
        Collector.readAgentSeed();
        String[] stringArray2 = Collector.parseCommandQualifiers(stringArray);
        Collector.setDisconnected();
        if (Collector.isDisconnected()) {
            OCMEndPoint.logConnectFailure();
        }
        if (!Collector.silentMode()) {
            System.out.println(s_bundle.getMessage(CollectorMsgID.BANNER, false));
        }
        s_log.info(CollectorMsgID.BANNER);
        Collector.setGridAgentOnTarget();
        int n = 0;
        try {
            Collector.checkPERL5LIB(stringArray2);
        }
        catch (CCRException cCRException) {
            System.err.println(cCRException.getMessage());
            if (s_log != null) {
                s_log.error(CollectorMsgID.EXIT_ERROR_WRAPPER, new String[]{cCRException.getMessage()});
            }
            n = 3;
        }
        try {
            if (n == 0) {
                UplinkSystemConfigWriter.getInstance();
                Collector.checkForSignedLicenseAgreement();
                CommandDispatcher commandDispatcher = CommandDispatcher.getInstance();
                commandDispatcher.addCommand(stringArray2);
                n = commandDispatcher.processRequests();
            }
        }
        catch (CCRException cCRException) {
            Collector.logExceptionChainToStderr(cCRException);
            n = Collector.qualifierSpecified("diagnostic") ? DiagnosticCmd.getDiagExitCode(cCRException) : 3;
        }
        catch (JCEInitializationException jCEInitializationException) {
            System.err.println(jCEInitializationException.getMessage());
            n = 3;
        }
        System.exit(n);
    }

    private static String[] parseCommandQualifiers(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (CommandQualifier.isQualifier(stringArray[n])) {
                CommandQualifier commandQualifier = new CommandQualifier(stringArray[n]);
                s_hashQualifiers.put(commandQualifier.getQualifierName(), commandQualifier);
            } else {
                vector.add(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean qualifierSpecified(String string) {
        return s_hashQualifiers.containsKey(string);
    }

    private static void readAgentSeed() {
        Object object;
        if (!UplinkPath.gridAgentMode()) {
            return;
        }
        m_readAgentSeed = false;
        int n = 0;
        try {
            n = System.in.available();
        }
        catch (IOException iOException) {}
        if (n > 0) {
            s_log.debug("Starting thread to read " + n + " bytes from stdin");
            object = new Thread(new ReadAgentSeed());
            ((Thread)object).start();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
        }
        if (!m_readAgentSeed) {
            object = null;
            object = Hostname.getHostname();
            if (object == null) {
                object = "Property";
            }
            String string = new String(String.valueOf(object) + (double)((String)object).length() * 1.5);
            s_log.debug("Setting agent seed to " + string);
            AgentConfig.setAgentSeed(string);
        }
    }

    public static void setDisconnected() {
        String string = UplinkHomeConfig.getInstance().getProperty("ccr.disconnected", "false");
        OCM_DISCONNECTED_MODE = string.equalsIgnoreCase("true") && !Collector.qualifierSpecified(CONNECT_QUALIFIER);
    }

    private static void setGridAgentOnTarget() {
        CommandQualifier commandQualifier = Collector.getQualifier(ON_TARGET_QUALIFIER);
        if (commandQualifier != null) {
            OCM_GRID_AGENT_ON_TARGET = commandQualifier.getQualifierValue();
            OCM_GRID_AGENT_REMOTE_MODE = true;
        }
    }

    public static boolean silentMode() {
        return Collector.qualifierSpecified(SILENT_QUALIFIER);
    }

    static class ReadAgentSeed
    implements Runnable {
        public void run() {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                s_log.debug("Reading agent see from stdin");
                String string = bufferedReader.readLine();
                if (string != null && (n = string.indexOf("=")) != -1 && string.length() > n + 1) {
                    m_readAgentSeed = true;
                    String string2 = string.substring(n + 1);
                    AgentConfig.setAgentSeed(string2);
                    s_log.debug("Read agent seed: " + string2);
                }
            }
            catch (IOException iOException) {
                s_log.debug("Error reading agent seed: " + iOException.getMessage());
            }
        }
    }
}

