/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import oracle.sysman.ccr.collector.cmd.CipherTextRegistrationInfo;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.countryCodes.CountryCode;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeException;
import oracle.sysman.ccr.collector.countryCodes.CountryCodeMap;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.CSIAuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;

public class CSIRegistrationInfo
extends CipherTextRegistrationInfo {
    private static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo != null ? class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo : (class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo = CSIRegistrationInfo.class$("oracle.sysman.ccr.collector.cmd.CSIRegistrationInfo")));
    private String m_strCSI;
    private String m_strMLID;
    private int m_nCC;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$CSIRegistrationInfo;

    CSIRegistrationInfo(String string, int n, String string2) {
        super(string2);
        this.m_strCSI = string;
        this.m_nCC = n;
        this.m_strMLID = "UNKNOWN";
    }

    CSIRegistrationInfo(String string, String string2, int n, String string3) {
        super(string3);
        this.m_strCSI = string;
        this.m_strMLID = string2;
        this.m_nCC = n;
    }

    public static CSIRegistrationInfo authenticateAndPersist(String string, int n, String string2) throws NetworkException, CommandException, FileWriteException, FileReadException {
        String string3 = new Integer(n).toString();
        try {
            CountryCodeMap countryCodeMap = CountryCodeMap.getInstance();
            string3 = countryCodeMap.getCountryCode(n);
        }
        catch (CountryCodeException countryCodeException) {}
        CSIRegistrationInfo.persistRegistrationInfo(string, string3, string2);
        return new CSIRegistrationInfo(string, n, string2);
    }

    public static CSIRegistrationInfo authenticateAndPersist(String string, String string2, String string3) throws NetworkException, CommandException, FileWriteException, FileReadException {
        Object object;
        OCMEndPoint oCMEndPoint = new OCMEndPoint(CollectorCmd.getEndpointAddr());
        int n = -1;
        try {
            object = CountryCodeMap.getInstance();
            CountryCode countryCode = ((CountryCodeMap)object).getCountryCode(string3);
            n = countryCode.getValue();
        }
        catch (CountryCodeException countryCodeException) {}
        object = oCMEndPoint.authenticateUser(string, string2, n);
        CSIRegistrationInfo.persistRegistrationInfo(string2, string3, (String)object);
        UplinkSystemConfig.reload();
        return new CSIRegistrationInfo(string2, string, n, (String)object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getCSI() {
        return this.m_strCSI;
    }

    public int getCountryCode() {
        return this.m_nCC;
    }

    public String getMLID() {
        return this.m_strMLID;
    }

    static void persistRegistrationInfo(String string, String string2, String string3) throws FileReadException, FileWriteException {
        ConfigWriter configWriter = UplinkSystemConfigWriter.getInstance();
        configWriter.remove("ccr.metalink_id", true);
        configWriter.remove("ccr.support_id", true);
        configWriter.remove("ccr.country_code", true);
        configWriter.setProperty("ccr.registration_mode", "csi");
        configWriter.setProperty("ccr.support_id", string);
        configWriter.setProperty("ccr.country_code", string2);
        configWriter.setProperty("ccr.registration_ct", string3);
        configWriter.persistProperties();
    }

    public void registerInstallation(OCMEndPoint oCMEndPoint, String string, String string2, String string3) throws AuthenticationFailure, NetworkException {
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Registering in CSI mode");
        }
        RegistrationKeyDoc registrationKeyDoc = oCMEndPoint.registerUser(this.getCipherText(), string, string2, string3);
        securityMgr.setAuthenticationKey(new CSIAuthenticationKey(registrationKeyDoc, this));
    }

    public int registrationType() {
        return 2;
    }
}

