/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectCommandException;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.softwareMgr.Component;
import oracle.sysman.ccr.collector.softwareMgr.SoftwareMgr;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class CollectCmd
extends CollectorCmd {
    static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$CollectCmd != null ? class$oracle$sysman$ccr$collector$cmd$CollectCmd : (class$oracle$sysman$ccr$collector$cmd$CollectCmd = CollectCmd.class$("oracle.sysman.ccr.collector.cmd.CollectCmd")));
    static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String DISCONNECTED_CONFIG_JAR = "ocmconfig.jar";
    public static final String COMMAND = "collect";
    public static final String ANNOTATION_QUALIFIER = "annotation";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$CollectCmd;

    public CollectCmd() {
    }

    public CollectCmd(boolean bl) {
        super(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void createConfigJar() throws CommandException {
        String string = FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_UPLOAD_PATH});
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".ser");
            }
        };
        FilenameFilter filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        };
        SoftwareMgr softwareMgr = SoftwareMgr.getInstance();
        Component[] componentArray = softwareMgr.getDeployedComponents();
        StringBuffer stringBuffer = new StringBuffer("Manifest-Version: 1.0\n");
        int n = 0;
        while (n < componentArray.length) {
            stringBuffer.append(componentArray[n].getComponentName()).append("-version: ").append(componentArray[n].getComponentVersion()).append("\n");
            ++n;
        }
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            string2 = "Windows";
        }
        stringBuffer.append("OracleHome: ").append(Collector.getOracleHome()).append("\n").append("HostName: ").append(Hostname.getHostname()).append("\n").append("OracleConfigHome: ").append(Collector.getConfigHome()).append("\n").append("platform: ").append(string2).append("\n").append("platform-version: ").append(System.getProperty("os.version")).append("\n").append("platform-arch: ").append(System.getProperty("os.arch")).append("\n");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        try {
            File file = new File(string);
            File file2 = new File(string, DISCONNECTED_CONFIG_JAR);
            File[] fileArray = file.listFiles(filenameFilter2);
            File[] fileArray2 = file.listFiles(filenameFilter);
            byte[] byArray = new byte[512];
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, new Manifest(byteArrayInputStream));
            int n2 = 0;
            while (n2 < fileArray.length) {
                int n3;
                JarEntry jarEntry = new JarEntry(fileArray[n2].getName());
                jarEntry.setTime(fileArray[n2].lastModified());
                jarOutputStream.putNextEntry(jarEntry);
                FileInputStream fileInputStream = new FileInputStream(fileArray[n2]);
                while ((n3 = fileInputStream.read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n3);
                }
                fileInputStream.close();
                fileArray[n2].deleteOnExit();
                fileArray2[n2].deleteOnExit();
                ++n2;
            }
            jarOutputStream.close();
            fileOutputStream.close();
        }
        catch (SecurityException securityException) {
            throw new CommandException("Access to upload dir denied by security manager: " + securityException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CommandException("File not found: " + fileNotFoundException.toString());
        }
        catch (ZipException zipException) {
            throw new CommandException("Error creating JAR: " + zipException.toString());
        }
        catch (IOException iOException) {
            throw new CommandException("IO exception in CollectCmd.createConfigJar: " + iOException.toString());
        }
        catch (Exception exception) {
            throw new CommandException("Error in CollectCmd.createConfigJar: " + exception.toString());
        }
    }

    public int processRequest() throws CommandException {
        try {
            this.preProcessRequest();
        }
        catch (AuthenticationFailure authenticationFailure) {
            throw new CollectCommandException("Unable to perform a configuration collection.", (Throwable)authenticationFailure);
        }
        TargetManager targetManager = TargetManager.getInstance();
        CollectionMgr collectionMgr = CollectionMgr.getInstance();
        collectionMgr.clearCollectionUpload();
        if (!UplinkPath.gridAgentMode()) {
            collectionMgr.clearCollectionReviewFiles();
        }
        if (Collector.isDisconnected()) {
            collectionMgr.clearCollectionState();
            String string = FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_UPLOAD_PATH});
            File file = new File(string, DISCONNECTED_CONFIG_JAR);
            if (file.exists()) {
                file.delete();
            }
        }
        targetManager.processTargets();
        targetManager.processTargetMetadata();
        collectionMgr.processCollections();
        collectionMgr.collectConfigMetricData();
        if (Collector.isDisconnected()) {
            CollectCmd.createConfigJar();
            targetManager.clearTemporaryCollectionState();
        }
        return 0;
    }

    public String toString() {
        return COMMAND;
    }
}

