/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.cmd.DiagClearCmd;
import oracle.sysman.ccr.collector.cmd.DiagStatusCmd;
import oracle.sysman.ccr.collector.cmd.DiagUploadCmd;
import oracle.sysman.ccr.collector.cmd.DiscoverCmd;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.collector.cmd.RegisterCmd;
import oracle.sysman.ccr.collector.cmd.TestCmd;
import oracle.sysman.ccr.collector.cmd.UpdateCmd;
import oracle.sysman.ccr.collector.cmd.UploadCmd;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.InvalidSessionException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.UploadReqExistsException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;

public class CommandDispatcher {
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.cmd.CollectorCmd");
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$CommandDispatcher != null ? class$oracle$sysman$ccr$collector$cmd$CommandDispatcher : (class$oracle$sysman$ccr$collector$cmd$CommandDispatcher = CommandDispatcher.class$("oracle.sysman.ccr.collector.cmd.CommandDispatcher")));
    private static CommandDispatcher m_instance = null;
    private ArrayList m_listCmds = new ArrayList();
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$CommandDispatcher;

    public void addCommand(String string, boolean bl) throws CommandException {
        s_log.info(CollectorCmdMsgID.RECVD_COMMAND, new String[]{string});
        if (string.equalsIgnoreCase("collect")) {
            this.addCommand(new CollectCmd(bl));
        } else if (string.equalsIgnoreCase("getupdates")) {
            this.addCommand(new UpdateCmd(bl));
        } else if (string.equalsIgnoreCase("upload")) {
            if (Collector.qualifierSpecified("diagnostic")) {
                this.addCommand(new DiagUploadCmd());
            } else {
                this.addCommand(new UploadCmd(bl));
            }
        } else if (string.equalsIgnoreCase("discover")) {
            this.addCommand(new DiscoverCmd(bl));
        } else if (string.equalsIgnoreCase("register")) {
            this.addCommand(new RegisterCmd(bl));
        } else if (string.equalsIgnoreCase("test")) {
            this.addCommand(new TestCmd(bl));
        } else if (string.equalsIgnoreCase("clear")) {
            this.addCommand(new DiagClearCmd());
        } else if (string.equalsIgnoreCase("status")) {
            this.addCommand(new DiagStatusCmd());
        } else {
            throw new CommandException("Invalid collector command specified. Commands must be in the set: register, discover, collect, getupdates, upload, test, clear, status");
        }
    }

    private void addCommand(CollectorCmd collectorCmd) {
        s_log.info(CollectorCmdMsgID.ADDING_COMMAND, new String[]{collectorCmd.toString()});
        this.m_listCmds.add(collectorCmd);
    }

    public void addCommand(String[] stringArray) throws CommandException {
        if (stringArray.length == 0) {
            this.addCommand(new UpdateCmd());
            this.addCommand(new DiscoverCmd());
            this.addCommand(new CollectCmd());
            this.addCommand(new UploadCmd());
        } else {
            int n = 0;
            while (n < stringArray.length) {
                this.addCommand(stringArray[n], true);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static synchronized CommandDispatcher getInstance() {
        if (m_instance == null) {
            m_instance = new CommandDispatcher();
        }
        return m_instance;
    }

    public int processRequests() throws CommandException, InvalidQualifierException, SRFormatException, PackageNotFoundException, InternalException, StateCreationException, StateAccessException, UploadReqExistsException, DuplicateUploadException, InvalidEndPointException, NetworkException, KeyMismatchException, AlreadyUploadedException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, SRClosedException, CSIMismatchException, InvalidPackageException {
        int n = 0;
        Iterator iterator = ((AbstractList)this.m_listCmds).iterator();
        while (iterator.hasNext() && n == 0) {
            CollectorCmd collectorCmd = (CollectorCmd)iterator.next();
            n = collectorCmd.processRequest();
        }
        return n;
    }
}

