/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.File;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.collector.cmd.UploadStatus;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagState;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.uploader.UploadState;
import oracle.sysman.ccr.diagnostic.uploader.UploaderMsgID;

public class DiagStatusCmd
extends DiagnosticCmd {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd != null ? class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd : (class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd = DiagStatusCmd.class$("oracle.sysman.ccr.collector.cmd.DiagStatusCmd")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.uploader.Uploader");
    private static MessageBundle s_cmdMsgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String COMMAND = "status";
    private File m_stateFile = null;
    private UploadState m_state = null;
    private boolean actionTaken = false;
    private HashMap m_uploadStatus = null;
    private int m_startTimeLen = 0;
    private int m_submitTimeLen = 0;
    private int m_updateTimeLen = 0;
    private int m_SRLen = 0;
    private int m_pkgNameLen = 0;
    private int m_restartCntLen = 0;
    private int m_statusLen = 0;
    private int m_timeElapsedLen = 0;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$DiagStatusCmd;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTimeElapsed() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        Date date = null;
        Date date2 = simpleDateFormat.parse(this.m_state.getSubmitTime());
        if (this.m_state.getState().equals("COMPLETED")) {
            if (this.m_state.getEndTime() == null) return "-";
            date = simpleDateFormat.parse(this.m_state.getEndTime());
        } else {
            date = new Date();
        }
        long l = date.getTime() - date2.getTime();
        long l2 = l / 3600000L;
        long l3 = (l %= 3600000L) / 60000L;
        long l4 = (l %= 60000L) / 1000L;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return new String(String.valueOf(decimalFormat.format(l2)) + ":" + decimalFormat.format(l3) + ":" + decimalFormat.format(l4));
    }

    private String getUploadStatus() {
        if (this.m_state.getState().equals("COMPLETED")) {
            return this.m_state.getState();
        }
        double d = (double)this.m_state.getProgress() / (double)this.m_state.getPackageSize() * 100.0;
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        String string = decimalFormat.format(d);
        if (this.m_state.getState().equals("STARTED")) {
            return String.valueOf(string) + "% DONE";
        }
        return String.valueOf(this.m_state.getState()) + " at " + string + "%";
    }

    private void printStatus() throws InvalidStateException {
        this.actionTaken = true;
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SR_NUMBER, false, new Object[]{this.m_stateFile.getParentFile().getName()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.PACKAGE_NAME, false, new Object[]{this.m_state.getPackageName()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.START_TIME, false, new Object[]{this.m_state.getStartTime()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SUBMIT_TIME, false, new Object[]{this.m_state.getSubmitTime()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.UPDATE_TIME, false, new Object[]{this.m_state.getUpdateTime()}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TOTAL_RESTARTS, false, new Object[]{Integer.toString(this.m_state.getRestartCount())}));
        System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.STATUS, false, new Object[]{this.getUploadStatus()}));
        try {
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TIME_ELAPSED, false, new Object[]{this.getTimeElapsed()}));
        }
        catch (ParseException parseException) {
            s_logger.error(parseException);
            String string = s_cmdMsgBundle.getMessage(UploaderMsgID.INVALID_UPLOAD_STATE, false);
            throw new InvalidStateException(DiagnosticCmd.prefixMsg(string, this.m_stateFile.getParentFile().getName(), this.m_state.getPackageName()));
        }
    }

    private void printStatusTable() {
        UploadStatus uploadStatus = null;
        Object[] objectArray = this.m_uploadStatus.keySet().toArray();
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            uploadStatus = (UploadStatus)this.m_uploadStatus.get(objectArray[n]);
            System.out.print(uploadStatus.m_SR);
            int n2 = 0;
            while (n2 < this.m_SRLen - uploadStatus.m_SR.length()) {
                System.out.print(" ");
                ++n2;
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_pkgName);
            int n3 = 0;
            while (n3 < this.m_pkgNameLen - uploadStatus.m_pkgName.length()) {
                System.out.print(" ");
                ++n3;
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_startTime);
            int n4 = 0;
            while (n4 < this.m_startTimeLen - uploadStatus.m_startTime.length()) {
                System.out.print(" ");
                ++n4;
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_submitTime);
            int n5 = 0;
            while (n5 < this.m_submitTimeLen - uploadStatus.m_submitTime.length()) {
                System.out.print(" ");
                ++n5;
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_updateTime);
            int n6 = 0;
            while (n6 < this.m_updateTimeLen - uploadStatus.m_updateTime.length()) {
                System.out.print(" ");
                ++n6;
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_restartCnt);
            int n7 = 0;
            while (n7 < this.m_restartCntLen - uploadStatus.m_restartCnt.length()) {
                System.out.print(" ");
                ++n7;
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_status);
            int n8 = 0;
            while (n8 < this.m_statusLen - uploadStatus.m_status.length()) {
                System.out.print(" ");
                ++n8;
            }
            System.out.print("  ");
            System.out.print(uploadStatus.m_timeElapsed);
            System.out.println();
            ++n;
        }
    }

    public int processRequest() throws InvalidQualifierException, SRFormatException, InvalidStateException, StateAccessException, NoSuchReqException {
        this.preProcessRequest();
        this.initializeParams();
        if (this.m_SRNumber != null && this.m_pkgName != null) {
            if (!this.isValidSRFormat(this.m_SRNumber)) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_SR_FORMAT, false);
                throw new SRFormatException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_pkgName));
            }
            this.m_stateFile = new File(UploadState.getStateFilePath(this.m_SRNumber, this.m_pkgName));
            if (s_logger.isDebugEnabled()) {
                s_logger.debug(DiagnosticCmd.prefixMsg("Processing state file: " + this.m_stateFile.getAbsolutePath(), this.m_SRNumber, this.m_pkgName));
            }
            try {
                this.m_state = new UploadState(this.m_stateFile);
            }
            catch (NoSuchReqException noSuchReqException) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug(noSuchReqException.getMessage());
                }
                String string = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ, false);
                throw new NoSuchReqException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_pkgName));
            }
            catch (InvalidStateException invalidStateException) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug(invalidStateException.getMessage());
                }
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_UPLOAD_STATE, false);
                throw new InvalidStateException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_pkgName));
            }
            this.printStatus();
        } else {
            if (!Collector.qualifierSpecified("diagnostic")) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_DIAG_QUAL, false);
                throw new InvalidQualifierException(string);
            }
            DiagState diagState = null;
            if (this.m_SRNumber != null) {
                if (!this.isValidSRFormat(this.m_SRNumber)) {
                    this.m_pkgName = "";
                    String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_SR_FORMAT, false);
                    throw new SRFormatException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_pkgName));
                }
                diagState = new DiagState(Collector.getCCRConfigHome(), this.m_SRNumber, false);
            } else {
                diagState = new DiagState(Collector.getCCRConfigHome(), false);
            }
            this.m_stateFile = diagState.getNextStateFile();
            if (this.m_stateFile != null) {
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                this.m_uploadStatus = new HashMap();
                string6 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TOTAL_RESTARTS_TOP, false);
                this.m_restartCntLen = string6.length();
                string5 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.PACKAGE_NAME_TOP, false);
                this.m_pkgNameLen = string5.length();
                string = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.START_TIME_TOP, false);
                this.m_startTimeLen = string.length();
                string2 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SUBMIT_TIME_TOP, false);
                this.m_submitTimeLen = string2.length();
                string3 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.UPDATE_TIME_TOP, false);
                this.m_updateTimeLen = string3.length();
                string8 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.TIME_ELAPSED_TOP, false);
                this.m_timeElapsedLen = string8.length();
                string7 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.STATUS_TOP, false);
                this.m_statusLen = string7.length();
                string4 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.SR_NUMBER_TOP, false);
                this.m_SRLen = string4.length();
                this.m_uploadStatus.put("", new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
                do {
                    try {
                        this.m_state = new UploadState(this.m_stateFile);
                        this.storeStatus();
                    }
                    catch (InvalidStateException invalidStateException) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug(invalidStateException.getMessage());
                        }
                        this.storeInvalidStatus();
                    }
                    catch (StateAccessException stateAccessException) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug(stateAccessException.getMessage());
                        }
                        this.storeAccessDeniedStatus();
                    }
                    catch (NoSuchReqException noSuchReqException) {
                        if (!s_logger.isDebugEnabled()) continue;
                        s_logger.debug(noSuchReqException.getMessage());
                    }
                } while ((this.m_stateFile = diagState.getNextStateFile()) != null);
                if (this.actionTaken) {
                    this.printStatusTable();
                }
            }
        }
        if (!this.actionTaken) {
            System.out.println();
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.NO_UPLOAD_REQ, false));
        }
        return 0;
    }

    private void storeAccessDeniedStatus() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.actionTaken = true;
        String string9 = this.m_stateFile.getName().substring(0, this.m_stateFile.getName().lastIndexOf("."));
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Handling inaccessible state: " + this.m_stateFile.getAbsolutePath(), this.m_stateFile.getParentFile().getName(), string9));
        }
        string = "";
        string2 = "";
        string3 = "";
        string4 = this.m_stateFile.getParentFile().getName();
        if (string4.length() > this.m_SRLen) {
            this.m_SRLen = string4.length();
        }
        if ((string5 = string9).length() > this.m_pkgNameLen) {
            this.m_pkgNameLen = string5.length();
        }
        string6 = "";
        String string10 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.ACCESS_DENIED, false);
        string7 = string10;
        if (string7.length() > this.m_statusLen) {
            this.m_statusLen = string7.length();
        }
        string8 = "";
        this.storeInHashMap(new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
    }

    private void storeInHashMap(UploadStatus uploadStatus) {
        String string = uploadStatus.m_SR;
        int n = 0;
        while (this.m_uploadStatus.containsKey(string)) {
            string = String.valueOf(string) + n;
            ++n;
        }
        this.m_uploadStatus.put(string, uploadStatus);
    }

    private void storeInvalidStatus() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.actionTaken = true;
        String string9 = this.m_stateFile.getName().substring(0, this.m_stateFile.getName().lastIndexOf("."));
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Handling invalid state file: " + this.m_stateFile.getAbsolutePath(), this.m_stateFile.getParentFile().getName(), string9));
        }
        string = "";
        string2 = "";
        string3 = "";
        string4 = this.m_stateFile.getParentFile().getName();
        if (string4.length() > this.m_SRLen) {
            this.m_SRLen = string4.length();
        }
        if ((string5 = string9).length() > this.m_pkgNameLen) {
            this.m_pkgNameLen = string5.length();
        }
        string6 = "";
        String string10 = s_cmdMsgBundle.getMessage(CollectorCmdMsgID.INVALID_STATE, false);
        string7 = string10;
        if (string7.length() > this.m_statusLen) {
            this.m_statusLen = string7.length();
        }
        string8 = "";
        this.storeInHashMap(new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
    }

    private void storeStatus() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.actionTaken = true;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagnosticCmd.prefixMsg("Retrieving data from state file: " + this.m_stateFile.getAbsolutePath(), this.m_stateFile.getParentFile().getName(), this.m_state.getPackageName()));
        }
        if ((string = this.m_state.getStartTime()).length() > this.m_startTimeLen) {
            this.m_startTimeLen = string.length();
        }
        if ((string2 = this.m_state.getSubmitTime()).length() > this.m_submitTimeLen) {
            this.m_submitTimeLen = string2.length();
        }
        if ((string3 = this.m_state.getUpdateTime()).length() > this.m_updateTimeLen) {
            this.m_updateTimeLen = string3.length();
        }
        if ((string4 = this.m_stateFile.getParentFile().getName()).length() > this.m_SRLen) {
            this.m_SRLen = string4.length();
        }
        if ((string5 = this.m_state.getPackageName()).length() > this.m_pkgNameLen) {
            this.m_pkgNameLen = string5.length();
        }
        string6 = Integer.toString(this.m_state.getRestartCount());
        String string9 = this.getUploadStatus();
        string7 = string9;
        if (string7.length() > this.m_statusLen) {
            this.m_statusLen = string7.length();
        }
        try {
            string9 = this.getTimeElapsed();
        }
        catch (ParseException parseException) {
            s_logger.error(parseException);
            string9 = "-";
        }
        string8 = string9;
        if (string8.length() > this.m_timeElapsedLen) {
            this.m_timeElapsedLen = string8.length();
        }
        this.storeInHashMap(new UploadStatus(string, string2, string3, string4, string5, string6, string7, string8));
    }

    public String toString() {
        return COMMAND;
    }
}

