/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.io.File;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmdMsgID;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.InvalidSessionException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.UploadReqExistsException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.diagnostic.uploader.Uploader;
import oracle.sysman.ccr.diagnostic.uploader.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.uploader.ValidationRequest;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;

public class DiagUploadCmd
extends DiagnosticCmd {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd != null ? class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd : (class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd = DiagUploadCmd.class$("oracle.sysman.ccr.collector.cmd.DiagUploadCmd")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.uploader.Uploader");
    private static MessageBundle s_cmdMsgBundle = MessageBundle.getInstance("oracle.sysman.ccr.collector.cmd.CollectorCmd");
    public static final String COMMAND = "diagupload";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$DiagUploadCmd;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int processRequest() throws InvalidQualifierException, SRFormatException, PackageNotFoundException, InternalException, StateCreationException, StateAccessException, UploadReqExistsException, DuplicateUploadException, InvalidEndPointException, NetworkException, KeyMismatchException, AlreadyUploadedException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, CredentialsNotFoundException, InvalidCredentialsException, UploadReqExistsException, SRClosedException, CSIMismatchException, InvalidPackageException {
        int n;
        Object object;
        Object object2;
        try {
            this.preProcessRequest();
            this.initializeParams();
            if (this.m_SRNumber == null && this.m_pkgName == null) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_SR_FILE, false);
                throw new InvalidQualifierException(string);
            }
            if (this.m_pkgName == null) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_FILE, false);
                throw new InvalidQualifierException(string);
            }
            if (!this.isValidSRFormat(this.m_SRNumber)) {
                String string = s_msgBundle.getMessage(UploaderMsgID.INVALID_SR_FORMAT, false);
                throw new SRFormatException(DiagnosticCmd.prefixMsg(string, this.m_SRNumber, this.m_pkgName));
            }
            if (Collector.qualifierSpecified("restart")) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug(DiagnosticCmd.prefixMsg("Restarting diagnsotic upload.", this.m_SRNumber, this.m_pkgName));
                }
                object2 = new Uploader(this.m_SRNumber, this.m_pkgName);
                ((Uploader)object2).restart();
            } else {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug(DiagnosticCmd.prefixMsg("Starting diagnsotic upload.", this.m_SRNumber, this.m_pkgName));
                }
                object2 = new ValidationRequest();
                ((ValidationRequest)object2).prepareValidationRequest(this.m_SRNumber);
                object = new Uploader(this.m_SRNumber, this.m_pkgName);
                ((Uploader)object).start((ValidationRequest)object2);
            }
            System.out.println();
            System.out.println(s_cmdMsgBundle.getMessage(CollectorCmdMsgID.CMD_SUCCESS, false));
            n = 0;
            Object var3_9 = null;
            if (this.m_SRNumber == null) return n;
        }
        catch (Throwable throwable) {
            File file;
            String string;
            Object var3_10 = null;
            if (this.m_SRNumber == null || (string = DiagnosticCmd.getCRDFilePath(this.m_SRNumber)) == null || (file = new File(string)).delete()) throw throwable;
            file.deleteOnExit();
            throw throwable;
        }
        object2 = DiagnosticCmd.getCRDFilePath(this.m_SRNumber);
        if (object2 == null || ((File)(object = new File((String)object2))).delete()) return n;
        ((File)object).deleteOnExit();
        return n;
    }

    public String toString() {
        return COMMAND;
    }
}

