/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cmd;

import java.util.HashMap;
import java.util.Iterator;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cmd.CollectorCmd;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.cmd.InvalidQualifierException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.UploadReqExistsException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.diagnostic.uploader.UploaderMsgID;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.ServerAccessException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class DiagnosticCmd
extends CollectorCmd {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$collector$cmd$DiagnosticCmd != null ? class$oracle$sysman$ccr$collector$cmd$DiagnosticCmd : (class$oracle$sysman$ccr$collector$cmd$DiagnosticCmd = DiagnosticCmd.class$("oracle.sysman.ccr.collector.cmd.DiagnosticCmd")));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.uploader.Uploader");
    protected String m_SRNumber = null;
    protected String m_pkgName = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cmd$DiagnosticCmd;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private HashMap extractParams(String string) {
        RE rE;
        HashMap<String, String> hashMap;
        block3: {
            hashMap = new HashMap<String, String>();
            rE = null;
            try {
                rE = new RE("\\(?([^=]*)=([^,)]*)");
            }
            catch (RESyntaxException rESyntaxException) {
                if (!s_logger.isDebugEnabled()) break block3;
                s_logger.debug(DiagnosticCmd.prefixMsg(rESyntaxException.getMessage(), this.m_SRNumber, this.m_pkgName));
            }
        }
        int n = 0;
        while (rE.match(string, n)) {
            hashMap.put(rE.getParen(1).toUpperCase(), rE.getParen(2));
            n = rE.getParenEnd(2) + 1;
        }
        return hashMap;
    }

    public static String getCRDFilePath(String string) {
        if (string == null) {
            return null;
        }
        return FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_DIAGNOSTIC_PATH, string, String.valueOf(string) + ".crd"});
    }

    public static int getDiagExitCode(Exception exception) {
        int n = 56;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Retrieving diagnostic exit code for exception: " + exception);
        }
        if (exception instanceof InvalidQualifierException) {
            n = 55;
        } else if (exception instanceof InvalidSRException) {
            n = 60;
        } else if (exception instanceof SRFormatException) {
            n = 51;
        } else if (exception instanceof InvalidEndPointException) {
            n = 68;
        } else if (exception instanceof InternalException) {
            n = 56;
        } else if (exception instanceof SessionTimeoutLimitException) {
            n = 63;
        } else if (exception instanceof ServerAccessException) {
            n = 61;
        } else if (exception instanceof NetworkException) {
            n = 62;
        } else if (exception instanceof MessageFormatException) {
            n = 69;
        } else if (exception instanceof InvalidRequestException) {
            n = 69;
        } else if (exception instanceof NotSupportedException) {
            n = 72;
        } else if (exception instanceof KeyMismatchException) {
            n = 22;
        } else if (exception instanceof InvalidResponseException) {
            n = 67;
        } else if (exception instanceof ServerException) {
            n = 70;
        } else if (exception instanceof NoSuchReqException) {
            n = 52;
        } else if (exception instanceof AlreadyUploadedException) {
            n = 54;
        } else if (exception instanceof UploadReqExistsException) {
            n = 65;
        } else if (exception instanceof DuplicateUploadException) {
            n = 64;
        } else if (exception instanceof PackageAccessException) {
            n = 59;
        } else if (exception instanceof PackageNotFoundException) {
            n = 58;
        } else if (exception instanceof PackageModifiedException) {
            n = 66;
        } else if (exception instanceof InvalidPackageException) {
            n = 76;
        } else if (exception instanceof InvalidStateException) {
            n = 53;
        } else if (exception instanceof StateCreationException) {
            n = 71;
        } else if (exception instanceof StateAccessException) {
            n = 57;
        } else if (exception instanceof InvalidCredentialsException) {
            n = 73;
        } else if (exception instanceof CredentialsNotFoundException) {
            n = 74;
        } else if (exception instanceof SRClosedException) {
            n = 75;
        } else if (exception instanceof CSIMismatchException) {
            n = 60;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Diagnostic exit code for exception is: " + n);
        }
        return n;
    }

    protected void initializeParams() throws InvalidQualifierException {
        CommandQualifier commandQualifier = Collector.getQualifier("diagnostic");
        if (commandQualifier == null) {
            return;
        }
        String string = commandQualifier.getQualifierValue();
        if (string != null) {
            HashMap hashMap = this.extractParams(string);
            this.m_SRNumber = (String)hashMap.get("SR");
            this.m_pkgName = (String)hashMap.get("FILE");
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Extracted SR: " + this.m_SRNumber + ", FILE: " + this.m_pkgName);
            }
            if (this.m_SRNumber == null && this.m_pkgName == null) {
                String string2 = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_SR_FILE, false);
                throw new InvalidQualifierException(string2);
            }
            if (this.m_SRNumber == null) {
                String string3 = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_NO_SR, false);
                throw new InvalidQualifierException(string3);
            }
        }
    }

    protected boolean isValidSRFormat(String string) {
        block3: {
            RE rE = null;
            try {
                rE = new RE("^([0-9]+\\.[0-9]{1,3})$");
                if (rE.match(string) && string.length() == rE.getParen(1).length()) {
                    return true;
                }
            }
            catch (RESyntaxException rESyntaxException) {
                if (!s_logger.isDebugEnabled()) break block3;
                s_logger.debug(DiagnosticCmd.prefixMsg(rESyntaxException.getMessage(), this.m_SRNumber, this.m_pkgName));
            }
        }
        return false;
    }

    protected void preProcessRequest() throws InvalidQualifierException {
        this.validateQualifiers();
    }

    public static String prefixMsg(String string, String string2, String string3) {
        String string4 = s_msgBundle.getMessage(UploaderMsgID.COMMON_MSG_PREFIX, false, new Object[]{string2, string3});
        return String.valueOf(string4) + string;
    }

    private void validateQualifiers() throws InvalidQualifierException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Validating qualifiers...");
        }
        HashMap hashMap = Collector.getQualifierMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Validating qualifier: " + string);
            }
            if ("completed".equalsIgnoreCase(string) || "diagnostic".equalsIgnoreCase(string) || "restart".equalsIgnoreCase(string) || "force".equalsIgnoreCase(string) || "silent".equalsIgnoreCase(string) || "nointeractive".equalsIgnoreCase(string)) continue;
            String string2 = s_msgBundle.getMessage(UploaderMsgID.INVALID_COMMAND_QUAL, false, new Object[]{string});
            throw new InvalidQualifierException(string2);
        }
    }
}

